public class B_OneType {
	public static void main(String[] args) {
		IntSet numbers= new IntArraySet();
		numbers.add(2);
		numbers.add(1);
		numbers.add(1);
		numbers.add(0);
		System.out.println(numbers);

		StringSet words= new StringArraySet();
		words.add("I");
		words.add("<3");
		words.add("Java");
		System.out.println(words);
	}
}

/* Now we need one version our set code for integers... */

interface IntSet {
	void add(Integer i);
}

class IntArraySet implements IntSet {
	private Integer[] storage= new Integer[0];

	@Override
	public void add(Integer value) {
		for (int i= 0; i < storage.length; ++i) {
			if (storage[i] == value) {
				// Already in the set.
				return;
			}
		}

		// Not in the set yet.
		Integer[] newStorage= new Integer[storage.length + 1];
		System.arraycopy(storage, 0, newStorage, 0, storage.length);
		newStorage[storage.length]= value;
		storage= newStorage;
	}

	@Override
	public String toString() {
		String out= "[";
		for (int i= 0; i < storage.length; ++i) {
			if (storage[i] == null) {
				out+= "null";
			} else {
				out+= storage[i].toString();
			}
			if (i != storage.length - 1) {
				out+= ", ";
			}
		}
		out+= "]";
		return out;
	}
}

/* ...and one for strings. */

interface StringSet {
	void add(String i);
}

class StringArraySet implements StringSet {
	private String[] storage= new String[0];

	@Override
	public void add(String value) {
		for (int i= 0; i < storage.length; ++i) {
			if (storage[i] == value) {
				// Already in the set.
				return;
			}
		}

		// Not in the set yet.
		String[] newStorage= new String[storage.length + 1];
		System.arraycopy(storage, 0, newStorage, 0, storage.length);
		newStorage[storage.length]= value;
		storage= newStorage;
	}

	@Override
	public String toString() {
		String out= "[";
		for (int i= 0; i < storage.length; ++i) {
			if (storage[i] == null) {
				out+= "null";
			} else {
				out+= storage[i].toString();
			}
			if (i != storage.length - 1) {
				out+= ", ";
			}
		}
		out+= "]";
		return out;
	}
}
