/** An instance is a dog that does or doesn't bark. */
public class Dog extends Animal {

	/** True if this dog barks, false otherwise (some dogs don't bark). */
	private boolean itBarks;

	/** A dog with age a. It barks iff b is true. */
	public Dog(int a, boolean b) {
		super(a);
		itBarks= b;
	}

	/** = "this dog barks". */
	public boolean getBarks() {
		return itBarks;
	}

	/** = a string representation of this dog. */
	public @Override String toString() {
		return super.toString() + ", who " +
			(itBarks ? "barks" : "doesn't bark");
	}

	/** return true iff this and obj are of the same class and <br>
	 * they both bark or both don't bark. */
	public @Override boolean equals(Object obj) {
		if (!super.equals(obj)) return false;
		return itBarks == ((Dog) obj).itBarks;
	}
}
