/** An instance is a cat who purrs a certain number of minutes each day. */
public class Cat extends Animal {
	/** The number of minutes this cat purrs per day. */
	private int purrs;

	/** A cat with age a and purrs p minutes. */
	public Cat(int a, int p) {
		super(a);
		purrs= p;
	}

	/** = the number of minutes this cat spends purring every day. */
	public int getPurrs() {
		return purrs;
	}

	/** = a string representation of this cat. */
	public @Override String toString() {
		return super.toString() + ", who purrs " + purrs + " minutes";
	}

	/** return true iff this and obj are of the same class and <br>
	 * they both purr the same minutes of the day. */
	public @Override boolean equals(Object obj) {
		if (!super.equals(obj)) return false;
		return purrs == ((Cat) obj).purrs;
	}
}
