/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import edu.rice.cs.cunit.concJUnit.LuckyError;
import edu.rice.cs.cunit.concJUnit.MultithreadedTestError;
import edu.rice.cs.cunit.concJUnit.NoJoinError;
import edu.rice.cs.cunit.concJUnit.TestThreadGroup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private String fName;

    public TestCase() {
        this.fName = null;
    }

    public TestCase(String name) {
        this.fName = name;
    }

    public int countTestCases() {
        return 1;
    }

    protected TestResult createResult() {
        return new TestResult();
    }

    public TestResult run() {
        TestResult result = this.createResult();
        this.run(result);
        return result;
    }

    public void run(TestResult result) {
        result.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runBare() throws Throwable {
        boolean checkLucky;
        boolean useThreadGroup = TestThreadGroup.isCheckThreadsEnabled() && (this.fName == null || !this.fName.endsWith("_NOTHREAD"));
        boolean checkJoin = useThreadGroup && TestThreadGroup.isCheckJoinEnabled() && (this.fName == null || !this.fName.endsWith("_NOJOIN"));
        boolean bl = checkLucky = checkJoin && TestThreadGroup.isCheckLuckyEnabled() && (this.fName == null || !this.fName.endsWith("_NOLUCKY"));
        if (useThreadGroup) {
            String prevSunHandler = System.getProperty("sun.awt.exception.handler");
            try {
                final TestThreadGroup tg = new TestThreadGroup();
                TestThreadGroup.setCurrentThreadGroup(tg);
                System.setProperty("sun.awt.exception.handler", TestThreadGroup.AwtHandler.class.getName());
                this.setUp();
                Thread t = new Thread(tg, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Throwable exception = null;
                        try {
                            TestCase.this.runTest();
                        }
                        catch (Throwable running) {
                            exception = running;
                        }
                        finally {
                            block13: {
                                try {
                                    TestCase.this.tearDown();
                                }
                                catch (Throwable tearingDown) {
                                    if (exception != null) break block13;
                                    exception = tearingDown;
                                }
                            }
                        }
                        if (exception != null) {
                            throw new WrappedException(exception);
                        }
                        tg.notifyEvent();
                    }
                }, "Concutest-JUnit-" + (this.fName != null ? this.fName : "test"));
                t.setDaemon(false);
                t.start();
                try {
                    tg.waitForEvent();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        throw new MultithreadedTestError("After the test had finished, the join operation with the test thread was interrupted (probably a bug in Concutest-JUnit)", e);
                    }
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e1) {
                        throw new MultithreadedTestError("After the test had been interrupted, the join operation with the test thread was interrupted (probably a bug in Concutest-JUnit)", e);
                    }
                }
                if (tg.getUncaughtThread() != null) {
                    try {
                        tg.getUncaughtThread().join(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new MultithreadedTestError("After the test threw an exception and died, the join operation with the test thread was interrupted (probably a bug in Concutest-JUnit)", e);
                    }
                }
                if (tg.getUncaughtException() != null) {
                    Throwable tgException = tg.getUncaughtException();
                    if (tgException instanceof WrappedException) {
                        tgException = tgException.getCause();
                    }
                    if (tgException == null) throw tgException;
                    try {
                        TestThreadGroup.extendStackTrace(tgException, tg.getUncaughtThread());
                        throw tgException;
                    }
                    catch (TestThreadGroup.LuckyWarningsDisabledException e) {
                        // empty catch block
                    }
                    throw tgException;
                }
                if (!checkJoin) return;
                Thread[] alive = TestThreadGroup.checkThreadsAlive(tg, t);
                if (alive.length > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.fName);
                    sb.append(": The test did not perform a join on all spawned threads.");
                    try {
                        String cc = TestThreadGroup.getThreadStartStackTrace(alive[0]);
                        throw new NoJoinError(sb.toString(), cc);
                    }
                    catch (TestThreadGroup.LuckyWarningsDisabledException e) {
                        throw new NoJoinError(sb.toString());
                    }
                }
                if (!checkLucky) return;
                try {
                    HashSet<Thread> threadsStarted = TestThreadGroup.collectThreads(t, "threadsStarted");
                    HashSet<Thread> threadsJoined = TestThreadGroup.collectThreads(t, "threadsJoined");
                    for (Thread ct : threadsStarted) {
                        if (!TestThreadGroup.shouldIgnoreThread(ct)) continue;
                        HashSet<Thread> threadsJoinedByIgnored = TestThreadGroup.collectThreads(ct, "threadsJoined");
                        threadsJoined.addAll(threadsJoinedByIgnored);
                    }
                    HashSet<Thread> threadsNotJoined = new HashSet<Thread>(threadsStarted);
                    threadsNotJoined.removeAll(threadsJoined);
                    HashSet<Thread> threadsInViolation = new HashSet<Thread>(threadsNotJoined);
                    for (Thread ct : threadsNotJoined) {
                        if (!TestThreadGroup.shouldIgnoreThread(ct)) continue;
                        threadsInViolation.remove(ct);
                    }
                    if (threadsInViolation.size() <= 0) return;
                    StringBuilder sb = new StringBuilder(this.fName + ": Some spawned threads ended before the test was over, but the test did not join with them:");
                    for (Thread ct : threadsInViolation) {
                        sb.append('\n');
                        sb.append(ct);
                        sb.append(":\n");
                        sb.append(TestThreadGroup.getThreadStartStackTrace(ct));
                    }
                    throw new LuckyError(sb.toString(), TestThreadGroup.getThreadStartStackTrace(threadsInViolation.iterator().next()));
                }
                catch (TestThreadGroup.LuckyWarningsDisabledException e) {
                    System.err.println("Disabled \"lucky\" warnings: " + e);
                }
                return;
            }
            finally {
                if (prevSunHandler != null) {
                    System.setProperty("sun.awt.exception.handler", prevSunHandler);
                } else {
                    System.setProperty("sun.awt.exception.handler", TestThreadGroup.DummyHandler.class.getName());
                }
            }
        }
        this.setUp();
        Throwable exception = null;
        try {
            this.runTest();
        }
        catch (Throwable running) {
            exception = running;
        }
        finally {
            block40: {
                try {
                    this.tearDown();
                }
                catch (Throwable tearingDown) {
                    if (exception != null) break block40;
                    exception = tearingDown;
                }
            }
        }
        if (exception == null) return;
        throw exception;
    }

    protected void runTest() throws Throwable {
        TestCase.assertNotNull("TestCase.fName cannot be null", this.fName);
        Method runMethod = null;
        try {
            runMethod = this.getClass().getMethod(this.fName, null);
        }
        catch (NoSuchMethodException e) {
            TestCase.fail("Method \"" + this.fName + "\" not found");
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            TestCase.fail("Method \"" + this.fName + "\" should be public");
        }
        try {
            runMethod.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public String toString() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public static class WrappedException
    extends RuntimeException {
        public WrappedException(Throwable cause) {
            super(cause);
        }
    }
}

