/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.text;

import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import edu.rice.cs.util.text.DocumentEditCondition;
import edu.rice.cs.util.text.EditDocumentException;
import edu.rice.cs.util.text.EditDocumentInterface;
import java.awt.print.Pageable;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;

public class SwingDocument
extends DefaultStyledDocument
implements EditDocumentInterface,
AbstractDocumentInterface {
    protected volatile boolean _isModifiedSinceSave = false;
    protected final HashMap<String, AttributeSet> _styles = new HashMap();
    protected DocumentEditCondition _condition = new DocumentEditCondition();

    public void setDocStyle(String name, AttributeSet s) {
        this._styles.put(name, s);
    }

    public AttributeSet getDocStyle(String name) {
        return this._styles.get(name);
    }

    public void addColoring(int start, int end, String style) {
    }

    @Override
    public DocumentEditCondition getEditCondition() {
        return this._condition;
    }

    @Override
    public void setEditCondition(DocumentEditCondition condition) {
        this._condition = condition;
    }

    public void clear() {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void insertText(int offs, String str, String style) {
        if (this._condition.canInsertText(offs)) {
            this.forceInsertText(offs, str, style);
        }
    }

    @Override
    public void forceInsertText(int offs, String str, String style) {
        int len = this.getLength();
        if (offs < 0 || offs > len) {
            String msg = "Offset " + offs + " passed to SwingDocument.forceInsertText is out of bounds [0, " + len + "]";
            throw new EditDocumentException(null, msg);
        }
        AttributeSet s = null;
        if (style != null) {
            s = this.getDocStyle(style);
        }
        try {
            super.insertString(offs, str, s);
        }
        catch (BadLocationException e) {
            throw new EditDocumentException(e);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet set) throws BadLocationException {
        if (this._condition.canInsertText(offs)) {
            super.insertString(offs, str, set);
        }
    }

    @Override
    public void removeText(int offs, int len) {
        if (this._condition.canRemoveText(offs)) {
            this.forceRemoveText(offs, len);
        }
    }

    @Override
    public void forceRemoveText(int offs, int len) {
        try {
            super.remove(offs, len);
        }
        catch (BadLocationException e) {
            throw new EditDocumentException(e);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this._condition.canRemoveText(offs)) {
            super.remove(offs, len);
        }
    }

    @Override
    public String getDocText(int offs, int len) {
        try {
            return this.getText(offs, len);
        }
        catch (BadLocationException e) {
            throw new EditDocumentException(e);
        }
    }

    @Override
    public String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public String _getText(int pos, int len) {
        try {
            return this.getText(pos, len);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void append(String str, AttributeSet set) {
        try {
            this.insertString(this.getLength(), str, set);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void append(String str, String style) {
        this.append(str, style == null ? null : this.getDocStyle(style));
    }

    public void append(String str) {
        this.append(str, (AttributeSet)null);
    }

    @Override
    public String getDefaultStyle() {
        return null;
    }

    @Override
    public void print() {
        throw new UnsupportedOperationException("Printing not supported");
    }

    @Override
    public Pageable getPageable() {
        throw new UnsupportedOperationException("Printing not supported");
    }

    public Position createUnwrappedPosition(int offs) throws BadLocationException {
        return super.createPosition(offs);
    }
}

