/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.Icon;

public class CenteredIcon
implements Icon {
    private Icon _base;
    private int _w = 0;
    private int _h = 0;

    public CenteredIcon(Icon base, int width, int height) {
        this._base = base;
        this._w = width;
        this._h = height;
    }

    @Override
    public int getIconHeight() {
        return this._h;
    }

    @Override
    public int getIconWidth() {
        return this._w;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Shape oldClip = g.getClip();
        g.setClip(x, y, this._w, this._h);
        int centerX = x + this._w / 2;
        int centerY = y + this._h / 2;
        int subRadX = this._base.getIconWidth() / 2;
        int subRadY = this._base.getIconHeight() / 2;
        this._base.paintIcon(c, g, centerX - subRadX, centerY - subRadY);
        g.setClip(oldClip);
    }

    public Icon getBaseIcon() {
        return this._base;
    }
}

