/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.util.newjvm.MasterRemote;
import edu.rice.cs.util.newjvm.SlaveRemote;
import java.rmi.RemoteException;

public abstract class AbstractSlaveJVM
implements SlaveRemote {
    public static final int CHECK_MAIN_VM_ALIVE_SECONDS = 1;
    private final String _quitSlaveThreadName;
    private final String _pollMasterThreadName;
    private boolean _started;

    public AbstractSlaveJVM() {
        this("Quit SlaveJVM Thread", "Poll MasterJVM Thread");
    }

    public AbstractSlaveJVM(String quitSlaveThreadName, String pollMasterThreadName) {
        this._quitSlaveThreadName = quitSlaveThreadName;
        this._pollMasterThreadName = pollMasterThreadName;
        this._started = false;
    }

    @Override
    public final synchronized void quit() {
        this.beforeQuit();
        new Thread(this._quitSlaveThreadName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractSlaveJVM abstractSlaveJVM = AbstractSlaveJVM.this;
                synchronized (abstractSlaveJVM) {
                    try {
                        System.exit(0);
                    }
                    catch (RuntimeException e) {
                        DebugUtil.error.log("Can't invoke System.exit", e);
                    }
                }
            }
        }.start();
    }

    @Override
    public final synchronized void start(final MasterRemote master) throws RemoteException {
        if (this._started) {
            throw new IllegalArgumentException("start() has already been invoked");
        }
        master.checkStillAlive();
        Thread checkMaster = new Thread(this._pollMasterThreadName){

            @Override
            public void run() {
                while (true) {
                    ConcurrentUtil.sleep(1000L);
                    try {
                        master.checkStillAlive();
                        continue;
                    }
                    catch (RemoteException e) {
                        AbstractSlaveJVM.this.quit();
                        continue;
                    }
                    break;
                }
            }
        };
        checkMaster.setDaemon(true);
        checkMaster.start();
        this.handleStart(master);
    }

    protected void beforeQuit() {
    }

    protected abstract void handleStart(MasterRemote var1);
}

