/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.reflect;

import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.AbstractClassLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreemptingClassLoader
extends AbstractClassLoader {
    private Iterable<String> _prefixes;

    public PreemptingClassLoader(ClassLoader parent, String ... prefixes) {
        this(parent, IterUtil.asIterable(prefixes));
    }

    public PreemptingClassLoader(ClassLoader parent, Iterable<? extends String> prefixes) {
        super(parent);
        this._prefixes = IterUtil.snapshot(prefixes);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.shouldPreempt(name)) {
            return super.loadClass(name, resolve);
        }
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            String filename = name.replace('.', '/') + ".class";
            BufferedInputStream in = IOUtil.asBuffered(this.getResourceAsStream(filename));
            if (in == null) {
                throw new ClassNotFoundException("Resource not found: " + filename);
            }
            try {
                byte[] data = IOUtil.toByteArray(in);
                this.definePackageForClass(name);
                result = this.defineClass(name, data, 0, data.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Error in reading " + filename, e);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private boolean shouldPreempt(String name) {
        for (String p : this._prefixes) {
            if (!name.startsWith(p) || !name.equals(p) && !name.startsWith(p + ".") && !name.startsWith(p + "$")) continue;
            return true;
        }
        return false;
    }
}

