/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.Interpreter;
import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.reflect.PathClassLoader;
import edu.rice.cs.plt.text.ArgumentParser;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.OptionVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public final class DynamicJava {
    private DynamicJava() {
    }

    public static void main(String ... args) throws IOException {
        String input;
        DebugUtil.debug.log();
        ArgumentParser argParser = new ArgumentParser();
        argParser.supportOption("classpath", IOUtil.WORKING_DIRECTORY.toString());
        argParser.supportAlias("cp", "classpath");
        ArgumentParser.Result parsedArgs = argParser.parse(args);
        SizedIterable<File> cp = IOUtil.parsePath(parsedArgs.getUnaryOption("classpath"));
        Interpreter i = new Interpreter(Options.DEFAULT, new PathClassLoader(cp));
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String prev = null;
        boolean blank = false;
        do {
            System.out.print("> ");
            System.out.flush();
            input = in.readLine();
            if (input == null) continue;
            if (input.equals("")) {
                if (blank) {
                    input = prev;
                    blank = false;
                } else {
                    blank = true;
                }
            } else {
                prev = input;
                blank = false;
            }
            try {
                Option<Object> result = i.interpret(input);
                result.apply(new OptionVisitor<Object, Void>(){

                    @Override
                    public Void forSome(Object o) {
                        System.out.println(TextUtil.toString(o));
                        return null;
                    }

                    @Override
                    public Void forNone() {
                        return null;
                    }
                });
            }
            catch (InterpreterException e) {
                e.printUserMessage();
                DebugUtil.debug.log(e);
            }
            catch (RuntimeException e) {
                System.out.println("INTERNAL ERROR: Uncaught exception");
                e.printStackTrace(System.out);
            }
            System.out.println();
        } while (input != null);
    }
}

