/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.JDKDescriptor;
import edu.rice.cs.drjava.model.compiler.Javac160FilteringCompiler;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import polyglot.ext.hj.Version;
import soot.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjCompiler
extends Javac160FilteringCompiler {
    public static final String HJ_FILE_EXTENSION = ".hj";
    public static final HashSet<String> HJ_KEYWORDS;

    public HjCompiler(JavaVersion.FullVersion version, String location, List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
    }

    @Override
    public String getName() {
        return "HJ " + Version.getVersion();
    }

    @Override
    public List<File> additionalBootClassPathForInteractions() {
        if (this._location.equals(FileOps.getDrJavaFile())) {
            return Arrays.asList(new File(this._location));
        }
        File parentDir = new File(this._location).getParentFile();
        try {
            File[] jarFiles = new File[]{JDKDescriptor.Util.oneOf(parentDir, "sootclasses-2.3.0.jar"), JDKDescriptor.Util.oneOf(parentDir, "polyglot.jar"), JDKDescriptor.Util.oneOf(parentDir, "lpg.jar"), JDKDescriptor.Util.oneOf(parentDir, "jasminclasses-2.3.0.jar"), JDKDescriptor.Util.oneOf(parentDir, "java_cup.jar"), JDKDescriptor.Util.oneOf(parentDir, "hj.jar")};
            return Arrays.asList(jarFiles);
        }
        catch (FileNotFoundException fnfe) {
            return Collections.emptyList();
        }
    }

    @Override
    public String transformCommands(String interactionsString) {
        if (interactionsString.startsWith("hj ")) {
            interactionsString = interactionsString.replace("hj ", "hj hj.lang.Runtime ");
            interactionsString = HjCompiler.transformHJCommand(interactionsString);
        }
        if (interactionsString.startsWith("java ")) {
            interactionsString = interactionsString.replace("java ", "java hj.lang.Runtime ");
            interactionsString = HjCompiler.transformHJCommand(interactionsString);
        }
        if (interactionsString.startsWith("run ")) {
            interactionsString = interactionsString.replace("run ", "java hj.lang.Runtime ");
            interactionsString = HjCompiler.transformHJCommand(interactionsString);
        }
        return interactionsString;
    }

    public static String transformHJCommand(String s) {
        String HJcommand = "hj.lang.Runtime.mainEntry(new String[]{\"-rt=wsh\"";
        if (s.endsWith(";")) {
            s = HjCompiler._deleteSemiColon(s);
        }
        List<String> args = ArgumentTokenizer.tokenize(s, true);
        String classNameWithQuotes = args.get(1);
        StringBuilder argsString = new StringBuilder(HJcommand);
        for (int i = 2; i < args.size(); ++i) {
            argsString.append(",");
            argsString.append(args.get(i));
        }
        argsString.append("});");
        return argsString.toString();
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("hj.parser.HjLexer");
            Class.forName("polyglot.ext.hj.Version");
            Class.forName("polyglot.ext.hj.visit.HjTranslator");
            return true;
        }
        catch (Exception e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    @Override
    public boolean isSourceFileForThisCompiler(File f) {
        return f.getName().endsWith(HJ_FILE_EXTENSION);
    }

    @Override
    public Set<String> getSourceFileExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(this.getSuggestedFileExtension());
        return extensions;
    }

    @Override
    public String getSuggestedFileExtension() {
        return HJ_FILE_EXTENSION;
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(HjCompiler.HJ_FILE_EXTENSION);
            }

            public String getDescription() {
                return "Habanero Java source files (*.hj)";
            }
        };
    }

    @Override
    public String getOpenAllFilesInFolderExtension() {
        return HJ_FILE_EXTENSION;
    }

    @Override
    public boolean supportsLanguageLevels() {
        return false;
    }

    @Override
    public Set<String> getKeywordsForFile(File f) {
        return this.isSourceFileForThisCompiler(f) ? new HashSet<String>(HJ_KEYWORDS) : new HashSet();
    }

    @Override
    public List<? extends DJError> compile(List<? extends File> files, List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        List<File> filteredClassPath = this.getFilteredClassPath(classPath);
        String s = "";
        if (bootClassPath == null) {
            bootClassPath = this._defaultBootClassPath;
        }
        for (File f : bootClassPath) {
            s = s + ":" + f.getAbsolutePath();
        }
        if (s.length() > 0) {
            s = s.substring(1);
        }
        ArrayList<String> testCommand = new ArrayList<String>();
        testCommand.add("-hj");
        testCommand.add("-info");
        testCommand.add("-sp");
        int spIndex = testCommand.size();
        testCommand.add("<sp filled in here>");
        testCommand.add("-cp");
        testCommand.add(s);
        testCommand.add("-d");
        int destIndex = testCommand.size();
        if (destination != null) {
            testCommand.add(destination.getAbsolutePath());
        } else {
            testCommand.add("<dest dir filled in here>");
        }
        testCommand.add("-w");
        testCommand.add("-pp");
        int sourceFileIndex = testCommand.size();
        testCommand.add("<source file filled in here>");
        for (File file : files) {
            testCommand.set(spIndex, file.getParentFile().getAbsolutePath());
            if (destination == null) {
                testCommand.set(destIndex, file.getParentFile().getAbsolutePath());
            }
            testCommand.set(sourceFileIndex, file.getName());
            try {
                Main.mainEntry((String[])testCommand.toArray(new String[testCommand.size()]));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UnexpectedException(e);
            }
        }
        return Collections.emptyList();
    }

    static {
        String[] words;
        HJ_KEYWORDS = new HashSet();
        HJ_KEYWORDS.addAll(JAVA_KEYWORDS);
        for (String s : words = new String[]{"at", "activitylocal", "async", "ateach", "atomic", "arrayView", "await", "boxed", "compilertest", "complex64", "complex32", "current", "extern", "finish", "forall", "foreach", "fun", "future", "here", "imag", "isolated", "local", "method", "mutable", "next", "nonblocking", "now", "nullable", "or", "phased", "placelocal", "real", "reference", "safe", "self", "seq", "sequential", "signal", "single", "unsafe", "value", "wait", "when"}) {
            HJ_KEYWORDS.add(s);
        }
    }
}

