/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.Javac160FilteringCompiler;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.FilePredicate;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class EclipseCompiler
extends Javac160FilteringCompiler {
    public EclipseCompiler(JavaVersion.FullVersion version, String location, List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
    }

    @Override
    public boolean isAvailable() {
        try {
            Class<?> diagnostic = Class.forName("javax.tools.Diagnostic");
            diagnostic.getMethod("getKind", new Class[0]);
            Class.forName("org.eclipse.jdt.internal.compiler.tool.EclipseCompiler");
            return true;
        }
        catch (Exception e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    @Override
    public List<? extends DJError> compile(List<? extends File> files, List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        DebugUtil.debug.logStart("compile()");
        DebugUtil.debug.logValues(new String[]{"this", "files", "classPath", "sourcePath", "destination", "bootClassPath", "sourceVersion", "showWarnings"}, this, files, classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        LinkedList<? extends File> filteredClassPath = null;
        if (classPath != null) {
            filteredClassPath = new LinkedList<File>(classPath);
            if (this._filterExe) {
                FilePredicate filter = IOUtil.extensionFilePredicate("exe");
                Iterator i = filteredClassPath.iterator();
                while (i.hasNext()) {
                    if (!filter.accept((File)i.next())) continue;
                    i.remove();
                }
                if (this._tempJUnit != null) {
                    filteredClassPath.add(this._tempJUnit);
                }
            }
        }
        LinkedList<DJError> errors = new LinkedList<DJError>();
        org.eclipse.jdt.internal.compiler.tool.EclipseCompiler compiler = new org.eclipse.jdt.internal.compiler.tool.EclipseCompiler();
        CompilerErrorListener diagnosticListener = new CompilerErrorListener(errors);
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticListener, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        OutputStreamWriter out = new OutputStreamWriter(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        Iterable<String> classes = null;
        Iterable<String> options = this._getOptions(fileManager, filteredClassPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        try {
            JavaCompiler.CompilationTask task = compiler.getTask(out, fileManager, diagnosticListener, options, classes, compilationUnits);
            boolean res = task.call();
            if (!res && errors.size() == 0) {
                throw new AssertionError((Object)"Compile failed. There should be compiler errors, but there aren't.");
            }
        }
        catch (Throwable t) {
            errors.addFirst(new DJError("Compile exception: " + t, false));
            DebugUtil.error.log(t);
        }
        DebugUtil.debug.logEnd("compile()");
        return errors;
    }

    @Override
    public String getName() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.jdt.internal.compiler.batch.messages");
            String ecjVersion = bundle.getString("compiler.version");
            int commaPos = ecjVersion.indexOf(44);
            if (commaPos >= 0) {
                ecjVersion = ecjVersion.substring(0, commaPos);
            }
            return "Eclipse Compiler " + ecjVersion;
        }
        catch (Throwable t) {
            return "Eclipse Compiler " + this._version.versionString();
        }
    }

    private static void addOption(List<String> options, String s) {
        if (s.length() > 0) {
            options.add(s);
        }
    }

    private Iterable<String> _getOptions(StandardJavaFileManager fileManager, List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        if (bootClassPath == null) {
            bootClassPath = this._defaultBootClassPath;
        }
        ArrayList<String> options = new ArrayList<String>();
        boolean isEnabled = DrJava.getConfig().getSetting(OptionConstants.SHOW_UNCHECKED_WARNINGS);
        EclipseCompiler.addOption(options, "-warn:" + (isEnabled ? "+" : "-") + "unchecked");
        EclipseCompiler.addOption(options, "-warn:" + (isEnabled ? "+" : "-") + "raw");
        isEnabled = DrJava.getConfig().getSetting(OptionConstants.SHOW_DEPRECATION_WARNINGS);
        EclipseCompiler.addOption(options, "-warn:" + (isEnabled ? "+" : "-") + "allDeprecation");
        isEnabled = DrJava.getConfig().getSetting(OptionConstants.SHOW_SERIAL_WARNINGS);
        EclipseCompiler.addOption(options, "-warn:" + (isEnabled ? "+" : "-") + "serial");
        isEnabled = DrJava.getConfig().getSetting(OptionConstants.SHOW_FINALLY_WARNINGS);
        EclipseCompiler.addOption(options, "-warn:" + (isEnabled ? "+" : "-") + "finally");
        isEnabled = DrJava.getConfig().getSetting(OptionConstants.SHOW_FALLTHROUGH_WARNINGS);
        EclipseCompiler.addOption(options, "-warn:" + (isEnabled ? "+" : "-") + "fallthrough");
        EclipseCompiler.addOption(options, "-g");
        if (classPath != null) {
            EclipseCompiler.addOption(options, "-classpath");
            EclipseCompiler.addOption(options, IOUtil.pathToString(classPath));
            try {
                fileManager.setLocation(StandardLocation.CLASS_PATH, classPath);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (sourcePath != null) {
            EclipseCompiler.addOption(options, "-sourcepath");
            EclipseCompiler.addOption(options, IOUtil.pathToString(sourcePath));
            try {
                fileManager.setLocation(StandardLocation.SOURCE_PATH, sourcePath);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (destination != null) {
            EclipseCompiler.addOption(options, "-d");
            EclipseCompiler.addOption(options, destination.getPath());
            try {
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, IterUtil.asIterable(destination));
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (bootClassPath != null) {
            EclipseCompiler.addOption(options, "-bootclasspath");
            EclipseCompiler.addOption(options, IOUtil.pathToString(bootClassPath));
            try {
                fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, bootClassPath);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (sourceVersion != null) {
            EclipseCompiler.addOption(options, "-source");
            EclipseCompiler.addOption(options, sourceVersion);
        }
        if (!showWarnings) {
            EclipseCompiler.addOption(options, "-nowarn");
        }
        return options;
    }

    private static class CompilerErrorListener
    implements DiagnosticListener<JavaFileObject> {
        private List<? super DJError> _errors;

        public CompilerErrorListener(List<? super DJError> errors) {
            this._errors = errors;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> d) {
            Diagnostic.Kind dt = d.getKind();
            boolean isWarning = false;
            switch (dt) {
                case OTHER: {
                    return;
                }
                case NOTE: {
                    return;
                }
                case MANDATORY_WARNING: {
                    isWarning = true;
                    break;
                }
                case WARNING: {
                    isWarning = true;
                    break;
                }
                case ERROR: {
                    isWarning = false;
                }
            }
            if (d.getSource() != null) {
                this._errors.add(new DJError(new File(d.getSource().toUri().getPath()), (int)d.getLineNumber() - 1, (int)d.getColumnNumber() - 1, d.getMessage(Locale.getDefault()), isWarning));
            } else {
                this._errors.add(new DJError(d.getMessage(Locale.getDefault()), isWarning));
            }
        }
    }
}

