/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.BooleanOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.AbstractGlobalModel;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.JDKDescriptor;
import edu.rice.cs.drjava.model.JDKToolsLibrary;
import edu.rice.cs.drjava.model.JarJDKToolsLibrary;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.DefaultCompilerModel;
import edu.rice.cs.drjava.model.compiler.DummyCompilerListener;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.drjava.model.junit.DefaultJUnitModel;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.drjava.model.repl.DummyInteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.util.AbsRelFile;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.NullFile;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocument;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class DefaultGlobalModel
extends AbstractGlobalModel {
    protected final InteractionsDJDocument _interactionsDocument;
    final MainJVM _jvm;
    private final Thread _jvmStarter;
    protected final DefaultInteractionsModel _interactionsModel;
    protected InteractionsListener _interactionsListener = new InteractionsListener(){

        @Override
        public void interactionStarted() {
        }

        @Override
        public void interactionEnded() {
        }

        @Override
        public void interactionErrorOccurred(int offset, int length) {
        }

        @Override
        public void interpreterResetting() {
        }

        @Override
        public void interpreterReady(File wd) {
            File buildDir = DefaultGlobalModel.this._state.getBuildDirectory();
            if (buildDir != null) {
                DefaultGlobalModel.this._jvm.addBuildDirectoryClassPath(IOUtil.attemptAbsoluteFile(buildDir));
            }
        }

        @Override
        public void interpreterResetFailed(Throwable t) {
        }

        @Override
        public void interpreterExited(int status) {
        }

        @Override
        public void interpreterChanged(boolean inProgress) {
        }

        @Override
        public void interactionIncomplete() {
        }
    };
    private CompilerListener _clearInteractionsListener = new DummyCompilerListener(){

        @Override
        public void compileEnded(File workDir, List<? extends File> excludedFiles) {
            if ((DefaultGlobalModel.this._compilerModel.getNumErrors() == 0 || DefaultGlobalModel.this._compilerModel.getCompilerErrorModel().hasOnlyWarnings()) && !DefaultGlobalModel.this._junitModel.isTestInProgress() && DefaultGlobalModel.this._resetAfterCompile) {
                DefaultGlobalModel.this.resetInteractions(workDir);
            }
        }

        @Override
        public void activeCompilerChanged() {
            File workDir = DefaultGlobalModel.this._interactionsModel.getWorkingDirectory();
            DefaultGlobalModel.this.resetInteractions(workDir, true);
        }
    };
    private final CompilerModel _compilerModel;
    private volatile boolean _resetAfterCompile = true;
    private volatile int _numCompilerErrors = 0;
    private final DefaultJUnitModel _junitModel;
    protected volatile JavadocModel _javadocModel;
    private volatile Debugger _debugger;

    public DefaultGlobalModel() {
        Iterable<JDKToolsLibrary> tools = this.findLibraries();
        LinkedList<CompilerInterface> compilers = new LinkedList<CompilerInterface>();
        this._debugger = null;
        this._javadocModel = null;
        for (JDKToolsLibrary t : tools) {
            if (t.compiler().isAvailable()) {
                compilers.add(t.compiler());
            }
            if (this._debugger == null && t.debugger().isAvailable()) {
                this._debugger = t.debugger();
            }
            if (this._javadocModel != null || !t.javadoc().isAvailable()) continue;
            this._javadocModel = t.javadoc();
        }
        if (this._debugger == null) {
            this._debugger = NoDebuggerAvailable.ONLY;
        }
        if (this._javadocModel == null) {
            this._javadocModel = new NoJavadocAvailable(this);
        }
        File workDir = Utilities.TEST_MODE ? new File(System.getProperty("user.home")) : this.getWorkingDirectory();
        this._jvm = new MainJVM(workDir);
        this._compilerModel = new DefaultCompilerModel(this, compilers);
        this._junitModel = new DefaultJUnitModel(this._jvm, this._compilerModel, this);
        this._interactionsDocument = new InteractionsDJDocument(this._notifier);
        this._interactionsModel = new DefaultInteractionsModel(this, this._jvm, this._interactionsDocument, workDir);
        this._interactionsModel.addListener(this._interactionsListener);
        this._jvm.setInteractionsModel(this._interactionsModel);
        this._jvm.setJUnitModel(this._junitModel);
        this._setupDebugger();
        this._interactionsModel.addListener(this._notifier);
        this._compilerModel.addListener(this._notifier);
        this._junitModel.addListener(this._notifier);
        this._javadocModel.addListener(this._notifier);
        this._compilerModel.addListener(this._clearInteractionsListener);
        this._jvmStarter = new Thread("Start interpreter JVM"){

            @Override
            public void run() {
                DefaultGlobalModel.this._jvm.startInterpreterJVM();
            }
        };
        this._jvmStarter.start();
    }

    private static JavaVersion.FullVersion coarsenVersion(JavaVersion.FullVersion tVersion) {
        BooleanOption displayAllOption = OptionConstants.DISPLAY_ALL_COMPILER_VERSIONS;
        if (!DrJava.getConfig().getSetting(displayAllOption).booleanValue()) {
            tVersion = tVersion.onlyMajorVersionAndVendor();
        }
        return tVersion;
    }

    private LibraryKey getLibraryKey(int priority, JDKToolsLibrary lib) {
        return new LibraryKey(priority, DefaultGlobalModel.coarsenVersion(lib.version()), lib.jdkDescriptor());
    }

    private Iterable<JDKToolsLibrary> findLibraries() {
        TreeMap<LibraryKey, JDKToolsLibrary> results = new TreeMap<LibraryKey, JDKToolsLibrary>();
        File configTools = DrJava.getConfig().getSetting(JAVAC_LOCATION);
        if (configTools != FileOps.NULL_FILE) {
            JarJDKToolsLibrary fromConfig = JarJDKToolsLibrary.makeFromFile(configTools, this, JDKDescriptor.NONE);
            if (fromConfig.isValid()) {
                JarJDKToolsLibrary.msg("From config: " + fromConfig);
                results.put(this.getLibraryKey(3, fromConfig), fromConfig);
            } else {
                JarJDKToolsLibrary.msg("From config: invalid " + fromConfig);
            }
        } else {
            JarJDKToolsLibrary.msg("From config: not set");
        }
        Iterable<JDKToolsLibrary> allFromRuntime = JDKToolsLibrary.makeFromRuntime(this);
        for (JDKToolsLibrary fromRuntime : allFromRuntime) {
            if (fromRuntime.isValid()) {
                if (!results.containsKey(this.getLibraryKey(2, fromRuntime))) {
                    JarJDKToolsLibrary.msg("From runtime: " + fromRuntime);
                    results.put(this.getLibraryKey(2, fromRuntime), fromRuntime);
                    continue;
                }
                JarJDKToolsLibrary.msg("From runtime: duplicate " + fromRuntime);
                continue;
            }
            JarJDKToolsLibrary.msg("From runtime: invalid " + fromRuntime);
        }
        Iterable<JarJDKToolsLibrary> fromSearch = JarJDKToolsLibrary.search(this);
        for (JDKToolsLibrary jDKToolsLibrary : fromSearch) {
            int priority;
            JavaVersion.FullVersion tVersion = jDKToolsLibrary.version();
            JarJDKToolsLibrary.msg("From search: " + jDKToolsLibrary);
            JavaVersion.FullVersion coarsenedVersion = DefaultGlobalModel.coarsenVersion(tVersion);
            JarJDKToolsLibrary.msg("\ttVersion: " + tVersion + " " + (Object)((Object)tVersion.vendor()));
            JarJDKToolsLibrary.msg("\tcoarsenedVersion: " + coarsenedVersion + " " + (Object)((Object)coarsenedVersion.vendor()));
            int n = priority = FileOps.getDrJavaFile().equals(tVersion.location()) ? 0 : 1;
            if (!results.containsKey(this.getLibraryKey(priority, jDKToolsLibrary))) {
                JarJDKToolsLibrary.msg("\tadded");
                results.put(this.getLibraryKey(priority, jDKToolsLibrary), jDKToolsLibrary);
                continue;
            }
            JarJDKToolsLibrary.msg("\tduplicate");
        }
        return IterUtil.reverse(results.values());
    }

    @Override
    public void setBuildDirectory(File f) {
        this._state.setBuildDirectory(f);
        if (f != FileOps.NULL_FILE) {
            this._jvm.addBuildDirectoryClassPath(IOUtil.attemptAbsoluteFile(f));
        }
        this._notifier.projectBuildDirChanged();
        this.setProjectChanged(true);
        this.setClassPathChanged(true);
    }

    @Override
    public DefaultInteractionsModel getInteractionsModel() {
        return this._interactionsModel;
    }

    @Override
    public InteractionsDJDocument getSwingInteractionsDocument() {
        return this._interactionsDocument;
    }

    @Override
    public InteractionsDocument getInteractionsDocument() {
        return this._interactionsModel.getDocument();
    }

    @Override
    public CompilerModel getCompilerModel() {
        return this._compilerModel;
    }

    @Override
    public JUnitModel getJUnitModel() {
        return this._junitModel;
    }

    @Override
    public JavadocModel getJavadocModel() {
        return this._javadocModel;
    }

    @Override
    public int getNumCompilerErrors() {
        return this._numCompilerErrors;
    }

    @Override
    public void setNumCompilerErrors(int num) {
        this._numCompilerErrors = num;
    }

    @Override
    public void dispose() {
        this.ensureJVMStarterFinished();
        this._jvm.dispose();
        this._notifier.removeAllListeners();
    }

    @Override
    public void ensureJVMStarterFinished() {
        try {
            this._jvmStarter.join();
        }
        catch (InterruptedException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void disposeExternalResources() {
        this._jvm.stopInterpreterJVM();
    }

    @Override
    public void resetInteractions(File wd) {
        this.resetInteractions(wd, false);
    }

    @Override
    public void resetInteractions(File wd, boolean forceReset) {
        assert (this._interactionsModel._pane != null);
        DebugUtil.debug.logStart();
        File workDir = this._interactionsModel.getWorkingDirectory();
        if (wd == null) {
            wd = workDir;
        }
        forceReset |= this.isClassPathChanged();
        boolean bl = !wd.equals(workDir);
        DrJava.getConfig().setSetting(LAST_INTERACTIONS_DIRECTORY, wd);
        this.getDebugger().setAutomaticTraceEnabled(false);
        this._interactionsModel.resetInterpreter(wd, forceReset |= bl);
        DebugUtil.debug.logEnd();
    }

    @Override
    public void interpretCurrentInteraction() {
        this._interactionsModel.interpretCurrentInteraction();
    }

    @Override
    public void loadHistory(final FileOpenSelector selector) {
        Utilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultGlobalModel.this._interactionsModel.loadHistory(selector);
                }
                catch (IOException e) {
                    throw new UnexpectedException(e);
                }
            }
        });
    }

    @Override
    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        return this._interactionsModel.loadHistoryAsScript(selector);
    }

    @Override
    public void clearHistory() {
        this._interactionsModel.getDocument().clearHistory();
    }

    @Override
    public void saveHistory(FileSaveSelector selector) throws IOException {
        this._interactionsModel.getDocument().saveHistory(selector);
    }

    @Override
    public void saveConsoleCopy(ConsoleDocument doc, FileSaveSelector selector) throws IOException {
        doc.saveCopy(selector);
    }

    @Override
    public void saveHistory(FileSaveSelector selector, String editedVersion) throws IOException {
        this._interactionsModel.getDocument().saveHistory(selector, editedVersion);
    }

    @Override
    public String getHistoryAsStringWithSemicolons() {
        return this._interactionsModel.getDocument().getHistoryAsStringWithSemicolons();
    }

    @Override
    public String getHistoryAsString() {
        return this._interactionsModel.getDocument().getHistoryAsString();
    }

    @Override
    public void printDebugMessage(String s) {
        this._interactionsModel.getDocument().insertBeforeLastPrompt(s + "\n", "debugger");
    }

    @Override
    public Iterable<File> getInteractionsClassPath() {
        return this._jvm.getClassPath().unwrap(IterUtil.empty());
    }

    void setResetAfterCompile(boolean shouldReset) {
        this._resetAfterCompile = shouldReset;
    }

    @Override
    public Debugger getDebugger() {
        return this._debugger;
    }

    @Override
    public int getDebugPort() throws IOException {
        return this._interactionsModel.getDebugPort();
    }

    @Override
    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(NullFile f) {
        return new ConcreteOpenDefDoc(f);
    }

    @Override
    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException("file " + f + " cannot be found");
        }
        return new ConcreteOpenDefDoc(f);
    }

    @Override
    protected void addDocToClassPath(OpenDefinitionsDocument doc) {
        try {
            File sourceRoot = doc.getSourceRoot();
            if (doc.isAuxiliaryFile()) {
                this._interactionsModel.addProjectFilesClassPath(sourceRoot);
            } else {
                this._interactionsModel.addExternalFilesClassPath(sourceRoot);
            }
            this.setClassPathChanged(true);
        }
        catch (InvalidPackageException invalidPackageException) {
            // empty catch block
        }
    }

    private void _setupDebugger() {
        this._jvm.setDebugModel(this._debugger.callback());
        this.getBreakpointManager().addListener(new RegionManagerListener<Breakpoint>(){

            @Override
            public void regionAdded(Breakpoint bp) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionChanged(Breakpoint bp) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionRemoved(Breakpoint bp) {
                try {
                    DefaultGlobalModel.this.getDebugger().removeBreakpoint(bp);
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                DefaultGlobalModel.this.setProjectChanged(true);
            }
        });
        this.getBookmarkManager().addListener(new RegionManagerListener<MovingDocumentRegion>(){

            @Override
            public void regionAdded(MovingDocumentRegion r) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionChanged(MovingDocumentRegion r) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionRemoved(MovingDocumentRegion r) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }
        });
        this._debugger.addListener(new DebugListener(){

            @Override
            public void watchSet(DebugWatchData w) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void watchRemoved(DebugWatchData w) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionAdded(Breakpoint bp) {
            }

            @Override
            public void regionChanged(Breakpoint bp) {
            }

            @Override
            public void regionRemoved(Breakpoint bp) {
            }

            @Override
            public void debuggerStarted() {
            }

            @Override
            public void debuggerShutdown() {
            }

            @Override
            public void threadLocationUpdated(OpenDefinitionsDocument doc, int lineNumber, boolean shouldHighlight) {
            }

            @Override
            public void breakpointReached(Breakpoint bp) {
            }

            @Override
            public void stepRequested() {
            }

            @Override
            public void currThreadSuspended() {
            }

            @Override
            public void currThreadResumed() {
            }

            @Override
            public void threadStarted() {
            }

            @Override
            public void currThreadDied() {
            }

            @Override
            public void nonCurrThreadDied() {
            }

            @Override
            public void currThreadSet(DebugThreadData thread) {
            }
        });
    }

    @Override
    public Iterable<File> getClassPath() {
        AbstractIterable result = IterUtil.empty();
        if (this.isProjectActive()) {
            Iterable<AbsRelFile> projectExtras;
            File projRoot;
            File buildDir = this.getBuildDirectory();
            if (buildDir != null) {
                result = IterUtil.compose(result, buildDir);
            }
            if ((projRoot = this.getProjectRoot()) != null) {
                result = IterUtil.compose(result, projRoot);
            }
            if ((projectExtras = this.getExtraClassPath()) != null) {
                result = IterUtil.compose(result, projectExtras);
            }
        } else {
            result = IterUtil.compose(result, this.getSourceRootSet());
        }
        Vector globalExtras = (Vector)DrJava.getConfig().getSetting(EXTRA_CLASSPATH);
        if (globalExtras != null) {
            result = IterUtil.compose(result, globalExtras);
        }
        result = IterUtil.compose(result, ReflectUtil.SYSTEM_CLASS_PATH);
        return result;
    }

    public void resetInteractionsClassPath() {
        Vector cp;
        Iterable<AbsRelFile> projectExtras = this.getExtraClassPath();
        if (projectExtras != null) {
            for (File file : projectExtras) {
                this._interactionsModel.addProjectClassPath(file);
            }
        }
        if ((cp = (Vector)DrJava.getConfig().getSetting(EXTRA_CLASSPATH)) != null) {
            for (File f : cp) {
                this._interactionsModel.addExtraClassPath(f);
            }
        }
        for (OpenDefinitionsDocument odd : this.getAuxiliaryDocuments()) {
            try {
                this._interactionsModel.addProjectFilesClassPath(odd.getSourceRoot());
            }
            catch (InvalidPackageException e) {}
        }
        for (OpenDefinitionsDocument odd : this.getNonProjectDocuments()) {
            try {
                File sourceRoot = odd.getSourceRoot();
                if (sourceRoot == null) continue;
                this._interactionsModel.addExternalFilesClassPath(sourceRoot);
            }
            catch (InvalidPackageException e) {}
        }
        this._interactionsModel.addProjectFilesClassPath(this.getProjectRoot());
        this.setClassPathChanged(false);
    }

    class ConcreteOpenDefDoc
    extends AbstractGlobalModel.ConcreteOpenDefDoc {
        private volatile InteractionsListener _runMain;

        ConcreteOpenDefDoc(File f) {
            super(f);
            this.updateSyntaxHighlighting();
        }

        ConcreteOpenDefDoc(NullFile f) {
            super(f);
            this.updateSyntaxHighlighting();
        }

        @Override
        public void startCompile() throws IOException {
            assert (EventQueue.isDispatchThread());
            DefaultGlobalModel.this._compilerModel.compile(this);
        }

        protected void _runInInteractions(final String command, String qualifiedClassName) throws ClassNameNotFoundException, IOException {
            assert (EventQueue.isDispatchThread());
            DefaultGlobalModel.this._notifier.prepareForRun(this);
            String tempClassName = null;
            tempClassName = qualifiedClassName == null ? this.getDocument().getQualifiedClassName() : qualifiedClassName;
            final String className = tempClassName;
            final InteractionsDocument iDoc = DefaultGlobalModel.this._interactionsModel.getDocument();
            if (!this.checkIfClassFileInSync()) {
                iDoc.insertBeforeLastPrompt("Current document is out of sync with the Interactions Pane and should be recompiled!\n", "error");
                return;
            }
            final boolean wasDebuggerEnabled = DefaultGlobalModel.this.getDebugger().isReady();
            this._runMain = new DummyInteractionsListener(){

                @Override
                public void interpreterReady(File wd) {
                    DefaultGlobalModel.this._interactionsModel.removeListener(ConcreteOpenDefDoc.this._runMain);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (wasDebuggerEnabled && !DefaultGlobalModel.this.getDebugger().isReady()) {
                                try {
                                    DefaultGlobalModel.this.getDebugger().startUp();
                                }
                                catch (DebugException debugException) {
                                    // empty catch block
                                }
                            }
                            iDoc.clearCurrentInput();
                            iDoc.append(MessageFormat.format(command, className), null);
                            new Thread("Running document"){

                                @Override
                                public void run() {
                                    DefaultGlobalModel.this._interactionsModel.interpretCurrentInteraction();
                                }
                            }.start();
                        }
                    });
                }
            };
            File oldWorkDir = DefaultGlobalModel.this._interactionsModel.getWorkingDirectory();
            DefaultGlobalModel.this._interactionsModel.addListener(this._runMain);
            File workDir = DefaultGlobalModel.this.getWorkingDirectory();
            DefaultGlobalModel.this.resetInteractions(workDir, !workDir.equals(oldWorkDir));
        }

        @Override
        public void runMain(String qualifiedClassName) throws ClassNameNotFoundException, IOException {
            this._runInInteractions("java {0}", qualifiedClassName);
        }

        @Override
        public void runApplet(String qualifiedClassName) throws ClassNameNotFoundException, IOException {
            this._runInInteractions("applet {0}", qualifiedClassName);
        }

        @Override
        public void runSmart(String qualifiedClassName) throws ClassNameNotFoundException, IOException {
            this._runInInteractions("run {0}", qualifiedClassName);
        }

        @Override
        public void startJUnit() throws ClassNotFoundException, IOException {
            DefaultGlobalModel.this._junitModel.junit(this);
        }

        @Override
        public void generateJavadoc(FileSaveSelector saver) throws IOException {
            DefaultGlobalModel.this._javadocModel.javadocDocument(this, saver);
        }

        @Override
        public void removeFromDebugger() {
            this.getBreakpointManager().removeRegions(this);
        }
    }

    private static class LibraryKey
    implements Comparable<LibraryKey> {
        public static final int PRIORITY_BUILTIN = 0;
        public static final int PRIORITY_SEARCH = 1;
        public static final int PRIORITY_RUNTIME = 2;
        public static final int PRIORITY_CONFIG = 3;
        protected final int _priority;
        protected final JavaVersion.FullVersion _first;
        protected final JDKDescriptor _second;

        public LibraryKey(int priority, JavaVersion.FullVersion first, JDKDescriptor second) {
            this._priority = priority;
            this._first = first;
            this._second = second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            LibraryKey cast = (LibraryKey)o;
            return this._priority == cast._priority && (this._first == null ? cast._first == null : this._first.equals(cast._first)) && (this._second == null ? cast._second == null : this._second == JDKDescriptor.NONE && cast._second == JDKDescriptor.NONE);
        }

        public String toString() {
            return "priority " + this._priority + ", version " + this._first.versionString() + " " + this._first.maintenance() + " " + this._first.update() + " " + (Object)((Object)this._first.release()) + " " + (Object)((Object)this._first.vendor()) + " " + this._first.location() + ", descriptor " + this._second.getName();
        }

        public int hashCode() {
            return this._priority ^ (this._first == null ? 0 : this._first.hashCode()) ^ (this._second == null ? 0 : this._second.hashCode() << 1) ^ this.getClass().hashCode();
        }

        @Override
        public int compareTo(LibraryKey o) {
            int result = this._priority - o._priority;
            if (result == 0) {
                result = this._first.compareTo(o._first);
            }
            if (result == 0) {
                result = this._second == JDKDescriptor.NONE ? (o._second == JDKDescriptor.NONE ? 0 : 1) : (o._second == JDKDescriptor.NONE ? -1 : this._second.toString().compareTo(o._second.toString()));
            }
            return result;
        }
    }
}

