/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.plt.io.IOUtil;
import java.io.File;
import java.util.Vector;

public class IndentFiles {
    public static void main(String[] args) {
        Vector<String> fileNames = new Vector<String>();
        int indentLevel = 2;
        boolean silent = false;
        if (args.length < 1) {
            IndentFiles._displayUsage();
        } else {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-indent")) {
                    ++i;
                    try {
                        indentLevel = Integer.parseInt(args[i]);
                    }
                    catch (Exception e) {
                        IndentFiles._displayUsage();
                        System.exit(-1);
                    }
                    continue;
                }
                if (arg.equals("-silent")) {
                    silent = true;
                    continue;
                }
                fileNames.add(arg);
            }
            IndentFiles.indentFiles(fileNames, indentLevel, silent);
        }
    }

    private static void _displayUsage() {
        System.out.println("Usage:  java edu.rice.cs.drjava.IndentFile [-indent N] [-silent] [filenames]\n  Where N is the number of spaces in an indentation level");
    }

    public static void indentFiles(Vector<String> fileNames, int indentLevel, boolean silent) {
        Indenter indenter = new Indenter(indentLevel);
        if (!silent) {
            System.out.println("DrJava - Indenting files:");
        }
        for (int i = 0; i < fileNames.size(); ++i) {
            String fname = fileNames.get(i);
            File file = new File(fname);
            if (!silent) {
                System.out.print("  " + fname + " ... ");
                System.out.flush();
            }
            try {
                String fileContents = IOUtil.toString(file);
                DefinitionsDocument doc = new DefinitionsDocument(indenter, new GlobalEventNotifier());
                doc.insertString(0, fileContents, null);
                int docLen = doc.getLength();
                doc.indentLines(0, docLen);
                fileContents = doc.getText();
                IOUtil.writeStringToFile(file, fileContents);
                if (silent) continue;
                System.out.println("done.");
                continue;
            }
            catch (Exception e) {
                if (silent) continue;
                System.out.println("ERROR!");
                System.out.println("  Exception: " + e.toString());
                e.printStackTrace(System.out);
                System.out.println();
            }
        }
        if (!silent) {
            System.out.println();
        }
    }
}

