/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.IPoolInfoVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerPoolInfo
extends APoolInfo {
    private int _intValue;

    public IntegerPoolInfo(int i, ConstantPool cp) {
        super(3, cp);
        this._intValue = i;
    }

    public IntegerPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(3, cp);
        this._intValue = dis.readInt();
    }

    public int getIntValue() {
        return this._intValue;
    }

    public void setIntValue(int intValue) {
        this._intValue = intValue;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this._type);
        dos.writeInt(this._intValue);
    }

    @Override
    public void resolve() {
    }

    @Override
    public void reindex() {
    }

    @Override
    public String toStringVerbose() {
        StringBuilder s = new StringBuilder();
        s.append("CONSTANT_Integer: Value = ");
        s.append(this.toString());
        return s.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this._intValue);
    }

    @Override
    public int hashCode() {
        return this._intValue;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IntegerPoolInfo && ((IntegerPoolInfo)obj)._intValue == this._intValue;
    }

    @Override
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.intCase(this, data);
    }
}

