/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.CheckerException;
import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.interpreter.TreeClassLoader;
import edu.rice.cs.dynamicjava.symbol.Access;
import edu.rice.cs.dynamicjava.symbol.BoundedSymbol;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJField;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleClassType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Box;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.AnonymousInnerAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.EnumDeclaration;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.ModifierSet;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.tiger.TypeParameter;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeClass
implements DJClass {
    private static final Type RUNTIME_BINDINGS_TYPE = new SimpleClassType(SymbolUtil.wrapClass(RuntimeBindings.class));
    private final String _fullName;
    private final DJClass _declaring;
    private final Access.Module _accessModule;
    private final Node _ast;
    private final ModifierSet _mods;
    private final Thunk<Class<?>> _loaded;
    private final List<TreeConstructor> _constructors;
    private final List<TreeField> _fields;
    private final List<TreeMethod> _methods;
    private final List<TreeClass> _classes;
    private final Options _opt;

    public TreeClass(String fullName, DJClass declaring, Access.Module accessModule, final Node ast, final TreeClassLoader loader, Options opt) {
        this._fullName = fullName;
        this._declaring = declaring;
        this._accessModule = accessModule == null ? this : accessModule;
        this._ast = ast;
        this._mods = this._ast instanceof TypeDeclaration ? ((TypeDeclaration)this._ast).getModifiers() : ModifierSet.make();
        this._loaded = LazyThunk.make(new Thunk<Class<?>>(){

            @Override
            public Class<?> value() {
                try {
                    return loader.loadClass(TreeClass.this._fullName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class", e);
                }
                catch (LinkageError e) {
                    if (e instanceof IllegalAccessError) {
                        String msg = e.getMessage();
                        String PREFIX = "class ";
                        String[] INFIX = new String[]{" cannot access its superclass ", " cannot access its superinterface "};
                        String[] ERROR_MSGS = new String[]{"class.cannot.access.superclass", "class.cannot.access.superinterface"};
                        if (msg.startsWith("class ")) {
                            for (int i = 0; i < INFIX.length; ++i) {
                                String infix = INFIX[i];
                                int infixPos = msg.indexOf(infix);
                                if (infixPos < 0 || infixPos < "class ".length()) continue;
                                String className0 = msg.substring("class ".length(), infixPos).trim();
                                String className1 = msg.substring(infixPos + infix.length()).trim();
                                NodeProperties.setErrorStrings(ast, className0, className1);
                                ExecutionError ee = new ExecutionError(ERROR_MSGS[i], ast);
                                throw new WrappedException(new CheckerException(ee));
                            }
                        }
                    }
                    throw new RuntimeException("Error loading class", e);
                }
            }
        });
        this._constructors = new LinkedList<TreeConstructor>();
        this._fields = new LinkedList<TreeField>();
        this._methods = new LinkedList<TreeMethod>();
        this._classes = new LinkedList<TreeClass>();
        this._opt = opt;
        loader.registerTree(this);
        this.tagSignature();
        this.extractMembers(loader);
    }

    private void tagSignature() {
        if (this._ast instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)this._ast;
            List tparams = td.getTypeParams().unwrap(Collections.emptyList());
            for (TypeParameter typeParameter : tparams) {
                BoundedSymbol tempBounds = new BoundedSymbol(new Object(), typeParameter.getRepresentation(), TypeSystem.OBJECT, TypeSystem.NULL);
                NodeProperties.setTypeVariable(typeParameter, new VariableType(tempBounds));
            }
            if (td instanceof ClassDeclaration) {
                NodeProperties.setType(((ClassDeclaration)td).getSuperclass(), TypeSystem.OBJECT);
            }
            if (td.getInterfaces() != null) {
                for (ReferenceTypeName referenceTypeName : td.getInterfaces()) {
                    NodeProperties.setType(referenceTypeName, TypeSystem.OBJECT);
                }
            }
        }
    }

    private void extractMembers(final TreeClassLoader loader) {
        Iterable<Object> members = IterUtil.empty();
        if (this._ast instanceof TypeDeclaration) {
            members = ((TypeDeclaration)this._ast).getMembers();
        } else if (this._ast instanceof AnonymousAllocation) {
            members = ((AnonymousAllocation)this._ast).getMembers();
        } else if (this._ast instanceof AnonymousInnerAllocation) {
            members = ((AnonymousInnerAllocation)this._ast).getMembers();
        }
        for (Node node : members) {
            node.acceptVisitor(new AbstractVisitor<Void>(){

                @Override
                public Void defaultCase(Node n) {
                    return null;
                }

                @Override
                public Void visit(ClassDeclaration d) {
                    TreeClass c = new TreeClass(TreeClass.this._fullName + "$" + d.getName(), TreeClass.this, TreeClass.this._accessModule, d, loader, TreeClass.this._opt);
                    NodeProperties.setDJClass(d, c);
                    TreeClass.this._classes.add(c);
                    return null;
                }

                @Override
                public Void visit(InterfaceDeclaration d) {
                    TreeClass c = new TreeClass(TreeClass.this._fullName + "$" + d.getName(), TreeClass.this, TreeClass.this._accessModule, d, loader, TreeClass.this._opt);
                    NodeProperties.setDJClass(d, c);
                    TreeClass.this._classes.add(c);
                    return null;
                }

                @Override
                public Void visit(ConstructorDeclaration d) {
                    ExplicitTreeConstructor k = new ExplicitTreeConstructor(d);
                    NodeProperties.setConstructor(d, k);
                    TreeClass.this._constructors.add(k);
                    return null;
                }

                @Override
                public Void visit(MethodDeclaration d) {
                    TreeMethod m = new TreeMethod(d);
                    NodeProperties.setMethod(d, m);
                    TreeClass.this._methods.add(m);
                    return null;
                }

                @Override
                public Void visit(FieldDeclaration d) {
                    TreeField f = new TreeField(d);
                    NodeProperties.setField(d, f);
                    TreeClass.this._fields.add(f);
                    return null;
                }
            });
        }
        if (this._constructors.isEmpty() && !(this._ast instanceof InterfaceDeclaration)) {
            this._constructors.add(new DefaultTreeConstructor());
        }
    }

    public Node declaration() {
        return this._ast;
    }

    @Override
    public String packageName() {
        int dot = this._fullName.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return this._fullName.substring(0, dot);
    }

    @Override
    public String fullName() {
        return this._fullName;
    }

    @Override
    public boolean isAnonymous() {
        return !(this._ast instanceof TypeDeclaration);
    }

    @Override
    public String declaredName() {
        if (this._ast instanceof TypeDeclaration) {
            return ((TypeDeclaration)this._ast).getName();
        }
        throw new IllegalArgumentException("Anonymous class has no declared name");
    }

    @Override
    public boolean isInterface() {
        return this._ast instanceof InterfaceDeclaration;
    }

    @Override
    public boolean isStatic() {
        if (this._declaring == null) {
            return false;
        }
        return this._declaring.isInterface() || this.isInterface() || this._ast instanceof EnumDeclaration || this._mods.isStatic();
    }

    @Override
    public boolean isAbstract() {
        return this._mods.isAbstract();
    }

    @Override
    public boolean isFinal() {
        return this._mods.isFinal();
    }

    @Override
    public Access accessibility() {
        return this._declaring != null && this._declaring.isInterface() ? Access.PUBLIC : TreeClass.extractAccessibility(this._mods);
    }

    @Override
    public Access.Module accessModule() {
        return this._accessModule;
    }

    @Override
    public boolean hasRuntimeBindingsParams() {
        return true;
    }

    @Override
    public DJClass declaringClass() {
        return this._declaring;
    }

    @Override
    public Iterable<VariableType> declaredTypeParameters() {
        List paramAsts = Collections.emptyList();
        if (this._ast instanceof TypeDeclaration) {
            paramAsts = ((TypeDeclaration)this._ast).getTypeParams().unwrap(paramAsts);
        }
        return IterUtil.mapSnapshot(paramAsts, NodeProperties.NODE_TYPE_VARIABLE);
    }

    @Override
    public Iterable<Type> declaredSupertypes() {
        if (this._ast instanceof ClassDeclaration) {
            ClassDeclaration cd = (ClassDeclaration)this._ast;
            AbstractIterable superIs = cd.getInterfaces() == null ? IterUtil.empty() : IterUtil.mapSnapshot(cd.getInterfaces(), NodeProperties.NODE_TYPE);
            return IterUtil.compose(NodeProperties.getType(cd.getSuperclass()), superIs);
        }
        if (this._ast instanceof InterfaceDeclaration) {
            InterfaceDeclaration id = (InterfaceDeclaration)this._ast;
            if (id.getInterfaces() == null) {
                return IterUtil.empty();
            }
            return IterUtil.mapSnapshot(id.getInterfaces(), NodeProperties.NODE_TYPE);
        }
        if (this._ast instanceof AnonymousAllocation) {
            return IterUtil.singleton(NodeProperties.getType(((AnonymousAllocation)this._ast).getCreationType()));
        }
        if (this._ast instanceof AnonymousInnerAllocation) {
            return IterUtil.singleton(NodeProperties.getSuperType(this._ast));
        }
        throw new IllegalArgumentException("Unsupported class AST type");
    }

    @Override
    public Iterable<DJField> declaredFields() {
        return IterUtil.immutable(this._fields);
    }

    @Override
    public Iterable<DJConstructor> declaredConstructors() {
        return IterUtil.immutable(this._constructors);
    }

    @Override
    public Iterable<DJMethod> declaredMethods() {
        return IterUtil.immutable(this._methods);
    }

    @Override
    public Iterable<DJClass> declaredClasses() {
        return IterUtil.immutable(this._classes);
    }

    @Override
    public Type immediateSuperclass() {
        if (this._ast instanceof ClassDeclaration) {
            return NodeProperties.getType(((ClassDeclaration)this._ast).getSuperclass());
        }
        if (this._ast instanceof InterfaceDeclaration) {
            return TypeSystem.OBJECT;
        }
        if (this._ast instanceof AnonymousAllocation) {
            Type result = NodeProperties.getType(((AnonymousAllocation)this._ast).getCreationType());
            if (result instanceof ClassType && !((ClassType)result).ofClass().isInterface()) {
                return result;
            }
            return TypeSystem.OBJECT;
        }
        if (this._ast instanceof AnonymousInnerAllocation) {
            return NodeProperties.getSuperType(this._ast);
        }
        throw new IllegalArgumentException("Unsupported class AST type");
    }

    @Override
    public Class<?> load() {
        return this._loaded.value();
    }

    public String toString() {
        return "TreeClass(" + this._fullName + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        return this._ast == ((TreeClass)o)._ast;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ System.identityHashCode(this._ast);
    }

    private static Access extractAccessibility(ModifierSet mods) {
        if (mods.isPublic()) {
            return Access.PUBLIC;
        }
        if (mods.isProtected()) {
            return Access.PROTECTED;
        }
        if (mods.isPrivate()) {
            return Access.PRIVATE;
        }
        return Access.PACKAGE;
    }

    private boolean paramsMatch(Iterable<LocalVariable> p1, Iterable<LocalVariable> p2) {
        if (IterUtil.sizeOf(p1) == IterUtil.sizeOf(p2)) {
            TypeSystem ts = this._opt.typeSystem();
            for (Pair pair : IterUtil.zip(p1, p2)) {
                Thunk<Class<?>> c1 = ts.erasedClass(((LocalVariable)pair.first()).type());
                Thunk<Class<?>> c2 = ts.erasedClass(((LocalVariable)pair.second()).type());
                if (c1.value().equals(c2.value())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeMethod
    implements DJMethod {
        private MethodDeclaration _m;
        private Thunk<DJMethod> _loaded;

        public TreeMethod(MethodDeclaration m) {
            this._m = m;
            this._loaded = LazyThunk.make(new Thunk<DJMethod>(){

                @Override
                public DJMethod value() {
                    Iterable<LocalVariable> params = TreeMethod.this.parameters();
                    if (TreeMethod.this.isStatic()) {
                        params = IterUtil.compose(new LocalVariable("", RUNTIME_BINDINGS_TYPE, false), params);
                    }
                    DJClass c = SymbolUtil.wrapClass(TreeClass.this.load());
                    for (DJMethod candidate : c.declaredMethods()) {
                        if (!TreeMethod.this.declaredName().equals(candidate.declaredName()) || !TreeClass.this.paramsMatch(params, candidate.parameters())) continue;
                        return candidate;
                    }
                    DebugUtil.debug.logValues(new String[]{"name", "params", "candidates"}, TreeMethod.this.declaredName(), params, c.declaredMethods());
                    throw new RuntimeException("Can't find method in loaded class");
                }
            });
        }

        @Override
        public String declaredName() {
            return this._m.getName();
        }

        @Override
        public DJClass declaringClass() {
            return TreeClass.this;
        }

        @Override
        public boolean isStatic() {
            return this._m.getModifiers().isStatic();
        }

        @Override
        public boolean isAbstract() {
            return this._m.getModifiers().isAbstract() || TreeClass.this.isInterface();
        }

        @Override
        public boolean isFinal() {
            return this._m.getModifiers().isFinal();
        }

        @Override
        public Access accessibility() {
            return TreeClass.this.isInterface() ? Access.PUBLIC : TreeClass.extractAccessibility(this._m.getModifiers());
        }

        @Override
        public Access.Module accessModule() {
            return TreeClass.this._accessModule;
        }

        @Override
        public Type returnType() {
            return NodeProperties.getType(this._m.getReturnType());
        }

        @Override
        public Iterable<VariableType> typeParameters() {
            List paramAsts = this._m.getTypeParams().unwrap(Collections.emptyList());
            return IterUtil.mapSnapshot(paramAsts, NodeProperties.NODE_TYPE_VARIABLE);
        }

        @Override
        public Iterable<LocalVariable> parameters() {
            return IterUtil.mapSnapshot(this._m.getParameters(), NodeProperties.NODE_VARIABLE);
        }

        @Override
        public Iterable<Type> thrownTypes() {
            return IterUtil.mapSnapshot(this._m.getExceptions(), NodeProperties.NODE_TYPE);
        }

        @Override
        public DJMethod declaredSignature() {
            return this;
        }

        @Override
        public Object evaluate(Object receiver, Iterable<Object> args, RuntimeBindings bindings, Options options) throws EvaluatorException {
            if (this.isStatic()) {
                args = IterUtil.compose(bindings, args);
            }
            return this._loaded.value().evaluate(receiver, args, bindings, options);
        }

        public String toString() {
            return "TreeMethod(" + this.declaredName() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExplicitTreeConstructor
    extends TreeConstructor {
        private final ConstructorDeclaration _k;

        public ExplicitTreeConstructor(ConstructorDeclaration k) {
            this._k = k;
        }

        @Override
        public Access accessibility() {
            return TreeClass.extractAccessibility(this._k.getModifiers());
        }

        @Override
        public Iterable<VariableType> typeParameters() {
            List paramAsts = this._k.getTypeParams().unwrap(Collections.emptyList());
            return IterUtil.mapSnapshot(paramAsts, NodeProperties.NODE_TYPE_VARIABLE);
        }

        @Override
        public Iterable<LocalVariable> parameters() {
            return IterUtil.mapSnapshot(this._k.getParameters(), NodeProperties.NODE_VARIABLE);
        }

        @Override
        public Iterable<Type> thrownTypes() {
            return IterUtil.mapSnapshot(this._k.getExceptions(), NodeProperties.NODE_TYPE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultTreeConstructor
    extends TreeConstructor {
        private DefaultTreeConstructor() {
        }

        @Override
        public Access accessibility() {
            return Access.PUBLIC;
        }

        @Override
        public Iterable<VariableType> typeParameters() {
            return IterUtil.empty();
        }

        @Override
        public Iterable<LocalVariable> parameters() {
            return IterUtil.empty();
        }

        @Override
        public Iterable<Type> thrownTypes() {
            return IterUtil.empty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TreeConstructor
    implements DJConstructor {
        private final Thunk<DJConstructor> _loaded;
        private final DJClass _outerClass;

        public TreeConstructor() {
            this._loaded = LazyThunk.make(new Thunk<DJConstructor>(){

                @Override
                public DJConstructor value() {
                    Iterable<LocalVariable> params = TreeConstructor.this.parameters();
                    if (TreeConstructor.this._outerClass == null) {
                        params = IterUtil.compose(new LocalVariable("", RUNTIME_BINDINGS_TYPE, false), params);
                    }
                    DJClass c = SymbolUtil.wrapClass(TreeClass.this.load());
                    for (DJConstructor candidate : c.declaredConstructors()) {
                        if (!TreeClass.this.paramsMatch(params, candidate.parameters())) continue;
                        return candidate;
                    }
                    DebugUtil.debug.logValues(new String[]{"params", "candidates"}, params, c.declaredConstructors());
                    throw new RuntimeException("Can't find constructor in loaded class");
                }
            });
            this._outerClass = SymbolUtil.dynamicOuterClass(TreeClass.this);
        }

        @Override
        public String declaredName() {
            return TreeClass.this.isAnonymous() ? "<anonymous>" : TreeClass.this.declaredName();
        }

        @Override
        public DJClass declaringClass() {
            return TreeClass.this;
        }

        @Override
        public Access.Module accessModule() {
            return TreeClass.this._accessModule;
        }

        @Override
        public Type returnType() {
            return SymbolUtil.thisType(TreeClass.this);
        }

        @Override
        public DJConstructor declaredSignature() {
            return this;
        }

        @Override
        public Object evaluate(Object outer, Iterable<Object> args, RuntimeBindings bindings, Options options) throws EvaluatorException {
            if (this._outerClass == null) {
                args = IterUtil.compose(bindings, args);
            }
            return this._loaded.value().evaluate(outer, args, bindings, options);
        }

        public String toString() {
            return "TreeConstructor(" + this.declaredName() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeField
    implements DJField {
        private final FieldDeclaration _f;
        private final Thunk<DJField> _loaded;

        public TreeField(FieldDeclaration f) {
            this._f = f;
            this._loaded = LazyThunk.make(new Thunk<DJField>(){

                @Override
                public DJField value() {
                    DJClass c = SymbolUtil.wrapClass(TreeClass.this.load());
                    for (DJField candidate : c.declaredFields()) {
                        if (!TreeField.this.declaredName().equals(candidate.declaredName())) continue;
                        return candidate;
                    }
                    DebugUtil.debug.logValues(new String[]{"name", "candidates"}, TreeField.this.declaredName(), c.declaredFields());
                    throw new RuntimeException("Can't find field in loaded class");
                }
            });
        }

        @Override
        public String declaredName() {
            return this._f.getName();
        }

        @Override
        public DJClass declaringClass() {
            return TreeClass.this;
        }

        @Override
        public Type type() {
            return NodeProperties.getType(this._f.getType());
        }

        @Override
        public boolean isFinal() {
            return this._f.getModifiers().isFinal() || TreeClass.this.isInterface();
        }

        @Override
        public boolean isStatic() {
            return this._f.getModifiers().isStatic() || TreeClass.this.isInterface();
        }

        @Override
        public Access accessibility() {
            return TreeClass.this.isInterface() ? Access.PUBLIC : TreeClass.extractAccessibility(this._f.getModifiers());
        }

        @Override
        public Access.Module accessModule() {
            return TreeClass.this._accessModule;
        }

        @Override
        public Option<Object> constantValue() {
            Expression init;
            if (this.isFinal() && this.isStatic() && (init = this._f.getInitializer()) != null) {
                if (NodeProperties.hasValue(init)) {
                    return Option.some(NodeProperties.getValue(init));
                }
                if (init instanceof Literal) {
                    return Option.some(((Literal)init).getValue());
                }
            }
            return Option.none();
        }

        @Override
        public Box<Object> boxForReceiver(Object receiver) {
            return this._loaded.value().boxForReceiver(receiver);
        }

        public String toString() {
            return "TreeField(" + this.declaredName() + ")";
        }
    }
}

