/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.plt.iter.IterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalContext
extends DelegatingContext {
    private ClassLoader _loader;
    private Iterable<DJClass> _classes;
    private Iterable<LocalVariable> _vars;
    private Iterable<LocalFunction> _functions;

    public LocalContext(TypeContext next, ClassLoader loader, Iterable<DJClass> classes, Iterable<LocalVariable> vars, Iterable<LocalFunction> functions) {
        super(next);
        this._loader = loader;
        this._classes = classes;
        this._vars = vars;
        this._functions = functions;
    }

    public LocalContext(TypeContext next, Iterable<LocalVariable> vars) {
        this(next, null, IterUtil.empty(), vars, IterUtil.empty());
    }

    public LocalContext(TypeContext next, LocalVariable var) {
        this(next, null, IterUtil.empty(), IterUtil.singleton(var), IterUtil.empty());
    }

    public LocalContext(TypeContext next, ClassLoader loader, DJClass c) {
        this(next, loader, IterUtil.singleton(c), IterUtil.empty(), IterUtil.empty());
    }

    public LocalContext(TypeContext next, LocalFunction f) {
        this(next, null, IterUtil.empty(), IterUtil.empty(), IterUtil.singleton(f));
    }

    @Override
    protected LocalContext duplicate(TypeContext next) {
        return new LocalContext(next, this._loader, this._classes, this._vars, this._functions);
    }

    @Override
    public boolean typeExists(String name, TypeSystem ts) {
        return this.declaredClass(name) != null || super.typeExists(name, ts);
    }

    @Override
    public boolean topLevelClassExists(String name, TypeSystem ts) {
        return this.declaredClass(name) != null || super.topLevelClassExists(name, ts);
    }

    @Override
    public DJClass getTopLevelClass(String name, TypeSystem ts) throws AmbiguousNameException {
        DJClass result = this.declaredClass(name);
        return result == null ? super.getTopLevelClass(name, ts) : result;
    }

    @Override
    public boolean memberClassExists(String name, TypeSystem ts) {
        return this.declaredClass(name) == null && super.memberClassExists(name, ts);
    }

    @Override
    public ClassType typeContainingMemberClass(String name, TypeSystem ts) throws AmbiguousNameException {
        return this.declaredClass(name) == null ? super.typeContainingMemberClass(name, ts) : null;
    }

    @Override
    public boolean typeVariableExists(String name, TypeSystem ts) {
        return this.declaredClass(name) == null && super.typeVariableExists(name, ts);
    }

    @Override
    public VariableType getTypeVariable(String name, TypeSystem ts) {
        return this.declaredClass(name) == null ? super.getTypeVariable(name, ts) : null;
    }

    private DJClass declaredClass(String name) {
        for (DJClass c : this._classes) {
            if (c.isAnonymous() || !c.declaredName().equals(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.declaredVariable(name) != null || super.variableExists(name, ts);
    }

    @Override
    public boolean localVariableExists(String name, TypeSystem ts) {
        return this.declaredVariable(name) != null || super.localVariableExists(name, ts);
    }

    @Override
    public LocalVariable getLocalVariable(String name, TypeSystem ts) {
        LocalVariable result = this.declaredVariable(name);
        return result == null ? super.getLocalVariable(name, ts) : result;
    }

    @Override
    public boolean fieldExists(String name, TypeSystem ts) {
        return this.declaredVariable(name) == null && super.fieldExists(name, ts);
    }

    @Override
    public ClassType typeContainingField(String name, TypeSystem ts) throws AmbiguousNameException {
        return this.declaredVariable(name) == null ? super.typeContainingField(name, ts) : null;
    }

    private LocalVariable declaredVariable(String name) {
        for (LocalVariable v : this._vars) {
            if (!v.declaredName().equals(name)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.hasFunction(name) || super.functionExists(name, ts);
    }

    @Override
    public boolean localFunctionExists(String name, TypeSystem ts) {
        return this.hasFunction(name) || super.localFunctionExists(name, ts);
    }

    @Override
    public Iterable<LocalFunction> getLocalFunctions(String name, TypeSystem ts, Iterable<LocalFunction> partial) {
        Iterable<LocalFunction> newPartial = partial;
        for (LocalFunction f : this._functions) {
            if (!f.declaredName().equals(name)) continue;
            newPartial = IterUtil.compose(partial, f);
        }
        return super.getLocalFunctions(name, ts, newPartial);
    }

    @Override
    public boolean methodExists(String name, TypeSystem ts) {
        return !this.hasFunction(name) && super.methodExists(name, ts);
    }

    @Override
    public Type typeContainingMethod(String name, TypeSystem ts) {
        return this.hasFunction(name) ? null : super.typeContainingMethod(name, ts);
    }

    private boolean hasFunction(String name) {
        for (LocalFunction f : this._functions) {
            if (!f.declaredName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this._loader == null) {
            return super.getClassLoader();
        }
        return this._loader;
    }
}

