/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.DrJavaProperty;
import edu.rice.cs.drjava.config.MutableFileProperty;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.drjava.ui.ExternalProcessPanel;
import edu.rice.cs.drjava.ui.InsertVariableDialog;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.BalancingStreamTokenizer;
import edu.rice.cs.util.GeneralProcessCreator;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.XMLConfig;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.FileChooser;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ExecuteExternalDialog
extends SwingFrame
implements OptionConstants {
    private static final int FRAME_WIDTH = 750;
    private static final int FRAME_HEIGHT = 500;
    private JButton _runCommandButton;
    private JButton _saveCommandButton;
    private JButton _insertCommandButton;
    private JButton _cancelCommandButton;
    private JTextPane _commandLine;
    private JLabel _commandLinePreviewLabel;
    private JTextPane _commandLinePreview;
    private StyledDocument _commandLineDoc;
    private JTextPane _commandWorkDirLine;
    private JTextPane _commandWorkDirLinePreview;
    private StyledDocument _commandWorkDirLineDoc;
    private JButton _commandWorkDirBtn;
    private JTextPane _commandEnclosingFileLine;
    private JTextPane _commandEnclosingFileLinePreview;
    private StyledDocument _commandEnclosingFileLineDoc;
    private JButton _commandEnclosingFileBtn;
    private JTextPane _lastCommandFocus;
    SimpleAttributeSet _varCommandLineCmdStyle;
    SimpleAttributeSet _varErrorCommandLineCmdStyle;
    SimpleAttributeSet _commandLineCmdAS;
    JPanel _commandPanel;
    DocumentListener _documentListener;
    DocumentListener _workDirDocumentListener;
    DocumentListener _enclosingFileDocumentListener;
    protected DirectoryChooser _dirChooser;
    protected FileChooser _fileChooser;
    protected InsertVariableDialog _insertVarDialog;
    protected CompletionMonitor _insertVarDialogMonitor = new CompletionMonitor();
    private CompletionMonitor _cm;
    protected MainFrame _mainFrame;
    protected FrameState _lastState = null;
    protected boolean _editMode = false;
    protected int _editIndex = -1;
    protected PropertyMaps _props;
    public static final String STALE_TOOLTIP = "<html>Note: Values of variables might not be current for<br>performance reasons. They will be current when executed.</html>";
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            ExecuteExternalDialog.this._cancel();
        }
    };

    public FrameState getFrameState() {
        return this._lastState;
    }

    public void setFrameState(FrameState ds) {
        this._lastState = ds;
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
            this.validate();
        }
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
        } else {
            Utilities.setPopupLoc(this, this._mainFrame);
        }
        this.validate();
    }

    public ExecuteExternalDialog(MainFrame mf, boolean editMode, int editIndex, CompletionMonitor cm) {
        super("Execute External Process");
        try {
            this._props = PropertyMaps.TEMPLATE.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnexpectedException(e);
        }
        this._mainFrame = mf;
        this._editMode = editMode;
        this._editIndex = editIndex;
        this._cm = cm;
        this.initComponents();
        if (editMode) {
            if (editIndex >= DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_COUNT)) {
                throw new IllegalArgumentException("Trying to edit saved external process that does not exist");
            }
            String cmdline = (String)((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES))).get(editIndex);
            String workdir = (String)((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS))).get(editIndex);
            String enclosingFile = (String)((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES))).get(editIndex);
            this._commandLine.setText(cmdline);
            this._commandWorkDirLine.setText(workdir);
            this._commandEnclosingFileLine.setText(enclosingFile);
        }
        this.initDone();
    }

    public ExecuteExternalDialog(MainFrame mf) {
        this(mf, false, -1, null);
    }

    private void initComponents() {
        this._dirChooser = new DirectoryChooser(this);
        this._dirChooser.setDialogTitle("Select Work Directory");
        this._dirChooser.setApproveButtonText("Select");
        this._fileChooser = new FileChooser(null);
        this._fileChooser.setDialogTitle("Select Enclosing .djapp File");
        this._fileChooser.setApproveButtonText("Select");
        super.getContentPane().setLayout(new GridLayout(1, 1));
        if (this._editMode) {
            AbstractAction saveCommandAction = new AbstractAction("Save"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecuteExternalDialog.this._saveCommand();
                }
            };
            this._saveCommandButton = new JButton(saveCommandAction);
        } else {
            AbstractAction runCommandAction = new AbstractAction("Run Command Line"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecuteExternalDialog.this._runCommand();
                }
            };
            this._runCommandButton = new JButton(runCommandAction);
            this._runCommandButton.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ExecuteExternalDialog.this._insertCommandButton.setEnabled(false);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == ExecuteExternalDialog.this._commandLinePreview || e.getOppositeComponent() == ExecuteExternalDialog.this._commandWorkDirLinePreview || e.getOppositeComponent() == ExecuteExternalDialog.this._commandEnclosingFileLinePreview) {
                        ExecuteExternalDialog.this._runCommandButton.requestFocus();
                    }
                }
            });
            AbstractAction saveCommandAction = new AbstractAction("Save to Menu..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecuteExternalDialog.this._saveCommand();
                }
            };
            this._saveCommandButton = new JButton(saveCommandAction);
        }
        this._insertVarDialog = new InsertVariableDialog(this._mainFrame, this._insertVarDialogMonitor);
        AbstractAction insertCommandAction = new AbstractAction("Insert Variable..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteExternalDialog.this._insertVariableCommand();
            }
        };
        this._insertCommandButton = new JButton(insertCommandAction);
        this._insertCommandButton.setEnabled(false);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteExternalDialog.this._cancel();
            }
        };
        this._cancelCommandButton = new JButton(cancelAction);
        Utilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ExecuteExternalDialog.this._commandPanel = ExecuteExternalDialog.this.makeCommandPane();
                ExecuteExternalDialog.this.getContentPane().add(ExecuteExternalDialog.this._commandPanel);
                ExecuteExternalDialog.this.setResizable(false);
                ExecuteExternalDialog.this.setSize(750, 500);
                Utilities.setPopupLoc(ExecuteExternalDialog.this, ExecuteExternalDialog.this._mainFrame);
                ExecuteExternalDialog.this._commandLine.requestFocus();
            }
        });
    }

    private JPanel makeCommandPane() {
        JPanel panel = new JPanel(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        JPanel main = new JPanel(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        main.setLayout(gridbag);
        c.fill = 1;
        Insets labelInsets = new Insets(5, 10, 0, 0);
        Insets compInsets = new Insets(5, 5, 0, 10);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = labelInsets;
        JLabel commandLineLabel = new JLabel("Command line:");
        gridbag.setConstraints(commandLineLabel, c);
        main.add(commandLineLabel);
        c.weightx = 1.0;
        c.weighty = 32.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandLine = new JTextPane();
        this._commandLine.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                } else if (e.getKeyCode() == 9) {
                    e.consume();
                    if (e.isShiftDown()) {
                        ExecuteExternalDialog.this._insertCommandButton.setEnabled(false);
                        ExecuteExternalDialog.this._cancelCommandButton.requestFocus();
                    } else {
                        ExecuteExternalDialog.this._commandWorkDirLine.requestFocus();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane commandLineSP = new JScrollPane(this._commandLine);
        commandLineSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandLineSP, c);
        main.add(commandLineSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        this._commandLinePreviewLabel = new JLabel("<html>Command line preview:<br>(0 characters)</html>");
        this._commandLinePreviewLabel.setToolTipText(STALE_TOOLTIP);
        gridbag.setConstraints(this._commandLinePreviewLabel, c);
        main.add(this._commandLinePreviewLabel);
        c.weightx = 1.0;
        c.weighty = 32.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandLinePreview = new JTextPane();
        this._commandLinePreview.setToolTipText(STALE_TOOLTIP);
        this._commandLineDoc = (StyledDocument)this._commandLinePreview.getDocument();
        this._varCommandLineCmdStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this._varCommandLineCmdStyle, DrJava.getConfig().getSetting(DEFINITIONS_MATCH_COLOR));
        this._commandLineCmdAS = new SimpleAttributeSet();
        StyleConstants.setForeground(this._commandLineCmdAS, DrJava.getConfig().getSetting(DEFINITIONS_NORMAL_COLOR));
        this._varCommandLineCmdStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this._varCommandLineCmdStyle, DrJava.getConfig().getSetting(DEFINITIONS_MATCH_COLOR));
        this._varErrorCommandLineCmdStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this._varErrorCommandLineCmdStyle, DrJava.getConfig().getSetting(DEBUG_BREAKPOINT_COLOR));
        this._varCommandLineCmdStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this._varCommandLineCmdStyle, DrJava.getConfig().getSetting(DEFINITIONS_MATCH_COLOR));
        this._commandLinePreview.setEditable(false);
        this._commandLinePreview.setBackground(Color.LIGHT_GRAY);
        this._commandLinePreview.setSelectedTextColor(Color.LIGHT_GRAY);
        JScrollPane commandLinePreviewSP = new JScrollPane(this._commandLinePreview);
        commandLinePreviewSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandLinePreviewSP, c);
        main.add(commandLinePreviewSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel workDirLabel = new JLabel("Work directory:");
        gridbag.setConstraints(workDirLabel, c);
        main.add(workDirLabel);
        c.weightx = 1.0;
        c.weighty = 8.0;
        c.gridwidth = -1;
        c.insets = compInsets;
        this._commandWorkDirLine = new JTextPane();
        this._commandWorkDirLine.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                } else if (e.getKeyCode() == 9) {
                    e.consume();
                    if (e.isShiftDown()) {
                        ExecuteExternalDialog.this._commandLine.requestFocus();
                    } else {
                        ExecuteExternalDialog.this._commandEnclosingFileLine.requestFocus();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane commandWorkDirLineSP = new JScrollPane(this._commandWorkDirLine);
        commandWorkDirLineSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandWorkDirLineSP, c);
        main.add(commandWorkDirLineSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandWorkDirBtn = new JButton("...");
        this._commandWorkDirBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteExternalDialog.this.chooseFile(ExecuteExternalDialog.this._commandWorkDirLine);
            }
        });
        gridbag.setConstraints(this._commandWorkDirBtn, c);
        main.add(this._commandWorkDirBtn);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel commandWorkDirLinePreviewLabel = new JLabel("Work directory preview:");
        commandWorkDirLinePreviewLabel.setToolTipText(STALE_TOOLTIP);
        gridbag.setConstraints(commandWorkDirLinePreviewLabel, c);
        main.add(commandWorkDirLinePreviewLabel);
        c.weightx = 1.0;
        c.weighty = 8.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandWorkDirLinePreview = new JTextPane();
        this._commandWorkDirLinePreview.setToolTipText(STALE_TOOLTIP);
        this._commandWorkDirLineDoc = (StyledDocument)this._commandWorkDirLinePreview.getDocument();
        this._commandWorkDirLinePreview.setEditable(false);
        this._commandWorkDirLinePreview.setBackground(Color.LIGHT_GRAY);
        this._commandWorkDirLinePreview.setSelectedTextColor(Color.LIGHT_GRAY);
        JScrollPane commandWorkDirLinePreviewSP = new JScrollPane(this._commandWorkDirLinePreview);
        commandWorkDirLinePreviewSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandWorkDirLinePreviewSP, c);
        main.add(commandWorkDirLinePreviewSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel enclosingFileLabel = new JLabel("Enclosing .djapp file:");
        gridbag.setConstraints(enclosingFileLabel, c);
        main.add(enclosingFileLabel);
        c.weightx = 1.0;
        c.weighty = 8.0;
        c.gridwidth = -1;
        c.insets = compInsets;
        this._commandEnclosingFileLine = new JTextPane();
        this._commandEnclosingFileLine.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                } else if (e.getKeyCode() == 9) {
                    e.consume();
                    if (e.isShiftDown()) {
                        ExecuteExternalDialog.this._commandWorkDirLine.requestFocus();
                    } else {
                        ExecuteExternalDialog.this._insertCommandButton.setEnabled(false);
                        if (ExecuteExternalDialog.this._editMode) {
                            ExecuteExternalDialog.this._saveCommandButton.requestFocus();
                        } else {
                            ExecuteExternalDialog.this._runCommandButton.requestFocus();
                        }
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane commandEnclosingFileLineSP = new JScrollPane(this._commandEnclosingFileLine);
        commandEnclosingFileLineSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandEnclosingFileLineSP, c);
        main.add(commandEnclosingFileLineSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandEnclosingFileBtn = new JButton("...");
        this._commandEnclosingFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteExternalDialog.this.chooseFile(ExecuteExternalDialog.this._commandEnclosingFileLine);
            }
        });
        gridbag.setConstraints(this._commandEnclosingFileBtn, c);
        main.add(this._commandEnclosingFileBtn);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel commandEnclosingFileLinePreviewLabel = new JLabel("Enclosing .djapp file preview:");
        commandEnclosingFileLinePreviewLabel.setToolTipText(STALE_TOOLTIP);
        gridbag.setConstraints(commandEnclosingFileLinePreviewLabel, c);
        main.add(commandEnclosingFileLinePreviewLabel);
        c.weightx = 1.0;
        c.weighty = 8.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandEnclosingFileLinePreview = new JTextPane();
        this._commandEnclosingFileLinePreview.setToolTipText(STALE_TOOLTIP);
        this._commandEnclosingFileLineDoc = (StyledDocument)this._commandEnclosingFileLinePreview.getDocument();
        this._commandEnclosingFileLinePreview.setEditable(false);
        this._commandEnclosingFileLinePreview.setBackground(Color.LIGHT_GRAY);
        this._commandEnclosingFileLinePreview.setSelectedTextColor(Color.LIGHT_GRAY);
        JScrollPane commandEnclosingFileLinePreviewSP = new JScrollPane(this._commandEnclosingFileLinePreview);
        commandEnclosingFileLinePreviewSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandEnclosingFileLinePreviewSP, c);
        main.add(commandEnclosingFileLinePreviewSP);
        panel.add((Component)main, "Center");
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        if (!this._editMode) {
            bottom.add(this._runCommandButton);
        }
        bottom.add(this._saveCommandButton);
        bottom.add(this._insertCommandButton);
        bottom.add(this._cancelCommandButton);
        bottom.add(Box.createHorizontalGlue());
        panel.add((Component)bottom, "South");
        this._documentListener = new DocumentListener(){

            public void update(DocumentEvent e) {
                assert (EventQueue.isDispatchThread());
                try {
                    ExecuteExternalDialog.this._commandLineDoc.remove(0, ExecuteExternalDialog.this._commandLineDoc.getLength());
                    String text = StringOps.replaceVariables(ExecuteExternalDialog.this._commandLine.getText(), ExecuteExternalDialog.this._props, PropertyMaps.GET_LAZY);
                    ExecuteExternalDialog.this._commandLineDoc.insertString(ExecuteExternalDialog.this._commandLineDoc.getLength(), StringOps.unescapeFileName(text), null);
                    ExecuteExternalDialog.this.colorVariables(ExecuteExternalDialog.this._commandLine, ExecuteExternalDialog.this._props, this, ExecuteExternalDialog.this._commandLineCmdAS, ExecuteExternalDialog.this._varCommandLineCmdStyle, ExecuteExternalDialog.this._varErrorCommandLineCmdStyle);
                    ExecuteExternalDialog.this._commandLinePreviewLabel.setText("<html>Command line preview:<br>(" + ExecuteExternalDialog.this._commandLinePreview.getText().length() + " characters)</html>");
                }
                catch (BadLocationException ble) {
                    ExecuteExternalDialog.this._commandLinePreview.setText("Error.");
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }
        };
        this._commandLine.getDocument().addDocumentListener(this._documentListener);
        this._documentListener.changedUpdate(null);
        this._workDirDocumentListener = new DocumentListener(){

            public void update(DocumentEvent e) {
                assert (EventQueue.isDispatchThread());
                try {
                    ExecuteExternalDialog.this._commandWorkDirLineDoc.remove(0, ExecuteExternalDialog.this._commandWorkDirLineDoc.getLength());
                    String text = StringOps.replaceVariables(ExecuteExternalDialog.this._commandWorkDirLine.getText(), ExecuteExternalDialog.this._props, PropertyMaps.GET_LAZY);
                    ExecuteExternalDialog.this._commandWorkDirLineDoc.insertString(0, StringOps.unescapeFileName(text), null);
                    ExecuteExternalDialog.this.colorVariables(ExecuteExternalDialog.this._commandWorkDirLine, ExecuteExternalDialog.this._props, this, ExecuteExternalDialog.this._commandLineCmdAS, ExecuteExternalDialog.this._varCommandLineCmdStyle, ExecuteExternalDialog.this._varErrorCommandLineCmdStyle);
                }
                catch (BadLocationException ble) {
                    ExecuteExternalDialog.this._commandLinePreview.setText("Error: " + ble);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }
        };
        this._commandWorkDirLine.getDocument().addDocumentListener(this._workDirDocumentListener);
        this._commandWorkDirLine.setText("${drjava.working.dir}");
        this._workDirDocumentListener.changedUpdate(null);
        this._enclosingFileDocumentListener = new DocumentListener(){

            public void update(DocumentEvent e) {
                assert (EventQueue.isDispatchThread());
                try {
                    ExecuteExternalDialog.this._commandEnclosingFileLineDoc.remove(0, ExecuteExternalDialog.this._commandEnclosingFileLineDoc.getLength());
                    String text = StringOps.replaceVariables(ExecuteExternalDialog.this._commandEnclosingFileLine.getText(), ExecuteExternalDialog.this._props, PropertyMaps.GET_LAZY);
                    ExecuteExternalDialog.this._commandEnclosingFileLineDoc.insertString(0, StringOps.unescapeFileName(text), null);
                    ExecuteExternalDialog.this.colorVariables(ExecuteExternalDialog.this._commandEnclosingFileLine, ExecuteExternalDialog.this._props, this, ExecuteExternalDialog.this._commandLineCmdAS, ExecuteExternalDialog.this._varCommandLineCmdStyle, ExecuteExternalDialog.this._varErrorCommandLineCmdStyle);
                }
                catch (BadLocationException ble) {
                    ExecuteExternalDialog.this._commandLinePreview.setText("Error: " + ble);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }
        };
        this._commandEnclosingFileLine.getDocument().addDocumentListener(this._enclosingFileDocumentListener);
        this._commandEnclosingFileLine.setText("");
        this._enclosingFileDocumentListener.changedUpdate(null);
        this._lastCommandFocus = this._commandLine;
        this._commandLine.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ExecuteExternalDialog.this._lastCommandFocus = (JTextPane)e.getComponent();
                ExecuteExternalDialog.this._insertCommandButton.setEnabled(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == ExecuteExternalDialog.this._commandLinePreview || e.getOppositeComponent() == ExecuteExternalDialog.this._commandWorkDirLinePreview) {
                    ExecuteExternalDialog.this._commandLine.requestFocus();
                }
            }
        });
        this._commandWorkDirLine.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ExecuteExternalDialog.this._lastCommandFocus = (JTextPane)e.getComponent();
                ExecuteExternalDialog.this._insertCommandButton.setEnabled(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == ExecuteExternalDialog.this._commandLinePreview || e.getOppositeComponent() == ExecuteExternalDialog.this._commandWorkDirLinePreview) {
                    ExecuteExternalDialog.this._commandWorkDirLine.requestFocus();
                }
            }
        });
        return panel;
    }

    protected void colorVariables(final JTextPane pane, final PropertyMaps props, final DocumentListener dl, final SimpleAttributeSet normal, final SimpleAttributeSet variable, final SimpleAttributeSet error) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StyledDocument doc = (StyledDocument)pane.getDocument();
                doc.removeDocumentListener(dl);
                String str = pane.getText();
                BalancingStreamTokenizer tok = new BalancingStreamTokenizer(new StringReader(str), Character.valueOf('$'));
                tok.wordRange(0, 255);
                tok.addQuotes("${", "}");
                int pos = 0;
                doc.setCharacterAttributes(0, str.length(), normal, true);
                String next = null;
                try {
                    while ((next = tok.getNextToken()) != null) {
                        if (tok.token() == BalancingStreamTokenizer.Token.QUOTED && next.startsWith("${")) {
                            if (next.endsWith("}")) {
                                String key;
                                String attrList = "";
                                int firstCurly = next.indexOf(125);
                                int firstSemi = next.indexOf(59);
                                if (firstSemi < 0) {
                                    key = next.substring(2, firstCurly);
                                } else {
                                    key = next.substring(2, firstSemi);
                                    attrList = next.substring(firstSemi + 1, next.length() - 1).trim();
                                }
                                boolean found = false;
                                for (String category : props.getCategories()) {
                                    DrJavaProperty p = props.getProperty(category, key);
                                    if (p != null) {
                                        found = true;
                                        doc.setCharacterAttributes(pos, pos + next.length(), variable, true);
                                        if (attrList.length() > 0) {
                                            int subpos = pos + 2 + key.length() + 1;
                                            int added = 0;
                                            BalancingStreamTokenizer atok = new BalancingStreamTokenizer(new StringReader(attrList), Character.valueOf('$'));
                                            atok.wordRange(0, 255);
                                            atok.addQuotes("${", "}");
                                            atok.addQuotes("\"", "\"");
                                            atok.addKeyword(";");
                                            atok.addKeyword("=");
                                            String n = null;
                                            while ((n = atok.getNextToken()) != null) {
                                                if (n == null || atok.token() != BalancingStreamTokenizer.Token.NORMAL || n.trim().equals(";") || n.trim().equals("=") || n.trim().startsWith("\"")) {
                                                    doc.setCharacterAttributes(subpos, pos + next.length(), error, true);
                                                    break;
                                                }
                                                added += n.length();
                                                String name = n.trim();
                                                n = atok.getNextToken();
                                                if (n == null || atok.token() != BalancingStreamTokenizer.Token.KEYWORD || !n.trim().equals("=")) {
                                                    doc.setCharacterAttributes(subpos, pos + next.length(), error, true);
                                                    break;
                                                }
                                                added += n.length();
                                                n = atok.getNextToken();
                                                if (n == null || atok.token() != BalancingStreamTokenizer.Token.QUOTED || !n.trim().startsWith("\"")) {
                                                    doc.setCharacterAttributes(subpos, pos + next.length(), error, true);
                                                    break;
                                                }
                                                added += n.length();
                                                n = atok.getNextToken();
                                                if (n != null && (atok.token() != BalancingStreamTokenizer.Token.KEYWORD || !n.equals(";")) || n == null && atok.token() != BalancingStreamTokenizer.Token.END) {
                                                    doc.setCharacterAttributes(subpos, pos + next.length(), error, true);
                                                    break;
                                                }
                                                if (n != null) {
                                                    added += n.length();
                                                }
                                                try {
                                                    p.getAttribute(name);
                                                }
                                                catch (IllegalArgumentException e) {
                                                    doc.setCharacterAttributes(subpos, subpos + added, error, true);
                                                }
                                                subpos += added;
                                            }
                                        }
                                    }
                                    if (!found) continue;
                                    break;
                                }
                                if (!found) {
                                    doc.setCharacterAttributes(pos, pos + next.length(), error, true);
                                }
                            } else {
                                doc.setCharacterAttributes(pos, pos + next.length(), error, true);
                            }
                        } else {
                            doc.setCharacterAttributes(pos, pos + next.length(), normal, true);
                        }
                        pos += next.length();
                    }
                }
                catch (IOException e) {
                }
                finally {
                    doc.addDocumentListener(dl);
                }
            }
        });
    }

    private void _cancel() {
        this._lastState = new FrameState(this);
        this.setVisible(false);
        if (this._cm != null) {
            this._cm.signal();
        }
    }

    public ExternalProcessPanel runCommand(String name, String cmdline, String workdir, String enclosingFile, PropertyMaps pm) {
        ((MutableFileProperty)pm.getProperty("enclosing.djapp.file")).setFile(enclosingFile.length() > 0 ? new File(enclosingFile) : null);
        GeneralProcessCreator pc = new GeneralProcessCreator(cmdline, workdir.trim(), pm);
        String label = "External";
        if (!name.equals("")) {
            label = label + ": " + name;
        }
        final ExternalProcessPanel panel = new ExternalProcessPanel(this._mainFrame, label, pc);
        this._mainFrame._tabs.addLast(panel);
        panel.getMainPanel().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ExecuteExternalDialog.this._mainFrame._lastFocusOwner = panel;
            }
        });
        panel.setVisible(true);
        this._mainFrame.showTab(panel, true);
        this._mainFrame._tabbedPane.setSelectedComponent(panel);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                panel.requestFocusInWindow();
            }
        });
        return panel;
    }

    private void _runCommand() {
        this._mainFrame.updateStatusField("Executing external process...");
        GeneralProcessCreator.LOG.log("_runCommand(): ${enclosing.djapp.file} = " + this._commandEnclosingFileLine.getText());
        this._mainFrame.removeModalWindowAdapter(this);
        if (this._commandLinePreview.getText().length() > 0) {
            try {
                this._props = PropertyMaps.TEMPLATE.clone();
                PropertyMaps pm = this._props.clone();
                this.runCommand("", this._commandLine.getText(), this._commandWorkDirLine.getText(), this._commandEnclosingFileLine.getText().trim(), pm);
            }
            catch (CloneNotSupportedException e) {
                throw new UnexpectedException(e);
            }
        }
        this._saveSettings();
        this.setVisible(false);
        if (this._cm != null) {
            this._cm.signal();
        }
    }

    private void _saveCommand() {
        if (this._editMode) {
            Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
            this._mainFrame.removeModalWindowAdapter(this);
            String name = JOptionPane.showInputDialog(this, "Name for saved process:", names.get(this._editIndex));
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            if (name == null) {
                this._saveSettings();
                this.setVisible(false);
                if (this._cm != null) {
                    this._cm.signal();
                }
                return;
            }
            ExecuteExternalDialog.editInMenu(this._editIndex, name, this._commandLine.getText(), this._commandWorkDirLine.getText(), this._commandEnclosingFileLine.getText());
        } else {
            int count = DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_COUNT);
            this._mainFrame.removeModalWindowAdapter(this);
            String name = JOptionPane.showInputDialog(this, "Name for saved process:", "External Java " + (count + 1));
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            if (name == null) {
                this._saveSettings();
                this.setVisible(false);
                if (this._cm != null) {
                    this._cm.signal();
                }
                return;
            }
            ExecuteExternalDialog.addToMenu(name, this._commandLine.getText(), this._commandWorkDirLine.getText(), this._commandEnclosingFileLine.getText());
        }
        this._saveSettings();
        this.setVisible(false);
        if (this._cm != null) {
            this._cm.signal();
        }
    }

    public static int addToMenu(String name, String cmdline, String workdir, String enclosingFile) {
        GeneralProcessCreator.LOG.log("addToMenu(): enclosingFile = " + enclosingFile);
        int count = DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_COUNT);
        ++count;
        Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
        Vector cmdlines = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES));
        Vector workdirs = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS));
        Vector enclosingFiles = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES));
        names.add(name);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_NAMES, names);
        cmdlines.add(cmdline);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES, cmdlines);
        workdirs.add(workdir);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS, workdirs);
        enclosingFiles.add(enclosingFile);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES, enclosingFiles);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_COUNT, count);
        return count;
    }

    public static void editInMenu(int editIndex, String name, String cmdline, String workdir, String enclosingFile) {
        GeneralProcessCreator.LOG.log("editInMenu(): enclosingFile = " + enclosingFile);
        Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
        Vector cmdlines = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES));
        Vector workdirs = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS));
        Vector enclosingFiles = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES));
        names.set(editIndex, name);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_NAMES, names);
        cmdlines.set(editIndex, cmdline);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES, cmdlines);
        workdirs.set(editIndex, workdir);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS, workdirs);
        enclosingFiles.set(editIndex, enclosingFile);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES, enclosingFiles);
    }

    public static void saveToFile(int index, File f) {
        Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
        Vector cmdlines = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES));
        Vector workdirs = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS));
        Vector enclosingFiles = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES));
        XMLConfig xc = new XMLConfig();
        xc.set("drjava/extprocess/name", (String)names.get(index));
        xc.set("drjava/extprocess/cmdline", (String)cmdlines.get(index));
        xc.set("drjava/extprocess/workdir", (String)workdirs.get(index));
        xc.set("drjava/extprocess/enlcosingfile", (String)enclosingFiles.get(index));
        xc.save(f);
    }

    private boolean _saveSettings() {
        this._lastState = new FrameState(this);
        return true;
    }

    private void _insertVariableCommand() {
        this._props.clearVariables();
        this._mainFrame.removeModalWindowAdapter(this);
        this._insertVarDialogMonitor.reset();
        this._insertVarDialog.setVisible(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecuteExternalDialog.this._insertVarDialogMonitor.attemptEnsureSignaled();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ExecuteExternalDialog.this.toFront();
                            }
                        });
                        ExecuteExternalDialog.this._mainFrame.installModalWindowAdapter(ExecuteExternalDialog.this, LambdaUtil.NO_OP, ExecuteExternalDialog.this.CANCEL);
                        Pair<String, DrJavaProperty> selected = ExecuteExternalDialog.this._insertVarDialog.getSelected();
                        if (selected != null) {
                            int max;
                            String text = ExecuteExternalDialog.this._lastCommandFocus.getText();
                            Caret caret = ExecuteExternalDialog.this._lastCommandFocus.getCaret();
                            int min = Math.min(caret.getDot(), caret.getMark());
                            if (min != (max = Math.max(caret.getDot(), caret.getMark()))) {
                                text = text.substring(0, min) + text.substring(max);
                            }
                            text = text.substring(0, min) + "${" + selected.first() + "}" + text.substring(min);
                            ExecuteExternalDialog.this._lastCommandFocus.setText(text);
                            caret.setDot(min + selected.first().length() + 2);
                            ExecuteExternalDialog.this._lastCommandFocus.setCaret(caret);
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            try {
                this._props = PropertyMaps.TEMPLATE.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UnexpectedException(e);
            }
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            this._documentListener.changedUpdate(null);
            this._workDirDocumentListener.changedUpdate(null);
            this.toFront();
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    protected void chooseDir(JTextPane pane) {
        File chosen;
        File wd = new File(StringOps.replaceVariables(pane.getText().trim(), this._props, PropertyMaps.GET_CURRENT));
        if (pane.getText().equals("") || !wd.exists() && !wd.isDirectory()) {
            wd = new File(System.getProperty("user.dir"));
        }
        this._dirChooser.setSelectedFile(wd);
        this._mainFrame.removeModalWindowAdapter(this);
        int returnValue = this._dirChooser.showDialog(wd);
        this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
        if (returnValue == 0 && (chosen = this._dirChooser.getSelectedDirectory()) != null) {
            pane.setText(chosen.toString());
        }
    }

    protected void chooseFile(JTextPane pane) {
        File wd = new File(StringOps.replaceVariables(pane.getText().trim(), this._props, PropertyMaps.GET_CURRENT));
        if (pane.getText().equals("") || !wd.exists() && !wd.isFile()) {
            wd = null;
        }
        this._fileChooser.setSelectedFile(wd);
        this._mainFrame.removeModalWindowAdapter(this);
        int returnValue = this._fileChooser.showOpenDialog(this);
        this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
        if (returnValue == 0) {
            File chosen = this._fileChooser.getSelectedFile();
            if (chosen != null) {
                pane.setText(chosen.toString());
            } else {
                pane.setText("");
            }
        }
    }

    public static class FrameState {
        private Point _loc;

        public FrameState(Point l) {
            this._loc = l;
        }

        public FrameState(String s) {
            StringTokenizer tok = new StringTokenizer(s);
            try {
                int x = Integer.valueOf(tok.nextToken());
                int y = Integer.valueOf(tok.nextToken());
                this._loc = new Point(x, y);
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nsee);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nfe);
            }
        }

        public FrameState(ExecuteExternalDialog comp) {
            this._loc = comp.getLocation();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._loc.x);
            sb.append(' ');
            sb.append(this._loc.y);
            return sb.toString();
        }

        public Point getLocation() {
            return this._loc;
        }
    }
}

