/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceReduction;
import edu.rice.cs.drjava.model.definitions.reducedmodel.Gap;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelBrace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelComment;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;
import edu.rice.cs.util.UnexpectedException;
import java.util.ArrayList;

public class ReducedModelControl
implements BraceReduction {
    final ReducedModelBrace _rmb = new ReducedModelBrace(this);
    final ReducedModelComment _rmc = new ReducedModelComment();
    volatile int _offset;

    public int braceCursorOffset() {
        return this._rmb.absOffset();
    }

    public int commentCursorOffset() {
        return this._rmc.absOffset();
    }

    public int walkerOffset() {
        return this._rmc.walkerOffset();
    }

    @Override
    public void insertChar(char ch) {
        this._rmb.insertChar(ch);
        this._rmc.insertChar(ch);
    }

    @Override
    public void move(int count) {
        try {
            this._rmb.move(count);
            this._rmc.move(count);
        }
        catch (IllegalArgumentException e) {
            this.resetLocation();
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void delete(int count) {
        this._rmb.delete(count);
        this._rmc.delete(count);
    }

    public boolean isShadowed() {
        return this._rmc.isShadowed();
    }

    public boolean isWeaklyShadowed() {
        return this._rmc.isWeaklyShadowed();
    }

    @Override
    public int balanceForward() {
        return this._rmb.balanceForward();
    }

    @Override
    public int balanceBackward() {
        return this._rmb.balanceBackward();
    }

    @Override
    public ReducedModelState moveWalkerGetState(int relDistance) {
        return this._rmc.moveWalkerGetState(relDistance);
    }

    @Override
    public void resetLocation() {
        this._rmc.resetWalkerLocationToCursor();
    }

    @Override
    public ReducedToken currentToken() {
        ReducedToken rmcToken = this._rmc.current();
        if (!rmcToken.isGap()) {
            return rmcToken;
        }
        ReducedToken rmbToken = this._rmb.current();
        if (!rmbToken.isGap()) {
            rmbToken.setState(this._rmc.getStateAtCurrent());
            return rmbToken;
        }
        int size = this.getSize(rmbToken, rmcToken);
        return new Gap(size, this._rmc.getStateAtCurrent());
    }

    @Override
    public ReducedModelState getStateAtCurrent() {
        return this._rmc.getStateAtCurrent();
    }

    String getType() {
        ReducedToken rmcToken = this._rmc.current();
        if (!rmcToken.isGap()) {
            return rmcToken.getType();
        }
        ReducedToken rmbToken = this._rmb.current();
        if (!rmbToken.isGap()) {
            return rmbToken.getType();
        }
        return "";
    }

    int getSize() {
        return this.getSize(this._rmb.current(), this._rmc.current());
    }

    int getSize(ReducedToken rmbToken, ReducedToken rmcToken) {
        int size;
        int rmb_offset = this._rmb.getBlockOffset();
        int rmc_offset = this._rmc.getBlockOffset();
        int rmb_size = rmbToken.getSize();
        int rmc_size = rmcToken.getSize();
        this._offset = rmb_offset < rmc_offset ? (size = rmb_offset) : (size = rmc_offset);
        size = rmb_size - rmb_offset < rmc_size - rmc_offset ? (size += rmb_size - rmb_offset) : (size += rmc_size - rmc_offset);
        return size;
    }

    void next() {
        if (this._rmc._cursor.atStart()) {
            this._rmc.next();
            this._rmb.next();
            return;
        }
        int size = this.getSize(this._rmb.current(), this._rmc.current());
        this._rmc.move(size - this._offset);
        this._rmb.move(size - this._offset);
    }

    void prev() {
        if (this._rmc._cursor.atEnd()) {
            this._rmc.prev();
            this._rmb.prev();
            if (this._rmc._cursor.atStart()) {
                return;
            }
            int size = this._rmc.current().getSize() < this._rmb.current().getSize() ? -this._rmc.current().getSize() : -this._rmb.current().getSize();
            this._rmc.next();
            this._rmb.next();
            this.move(size);
        } else if (this._rmb.getBlockOffset() < this._rmc.getBlockOffset()) {
            this._rmb.prev();
            int size = this._rmb.current().getSize() + this._rmb.getBlockOffset();
            this._rmb.next();
            if (size < this._rmc.getBlockOffset()) {
                this.move(-size);
            } else {
                this.move(-this._rmc.getBlockOffset());
            }
        } else if (this._rmb.getBlockOffset() == this._rmc.getBlockOffset()) {
            this._rmb.prev();
            this._rmc.prev();
            this._rmb.setBlockOffset(0);
            this._rmc.setBlockOffset(0);
        } else {
            this._rmc.prev();
            int size = this._rmc.current().getSize() + this._rmc.getBlockOffset();
            this._rmc.next();
            if (size < this._rmb.getBlockOffset()) {
                this.move(-size);
            } else {
                this.move(-this._rmb.getBlockOffset());
            }
        }
    }

    public ReducedToken prevItem() {
        int rmbOffset = this._rmb.getBlockOffset();
        int rmcOffset = this._rmc.getBlockOffset();
        this.prev();
        ReducedToken temp = this.currentToken();
        this.next();
        this._rmb.setBlockOffset(rmbOffset);
        this._rmc.setBlockOffset(rmcOffset);
        return temp;
    }

    public ReducedToken nextItem() {
        int rmbOffset = this._rmb.getBlockOffset();
        int rmcOffset = this._rmc.getBlockOffset();
        this.next();
        ReducedToken temp = this.currentToken();
        this.prev();
        this._rmb.setBlockOffset(rmbOffset);
        this._rmc.setBlockOffset(rmcOffset);
        return temp;
    }

    boolean atEnd() {
        return this._rmb._cursor.atEnd() || this._rmc._cursor.atEnd();
    }

    boolean atStart() {
        return this._rmb._cursor.atStart() || this._rmc._cursor.atStart();
    }

    int getBlockOffset() {
        if (this._rmb.getBlockOffset() < this._rmc.getBlockOffset()) {
            return this._rmb.getBlockOffset();
        }
        return this._rmc.getBlockOffset();
    }

    @Override
    public int absOffset() {
        int offset = this._rmc.absOffset();
        assert (offset == this._rmb.absOffset());
        return offset;
    }

    @Override
    public String simpleString() {
        return "\n********\n" + this._rmb.simpleString() + "\n________\n" + this._rmc.simpleString();
    }

    public int getDistToIdentNewline() {
        return -1;
    }

    public int getDistToEnclosingBraceStart() {
        return -1;
    }

    public BraceInfo _getLineEnclosingBrace() {
        return this._rmb._getLineEnclosingBrace();
    }

    public BraceInfo _getEnclosingBrace() {
        return this._rmb._getEnclosingBrace();
    }

    public int getDistToStart() {
        return this._rmc.getDistToStart();
    }

    @Override
    public int getDistToStart(int relLoc) {
        return this._rmc.getDistToStart(relLoc);
    }

    @Override
    public int getDistToNextNewline() {
        return this._rmc.getDistToNextNewline();
    }

    @Override
    public ArrayList<HighlightStatus> getHighlightStatus(int start, int length) {
        int requestEnd;
        int curState;
        int curLength;
        ArrayList<HighlightStatus> vec = new ArrayList<HighlightStatus>();
        TokenList.Iterator cursor = this._rmc._cursor.copy();
        int curLocation = start;
        if (cursor.atEnd() || cursor.atStart()) {
            curLength = length;
            curState = 0;
        } else {
            curLength = ((ReducedToken)cursor.current()).getSize() - this._rmc.getBlockOffset();
            curState = ((ReducedToken)cursor.current()).getHighlightState();
        }
        while (curLocation + curLength < start + length) {
            cursor.next();
            if (cursor.atEnd()) break;
            int nextState = ((ReducedToken)cursor.current()).getHighlightState();
            if (nextState == curState) {
                curLength += ((ReducedToken)cursor.current()).getSize();
                continue;
            }
            vec.add(new HighlightStatus(curLocation, curLength, curState));
            curLocation += curLength;
            curLength = ((ReducedToken)cursor.current()).getSize();
            curState = nextState;
        }
        if (curLocation + curLength > (requestEnd = start + length)) {
            curLength = requestEnd - curLocation;
        }
        vec.add(new HighlightStatus(curLocation, curLength, curState));
        cursor.dispose();
        return vec;
    }
}

