/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.Gap;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;

public abstract class AbstractReducedModel
implements ReducedModelStates {
    public static final char PTR_CHAR = '#';
    volatile TokenList _tokens = new TokenList();
    TokenList.Iterator _cursor = this._tokens.getIterator();

    public AbstractReducedModel() {
        this._cursor.setBlockOffset(0);
    }

    int getBlockOffset() {
        return this._cursor.getBlockOffset();
    }

    void setBlockOffset(int offset) {
        this._cursor.setBlockOffset(offset);
    }

    public int absOffset() {
        return this.absOffset(this._cursor);
    }

    public int absOffset(TokenList.Iterator cursor) {
        int off = cursor.getBlockOffset();
        TokenList.Iterator it = cursor.copy();
        if (!it.atStart()) {
            it.prev();
        }
        while (!it.atStart()) {
            off += ((ReducedToken)it.current()).getSize();
            it.prev();
        }
        it.dispose();
        return off;
    }

    public int getLength() {
        TokenList.Iterator it = this._tokens.getIterator();
        it.next();
        if (it.atEnd()) {
            return 0;
        }
        int len = 0;
        while (!it.atEnd()) {
            len += ((ReducedToken)it.current()).getSize();
            it.next();
        }
        it.dispose();
        return len;
    }

    public ReducedModelState getState() {
        return this._cursor.getStateAtCurrent();
    }

    public String simpleString() {
        StringBuilder val = new StringBuilder();
        TokenList.Iterator it = this._tokens.getIterator();
        it.next();
        if (this._cursor.atStart()) {
            val.append('#').append(this._cursor.getBlockOffset());
        }
        while (!it.atEnd()) {
            ReducedToken tmp = (ReducedToken)it.current();
            if (!this._cursor.atStart() && !this._cursor.atEnd() && tmp == this._cursor.current()) {
                val.append('#').append(this._cursor.getBlockOffset());
            }
            val.append('|').append(tmp).append('|').append("    ");
            it.next();
        }
        if (this._cursor.atEnd()) {
            val.append('#').append(this._cursor.getBlockOffset());
        }
        val.append("|end|");
        it.dispose();
        return val.toString();
    }

    public abstract void insertChar(char var1);

    public void _insertGap(int length) {
        if (this._cursor.atStart()) {
            if (this._gapToRight()) {
                this._cursor.next();
                this._augmentCurrentGap(length);
            } else {
                this._insertNewGap(length);
            }
        } else if (this._cursor.atEnd()) {
            if (this._gapToLeft()) {
                this._augmentGapToLeft(length);
            } else {
                this._insertNewGap(length);
            }
        } else if (this._cursor.getBlockOffset() > 0 && ((ReducedToken)this._cursor.current()).isMultipleCharBrace()) {
            this.insertGapBetweenMultiCharBrace(length);
        } else if (((ReducedToken)this._cursor.current()).isGap()) {
            ((ReducedToken)this._cursor.current()).grow(length);
            this._cursor.setBlockOffset(this._cursor.getBlockOffset() + length);
        } else if (!this._cursor.atFirstItem() && ((ReducedToken)this._cursor.prevItem()).isGap()) {
            ((ReducedToken)this._cursor.prevItem()).grow(length);
        } else {
            this._insertNewGap(length);
        }
    }

    protected abstract void insertGapBetweenMultiCharBrace(int var1);

    public TokenList.Iterator makeCopyCursor() {
        return this._cursor.copy();
    }

    protected boolean _gapToRight() {
        return !this._tokens.isEmpty() && !this._cursor.atEnd() && !this._cursor.atLastItem() && ((ReducedToken)this._cursor.nextItem()).isGap();
    }

    protected boolean _gapToLeft() {
        return !this._tokens.isEmpty() && !this._cursor.atStart() && !this._cursor.atFirstItem() && ((ReducedToken)this._cursor.prevItem()).isGap();
    }

    protected void _augmentGapToLeft(int length) {
        ((ReducedToken)this._cursor.prevItem()).grow(length);
    }

    protected void _augmentCurrentGap(int length) {
        ((ReducedToken)this._cursor.current()).grow(length);
        this._cursor.setBlockOffset(length);
    }

    protected void _insertNewGap(int length) {
        this._cursor.insert(new Gap(length, this._cursor.getStateAtCurrent()));
        this._cursor.next();
        this._cursor.setBlockOffset(0);
    }

    protected abstract ReducedModelState moveWalkerGetState(int var1);

    protected abstract void resetWalkerLocationToCursor();

    protected ReducedToken current() {
        return (ReducedToken)this._cursor.current();
    }

    protected void next() {
        this._cursor.next();
    }

    protected void prev() {
        this._cursor.prev();
    }
}

