/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug;

import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugModelCallback;
import edu.rice.cs.drjava.model.debug.DebugStackData;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import java.util.ArrayList;

public interface Debugger {
    public void addListener(DebugListener var1);

    public void removeListener(DebugListener var1);

    public boolean isAvailable();

    public DebugModelCallback callback();

    public void startUp() throws DebugException;

    public void shutdown();

    public boolean isReady();

    public void setCurrentThread(DebugThreadData var1) throws DebugException;

    public void setAutomaticTraceEnabled(boolean var1);

    public boolean isAutomaticTraceEnabled();

    public void resume() throws DebugException;

    public void resume(DebugThreadData var1) throws DebugException;

    public void step(StepType var1) throws DebugException;

    public void addWatch(String var1) throws DebugException;

    public void removeWatch(String var1) throws DebugException;

    public void removeWatch(int var1) throws DebugException;

    public void removeAllWatches() throws DebugException;

    public boolean toggleBreakpoint(OpenDefinitionsDocument var1, int var2, boolean var3) throws DebugException;

    public void setBreakpoint(Breakpoint var1) throws DebugException;

    public void removeBreakpoint(Breakpoint var1) throws DebugException;

    public ArrayList<DebugWatchData> getWatches() throws DebugException;

    public ArrayList<DebugThreadData> getCurrentThreadData() throws DebugException;

    public ArrayList<DebugStackData> getCurrentStackFrameData() throws DebugException;

    public boolean hasSuspendedThreads() throws DebugException;

    public boolean hasRunningThread() throws DebugException;

    public boolean isCurrentThreadSuspended() throws DebugException;

    public void scrollToSource(DebugStackData var1) throws DebugException;

    public void scrollToSource(Breakpoint var1);

    public Breakpoint getBreakpoint(int var1, String var2) throws DebugException;

    public static enum StepType {
        STEP_INTO,
        STEP_OVER,
        STEP_OUT;

    }
}

