/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.record;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.ReferenceInstruction;
import edu.rice.cs.cunit.instrumentors.util.AInsertAtOpcodeStrategy;
import edu.rice.cs.cunit.util.IPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactRecordBufferCodeStrategy
extends AInsertAtOpcodeStrategy {
    protected long _code;

    public CompactRecordBufferCodeStrategy(IPredicate<ClassFile> classPredicate, IPredicate.Binary<ClassFile, MethodInfo> methodPredicate, IPredicate.Ternary<ClassFile, MethodInfo, InstructionList> opcodePredicate, long code) {
        super(classPredicate, methodPredicate, opcodePredicate, OPCODE_NEVER);
        this._code = code;
    }

    @Override
    public void insertInstructionsBefore(ClassFile cf, MethodInfo mi, InstructionList il) {
        ReferenceInstruction addCallInstr = new ReferenceInstruction(-72, 0);
        ReferenceInstruction loadThreadExitCodeIndexInstr = new ReferenceInstruction(20, 0);
        ReferenceInstruction getThreadIDInstr = new ReferenceInstruction(-76, 0);
        GenericInstruction loadThisInstr = new GenericInstruction(42);
        int addCallIndex = 0;
        int threadExitCodeIndex = 0;
        int threadIDIndex = 0;
        addCallIndex = cf.addMethodToConstantPool("edu/rice/cs/cunit/SyncPointBuffer", "compactAdd", "(JJ)V");
        addCallInstr.setReference(addCallIndex);
        threadExitCodeIndex = cf.addLongToConstantPool(this._code);
        loadThreadExitCodeIndexInstr.setReference(threadExitCodeIndex);
        threadIDIndex = cf.addField("java/lang/Thread", "$$$threadID$$$", "J", false, (short)0);
        getThreadIDInstr.setReference(threadIDIndex);
        il.insertBeforeInstr(addCallInstr, mi.getCodeAttributeInfo());
        il.insertBeforeInstr(getThreadIDInstr, mi.getCodeAttributeInfo());
        il.insertBeforeInstr(loadThisInstr, mi.getCodeAttributeInfo());
        il.insertBeforeInstr(loadThreadExitCodeIndexInstr, mi.getCodeAttributeInfo());
        boolean result = il.advanceIndex(4);
        assert (result);
    }

    @Override
    public void insertInstructionsAfter(ClassFile cf, MethodInfo mi, InstructionList il) {
    }

    @Override
    public boolean insertEndOfMethod(ClassFile cf, MethodInfo mi, InstructionList il, boolean insertBefore, boolean insertAfter) {
        return false;
    }

    @Override
    public void modifyStackAndLocals(ClassFile cf, MethodInfo mi, InstructionList il, boolean insertBefore, boolean insertAfter, boolean insertEndOfMethod) {
        CodeAttributeInfo.CodeProperties cp = mi.getCodeAttributeInfo().getProperties();
        cp.maxStack += 4;
        mi.getCodeAttributeInfo().setProperties(cp.maxStack, cp.maxLocals);
    }
}

