/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.IPoolInfoVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatPoolInfo
extends APoolInfo {
    private float _floatValue;

    public FloatPoolInfo(float f, ConstantPool cp) {
        super(4, cp);
        this._floatValue = f;
    }

    public FloatPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(4, cp);
        this._floatValue = dis.readFloat();
    }

    public float getFloatValue() {
        return this._floatValue;
    }

    public void setFloatValue(float floatValue) {
        this._floatValue = floatValue;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this._type);
        dos.writeFloat(this._floatValue);
    }

    @Override
    public void resolve() {
    }

    @Override
    public void reindex() {
    }

    @Override
    public String toStringVerbose() {
        StringBuilder s = new StringBuilder();
        s.append("CONSTANT_Float: Value = ");
        s.append(this.toString());
        return s.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this._floatValue);
    }

    @Override
    public int hashCode() {
        return new Float(this._floatValue).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FloatPoolInfo && ((FloatPoolInfo)obj)._floatValue == this._floatValue;
    }

    @Override
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.floatCase(this, data);
    }
}

