import java.awt.*;
import javax.swing.*;

/** Demonstrate placement of components in a JFrame. Use BorderLayout.
    It places five components in the five possible areas:
       (1) a JButton in the east, 
       (2) a JLabel in the west,
       (3) a JLabel in the south,
       (4) a JTextField in the north, and
       (5) a JTextArea in the center.*/
public class ComponentExample extends JFrame {
    
    /** Show the GUI  */
    public static void main(String[] pars) {
        ComponentExample gui= new ComponentExample();
    }
    
    /** Constructor: a JFrame with  5 components */
    public ComponentExample() {
        super("ComponentExample");  
        add(new JButton("click me"), BorderLayout.EAST);
        add(new JTextField("type here", 22), BorderLayout.NORTH);
        add(new JCheckBox("I voted today"), BorderLayout.SOUTH);
        add(new JLabel("label 2"), BorderLayout.WEST);
        add(new JTextArea("type\nhere", 4, 10), BorderLayout.CENTER);
        pack();
        setVisible(true);
    }
}


//textArea = new JTextArea(5, 30);

//JScrollPane scrollPane = new JScrollPane(textArea);
