import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/** An instance has two buttons, exactly one of which is always
 enabled. Click the enabled one and the other one becomes
 enabled. */
public class ButtonDemo1old extends JFrame 
    implements ActionListener {
    
    /** Class invariant: exactly one of eastButton
     and westButton is enabled */
    private JButton westButton= new JButton("west");
    private JButton eastButton= new JButton("east");
    
    /** Show the GUI  */
    public static void main(String[] pars) {
        ButtonDemo1old gui= new ButtonDemo1old();
    }
    
    /** Constructor: a frame with two buttons */
    public ButtonDemo1old() {
        super("ButtonDemo1old");
        
        add(westButton,BorderLayout.WEST);
        add(eastButton,BorderLayout.EAST);
        
        westButton.setEnabled(false);
        eastButton.setEnabled(true);
        
        westButton.addActionListener(this);
        eastButton.addActionListener(this);
        
        pack();
        setVisible(true);
    }
    
    /** Process a click of a button */
    public void actionPerformed(ActionEvent e) {
        boolean b= eastButton.isEnabled();
        eastButton.setEnabled(!b);
        westButton.setEnabled(b);
    }
    
    /** Process a click of a button */
    public void buttonClick(ActionEvent e) {
        boolean b= eastButton.isEnabled();
        eastButton.setEnabled(!b);
        westButton.setEnabled(b);
    }
    
}