import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/** An instance has two buttons, exactly one of which is always
 enabled. Click the enabled one and the other one becomes
 enabled. */
public class ButtonDemo1 extends JFrame {

    /** Class invariant: exactly one of eastButton
     and westButton is enabled */
    private JButton westButton= new JButton("west");
    private JButton eastButton= new JButton("east");

    /** Show the GUI  */
    public static void main(String[] pars) {
        ButtonDemo1 gui= new ButtonDemo1();
    }

    /** Constructor: a frame with two buttons */
    public ButtonDemo1() {
        super("ButtonDemo1");

        add(westButton,BorderLayout.WEST);
        add(eastButton,BorderLayout.EAST);

        westButton.setEnabled(false);
        eastButton.setEnabled(true);

        ActionListener al= e -> {
            boolean b= eastButton.isEnabled();
            eastButton.setEnabled(!b);
            westButton.setEnabled(b);
        };

        //ActionListener al1=  (ActionEvent e) -> buttonClick(e);
        westButton.addActionListener(al);
        eastButton.addActionListener(al);

        pack();
        setVisible(true);
    }

    /** Process a click of a button */
    public void buttonClick(ActionEvent e) {
        boolean b= eastButton.isEnabled();
        eastButton.setEnabled(!b);
        westButton.setEnabled(b);
    }

}