public class SierpinskiTurtle extends Turtle {
  //
  // useful methods inherited from Turtle:
  //
  ///** Draw an equilateral triangle with top corner at 
  //    * current pen position with side length s. */
  //  public void drawTriangle(double s)
  
  ///** Move the turtle to (x,y), without drawing,
  //      and face it at angle ang. */
  //  public void moveTo(double x, double y, double ang)
  
  
  /** draw a sierpinski triangle of depth d and side
    * length sl with the top point
    * at the turtle's current location */
  public void drawSierpinski(double sl, int d) {
    if (d == 0) { 
      drawTriangle(sl);
      return;
    }
    double startX= getX();
    double startY= getY();

    // top subtriangle
    drawSierpinski(sl/2, d-1);
    // bottom left subtriangle
    moveTo(startX - sl/4, startY + sl * Math.sqrt(3)/4, getAngle());
    drawSierpinski(sl/2, d-1);
    // bottom right subtriangle
    moveTo(startX + sl/4, startY + sl * Math.sqrt(3)/4, getAngle());
    drawSierpinski(sl/2, d-1);
    // move back to original location
    moveTo(startX, startY, getAngle());
  }
  
  
  public static void main(String[] args) {
    SierpinskiTurtle t= new SierpinskiTurtle();
    t.addAngle(90);
    t.liftPen();
    t.move(200);
    t.putPenDown();
    
    t.drawSierpinski(400, 1);
  }
}