import static org.junit.Assert.*;

import java.util.ArrayList;

import org.junit.Test;

public class TimeSetTest {

    @Test
    public void testEmptySetAndAdd() {
        TimeSet<Integer> ts= new TimeSet<>(20);
        assertEquals(0, ts.size());
        
        ts.add(5);
        assertEquals(true, ts.contains(5));
        assertEquals(1, ts.size());
        assertEquals(false, ts.contains(6));
        long time= ts.timeOf(5);
        assertEquals(-1, ts.timeOf(7));
        
        ts.add(5);
        assertEquals(true, ts.contains(5));
        assertEquals(1, ts.size());
        assertEquals(false, ts.contains(6));
        assertEquals(time, ts.timeOf(5));
    }
    
    @Test
    public void testEmptySetAndAddString() {
        TimeSet<String> ts= new TimeSet<String>(20);
        assertEquals(0, ts.size());
        
        ts.add("five");
        assertEquals(true, ts.contains("five"));
        assertEquals(1, ts.size());
        assertEquals(false, ts.contains("one"));
        long time= ts.timeOf("five");
        assertEquals(-1, ts.timeOf("six"));
        
        ts.add("five");
        assertEquals(true, ts.contains("five"));
        assertEquals(1, ts.size());
        assertEquals(false, ts.contains("six"));
        assertEquals(time, ts.timeOf("five"));
    }
    
    @Test
    public void testAddingMany() {
        TimeSet<Integer> ts= new TimeSet<Integer>(40);
        for (int k= 0; k < 20; k= k+1) {
            ts.add(k);
            try {Thread.sleep(3);}
            catch (Exception e) {}
        }
        assertEquals(20, ts.size());
        
        for (int k= 0; k < 20; k= k+1) {
            ts.add(k);
        }
        ArrayList<Long> times= new ArrayList<Long>();
        for (int k= 0; k < 20; k= k+1) {
            times.add(ts.timeOf(k));
            System.out.println("time of " + k + ": " +ts.timeOf(k));
        }
        for (int k= 1; k < 20; k= k+1) {
            assertEquals(true, times.get(k-1) < times.get(k));
        }
    }

}
