import java.lang.reflect.Array;


/** An instance maintains a set of elements of type E,
 * recording also the time each element was added to the set. */
public class TimeSet<E> {
    private Entry[] s; // The set consists of s[0..n-1]
    private int n;     // number of elements in the set

    /** Constructor: an empty set with a maximum size of max
     * Precondition: 0 < max */
    public TimeSet(int max) {
        n=  0;
        // The following statement creates an Entry[] of size max and
        // stores a pointer to it in s. The strange way of creating the
        // array is needed because Entry uses generic type
        // parameter E, and arrays and generics don't mix well together.
        // The normal way of creating the array (new Entry[max]) won't work.
        s= (Entry[]) Array.newInstance(Entry.class, max);
    }

    /** Return the size of the set. */
    public int size() { return n; }

    /** Return true iff the set contains e. */
    public boolean contains(E e) {
        return indexOf(new Entry(e)) >= 0;
    }

    /** Return the time in milliseconds at which e was added to the set.
     * (Return -1 if it is not in the set.) */
    public long timeOf(E e) {
        int k= indexOf(new Entry(e));
        return k == -1 ? -1 : s[k].t;
    }

    /** Add integer e to the set if it is not already in.
     * Throw a RuntimeException if there is no room for e */
    public void add(E e) {
        if (indexOf(new Entry(e)) >= 0) return;
        if (n == s.length) throw new RuntimeException("set if full");
        s[n]= new Entry(e);
        n= n + 1;
    }

    /** return index of e in s[0..n-1] ---return -1 if not in */
    private int indexOf(Entry e) {
        for (int k= 0; k < n; k= k+1)
            if (e.equals(s[k])) return k;
        return -1;
    }

    /** An instance maintains an E element and the time the instance was created. */
    private class Entry {
        private E val;    // the element of type E
        private long t;   // the time at which entry was created.

        /** Constructor: an entry for k */
        private Entry(E k) {
            t= System.currentTimeMillis();
            val= k;   
        }

        /** Return true iff ob is an Entry with the same value of
         *  type E as this one. Field time is not used. */
        public @Override boolean equals(Object ob) {
            if (ob == null  || getClass() != ob.getClass()) return false;
            return val == ((TimeSet.Entry)ob).val;
        }
    }
}
