public class Cat extends Animal {
  int purrs;  // The number of minutes this cat purrs per day.

  /**
   * A cat with name n, age a, and purrs p.
   */
  public Cat(String n, int a, int p) {
    super(n, a);
    purrs= p;
  }

  /**
   * Get the number of minutes this cat spends purring every day.
   */
  public int getPurrs() {
    return purrs;
  }

  /**
   * Get a string representation of this cat.
   */
  public @Override String toString() {
    return super.toString() + ", who purrs " + purrs + " minutes";
  }

  /**
   * Check whether c is a Cat object with the same name, age, and
   * weight as this object.
   */
  public @Override boolean equals(Object c) {
    if (c == null) return false;

    if (c.getClass() != getClass()) return false;

    if (!super.equals(c)) return false;

    return purrs == ((Cat) c).getPurrs();
  }

  /**
   * Get the noise a cat makes.
   */
  public String getNoise() {
    return "meow";
  }
}
