public class Animal {
  private String name;  // The animal's name.
  private int age;    // The animal's age, in years.

  /**
   * Constructor: an animal with name n and age a.
   */
  public Animal(String n, int a) {
    name= n;
    age= a;
  }

  /**
   * Check whether this animal is older than h.
   */
  public boolean isOlder(Animal h) {
    return isOlder(h.age);
  }

  /**
   * Check whether this animal is older than age.
   */
  public boolean isOlder(int age) {
    return this.age > age;
  }

  /**
   * Check whether h is an Animal and has the same name and
   * age as this animal.
   */
  public @Override boolean equals(Object h) {
    if (h == null) return false;

    if (h.getClass() != getClass()) return false;

    Animal a= (Animal) h;

    return name.equals(a.name) && age == a.age;
  }
}
