package l3;

import l4.Apartment;

public class House {
	private int bdrs;// number bedrooms, >=0
	protected int baths;// number bathrooms, 1..5
	
	private boolean open;
	
	public House(int b1, int b2) {
		assert(b1 >= 0);
		assert(b2 > 0 && b2 <= 5);
		bdrs = b1;
		baths = b2;
		
	}
	
	public House() {
		bdrs = 0;
		baths = 1;
	}
	
	/** return the number of bedrooms */
	public int getBeds() {
		return bdrs;
	}
	
	/** return the number of bathrooms */ 
	public int getBaths() {
		return baths;
	}
	
	/** set number of bedrooms equal to b. <br>
	 * Precondition: b must be non-negative
	 * */ 
	public void setBeds(int b) {
		assert(b >= 0);
		bdrs = b;
	}
	
	/** open the door */
	public void openDoor() {
		if(open == false) {
			open = true;
		}
	}
	
	public static void main(String[] args) {	
		House h = new House();
		System.out.println(h.toString());

		Apartment a = new Apartment(2, null);
		a.getBeds();
		System.out.println(a.getFloor());
		
		System.out.println(a.toString());
		

	}

}
