/** An instance maintains a time of day. */
public class Time {

    private int hr; // hour of the day, in 0..23
    private int min; // minute of the hours, in 0..59

    /** Constructor: an instance with hour h and minute m.
     * Precondition: h in 0..23 and m in 0..59. */
    public Time(int h, int m) {
        hr= h;
        min= m;
    }
    
    /** Constructor: an instance with minute of the day m.
     * Precondition: m in 0..24*60-1. */
    public Time(int m) {
        // Note in the spec that we leave the max minute as 24*60-1.
        // That's the clearest way to give the last minute. If we actually
        // calculated it and placed the value there, the reader would not know
        // what it was.
        // You complete this method.
        
    }
    
    /** return the hour of the day. */
    public int getHour() {
        return hr;
    }
    
    /** return the minute of the day. */
    public int getMinute() {
        return min;
    }

    /** Return a representation of this object, with both the hour
     * and the minute using 2 digits, e.g. 09:15. */
    public String toString() {
        // We used the Manana principle in developing this method! Look that
        // word up in JavaHyperText!
        return prepend0(hr) + ":" + prepend0(min);
    }
    
    /** Set the hour to h.
     * Precondition: h in 0..23 */
    public void setHour(int h) {
        hr= h;
    }
    
    /** Return k, with leading 0 if necessary to make at least 2 digits. */
    private String prepend0(int k) {
        if (0 <= k  &&  k < 10) return "0" + k;
        return "" + k;
    }
}
