/* This exercise is to complete an iterator over the elements of an ArrayList.
 * The iterator enumerates the values in an interesting order.
 * Suppose the list is b[0..n]. Then the elements are enumerated in
 * what we call outside-in order:
 * 
 *   b[0]
 *   b[n]
 *   b[1]
 *   b[n-1]
 *   b[2]
 *   b[n-2]
 *   ...
 *
 * We provide a lot of help by giving a good class invariant.
 * Just follow it when implementing the methods.
 * All parts you have to implement are preceded by a //TODO comment.
 * You have to put in what the class implements, write the constructor,
 * write method hasNext(), and write method next().
 * 
 * We also provide a complete testng class, OutsideInTest. Please study it!
 * Note how it tests an empty list, a list with an even number of elements,
 * and a list with an odd number of elements.
 * 
 * Testing makes use of a helper method, enumerate, to actually
 * enumerate the values using a normal loop to iterate over the elements.
 * Look carefully at its header. Note that it has E as a type parameter <E>,
 * since both the return type and the parameter need <E>.
 */


import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/** An instance of OutsideIn provides enumeration of a list of elements
 * in outside-in fashion, as follows. Suppose the list is: b[0..n].
 * The elements are enumerated in this order:
 * b[0], b[n], b[1], b[n-1], b[2], b[n-2], b[3], b[n-3], ... */
// TODO What should the class implement?
public class OutsideIn<E>              {
    private ArrayList<E> list; // contains the elements of this list
    
    int h;    // The elements remaining to 
    int k;    // iterate are list[h..k] with with list[h] being the next
    boolean nextIsH= true; // to enumerate if nextIsH and list[k] otherwise
    
    /** Constructor: an instance for list input. */
    public OutsideIn(ArrayList<E> input) {
        //TODO fill in the body
        
        
    }

    /** Return true iff there are more elements to enumerate. */
    public @Override boolean hasNext() {
        //TODO implement
        return false;
    }

    /** Return the next element to enumerate.
     * Throw a NoSuchElementException if there are none.  */
    public @Override E next() {
        if (!hasNext()) throw new NoSuchElementException("done");
        //TODO Implement
        return null;
    }

}
