import java.util.Arrays;

/** An instance contains the position of a shape in the plane. */
public abstract class Shape implements Comparable<Shape> {
	protected double x; // (x, y) is the top-left corner of 
	protected double y; // of the bounding box of the shape

	/** Constructor: a Shape at (x, y). */
	public Shape(double x, double y) {
		this.x= x;
		this.y= y;
	}

	/** Return true iff ob is in the same (x, y) position
	 * as this one. */
	 public @Override boolean equals(Object ob) {
		if (!(ob instanceof Shape))
			return false;

		Shape os= (Shape) ob;
		return x == os.x && y == os.y;
	}

	/** = the area of this shape. */
	public abstract double area();
	
	/** Return the sum of the areas of elements in s. */
	public static double sumAreas(Shape[] s) {
		double result= 0.0;
		for (int i= 0; i < s.length; i= i + 1)
			result= result + s[i].area();
		return result;
	}
	
	public static void main(String[] args) {
		// note shapes can contain both Circles and Rectangles
		Shape[] shapes = new Shape[] {
			new Circle(0.0, 0.0, 1.0),
			new Circle(3.2, 4.4, 1.0),
            new Rectangle(8, 9, 10, 5),
			new Rectangle(1.2, 1.2, 3.0, 4.0)
		};
        System.out.println(toString(shapes));
		System.out.println(sumAreas(shapes));
		Arrays.sort(shapes);
        System.out.println(toString(shapes));
	}
    
    /** Return a repr of the pos (x, y) */
    public @Override String toString() {
        return "(" + x + ", " + y + ")";
    }
    
    /** Return a negative, 0, or a positive, depending
     * on whether the area of this Shape is <, =, or >
     * the area of s.  */
    public int compareTo(Shape s) {
        double diff= area() - s.area();
        return diff == 0 ? 0 : (diff < 0 ? -1 : +1);
    }
    
    /** Return a list of the elements of s, 
     * each on a separate line.  */
    public static String toString(Shape[] s) {
        String res= "";
        // inv: res contains all values in s[0..k-1].
        for (int k= 0; k != s.length; k= k+1) {
            res= res + s[k] + " with area " + s[k].area() + "\n";
        }
        return res;
    }

}
