/** An instance is a rectangle in the plane. */
public class Rectangle extends Shape {
	protected double width; // width and height of this rectangle
	protected double height;
	
	/** Constructor a rectangle of width w and height h at (x, y) */
	public Rectangle(double x, double y, double w, double h) {
		super(x,y);
		width= w;
		height= h;
	}

	/** Return true iff ob is a Shape and has the same position in
	 *  the plane and size as as this one. */
	public @Override boolean equals(Object ob) {
		if (!(ob instanceof Rectangle))
			return super.equals(ob);

		Rectangle o= (Rectangle) ob;
		return super.equals(o) && width == o.width && height == o.height;
	}

	/** = the area of this Rectangle */
	public @Override double area() {
		return width * height;
	}
	
	/** Return a repr of this Rectangle. */
    public @Override String toString() {
        return "Rect with width and height +"
                + "(" + width + ", " + height + ")" + 
                " at " + super.toString();
    }
}
