
/** An instance is a circle of radius r; the top-left corner
 * of its bounding box is (x, y). */
public class Circle extends Shape {
    protected double radius; // radius of circle

    /** Constructor: a circle with radius r and bounding box with
     * top-left corner (x, y)	 */
    public Circle(double x, double y, double r) {
        super(x, y);
        radius= r;
    }

    /** Return true iff ob is a Circle and has the same radius
     *  and position in the plane as this one. */
    public @Override boolean equals(Object ob) {
        if (!(ob instanceof Circle))
            return false;

        return super.equals(ob) &&
                radius == ((Circle) ob).radius;
    }

    /** Return the area of this circle. */
    public @Override double area() {
        return Math.PI * radius * radius;
    }

    /** Return a repr of this Circle. */
    public @Override String toString() {
        return "Circle with radius " + radius + 
                " at " + super.toString();
    }

}
