
import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.Iterator;

import org.junit.Test;

public class OutsideInTest {

    @Test
    public void testOutsideInTest() {
        //Test an empty list
        ArrayList<String> al= new ArrayList();
        OutsideIn<String> myOI= new OutsideIn<String>(al);
        ArrayList<String> computed= enumerate(myOI);
        assertEquals("[]", computed.toString());
        
        //Test a list with an even number of elements
        al.add("s1"); al.add("s2"); al.add("s3"); al.add("s4");
        myOI= new OutsideIn<String>(al);
        computed= enumerate(myOI);
        assertEquals("[s1, s4, s2, s3]", computed.toString());
        
        //Test a list with an odd number of elements
        al.add("s5"); al.add("s6"); al.add("s7");
        myOI= new OutsideIn<String>(al);
        computed= enumerate(myOI);
        assertEquals("[s1, s7, s2, s6, s3, s5, s4]", computed.toString());
    }
    
    /** Return the enumeration of oin. */
    private static <E> ArrayList<E> enumerate(OutsideIn<E> oin) {
        ArrayList<E> computed= new ArrayList();
        while (oin.hasNext()) {
            computed.add(oin.next());
        }
        return computed;
    }
}
