/** An instance is a (x, y, z) point in 3-dimensional space. */
public class Point3 extends Point {
    private int z; // the z-coordinate

    /** Constructor: a point (x, y, z). */
    public Point3(int x, int y, int z) {
        super(x, y);
        this.z= z;
    }

    /** Return true iff this and ob are objects of the
      * same class and have the same x, y, and z values */
    @Override public boolean equals(Object ob) {
        if (ob == null  ||  getClass() != ob.getClass()) return false;
        if (!super.equals(ob)) return false;
        Point3 op= (Point3) ob;
        return z == op.z;
    }

    /** Return a representation of this point. */
    public String toString() {
        String res= super.toString();
        int len= res.length();
        res=  res.substring(0, len-1) + ", " + z + ")";
        return res;
    }

}