/** An instance is a point (x, y) in the plane.
  * Class Point and its subclass Point3 illustrate  
  * how to override function equals. */
public class Point {
    private int x; // x-coordinate
    private int y; // y-coordinate
    
    /** Constructor: a point (x, y). */
    public Point(int x, int y) {
        this.x= x;
        this.y= y;
    }
    
    /** Return true iff this and ob are objects of the same   
      * class and they have the same x and y values */
    @Override public boolean equals(Object ob) {         
        if (ob == null  ||  getClass() != ob.getClass()) return false;
        Point op= (Point) ob;
        return x == op.x  &&  y == op.y;
    } 
    
    /* Return a representation of this Point. */
    public String toString() {
        return "(" + x + ", " + y + ")";
    }
    
}