/** An instance is a (x, y, z) point in 3-dimensional space.
  * EPoint and its subclass EPoint3 illustrate that using instanceof
  * in equals can lead to an error --equals s not symmetric.*/
public class EPoint3 extends EPoint {
    private int z; // the z-coordinate
    
    /** Constructor: a point (x, y, z). */
    public EPoint3(int x, int y, int z) {
        super(x, y);
        this.z= z;
    }
    
    /** Return true iff ob is an EPoint3 and has the    
      * same x, y, and z values as this. */
    @Override public boolean equals(Object ob) {
        if (!(ob instanceof EPoint3)) return false;
        if (!super.equals(ob)) return false;
        EPoint3 op= (EPoint3) ob;
        return z == op.z;
    }  
    
    /** Return a representation of this point. */
    public String toString() {
        String res= super.toString();
        int len= res.length();
        res=  res.substring(0, len-1) + ", " + z + ")";
        return res;
    }
    
}