/** An instance is a point (x, y) in the plane.
  * EPoint and its subclass EPoint3 illustrate that using instanceof
  * in equals can lead to an error --equals is not symmetric.
  * To see this, do:
  *     EPoint p1= new EPoint(4, 5);
  *     EPoint3 p2= new EPoint3(4, 5, 6);
  * Then check that p1.equals(p2))  is true and
  *                 p2.equals(p1))  is false. */
public class EPoint {
    private int x; // x-coordinate
    private int y; // y-coordinate
    
    /** Constructor: a point (x, y). */
    public EPoint(int x, int y) {
        this.x= x;
        this.y= y;
    }
    
    /** Return true iff ob is an EPoint and has the    
      * same x and y values as this object. */
    @Override public boolean equals(Object ob) {         
        if (!(ob instanceof EPoint)) return false;
        EPoint op= (EPoint) ob;
        return x == op.x  &&  y == op.y;
    } 
    
    /* Return a representation of this Point. */
    public String toString() {
        return "(" + x + ", " + y + ")";
    }
    
}