/** This class provides a GUI: a window with several int fields, double 
   fields, and text fields. The current version has 3 int fields, 0 double
   fields, and 0 String fields. Change the constructor call in method main to
   change the number of fields. 
   
   Whenever the button in the window is pressed, method buttonPressed is called.
   Place code in this method to read the fields, calculate, and store values
   back in the fields. The current version adds the values in the first two int
   fields (numbers 0 and 1) and stores the sum in int fields number 2. */
   
   import java.awt.*;

public class MyJLiveWindow extends JLiveWindow {
  
   // Store in int field 2 the sum of int fields 0 and 1.
   // Place code in the body of this method to process fields and store 
   // results in fields. Use
        
   //   getIntField(i)     for the number in int    field i; 0 is first field
   //   getDoubleField(i)  for the number in double field i; 0 is first field
   //   getStringField(i)  for the number in String field i; 0 is first field
   //   setIntField(i,v);      to store int value v in field i
   //   setDoubleField(i,v);   to store double value v in field i
   //   setStringField(i,v);   to store String value v in field i

   /** First int field contains a number of seconds. Display it in the
       first string field in the form hours:minutes:seconds */
   public Object buttonPressed() {
      setStringField(0, convert(getIntField(0)));
      return null;
   }
   
   /** = the number of seconds n, given in the form
         hours:minutes:seconds. Precondition: n >= 0 */
   public static String convert(int n) {
      int hours= n / 3600;
      int remainder= n % 3600;
      return hours + ":" + (remainder / 60) + ":" + (remainder % 60);
   }
 
   /** Create an instance of me and show it */
   public static void main(String args[]) {
      // The first argument to MyJLiveWindow is the number of int fields,
      // the second argument is the number of double fields, and
      // the third argument is the number of text (or String) fields.
      MyJLiveWindow testJLiveWindow= new MyJLiveWindow(3, 0, 0);
      testJLiveWindow.showWindow();
   }
  
   /** Create my window with
         max( min(i,MAX_FIELDS), 0) integer fields,
         max( min(d,MAX_FIELDS), 0) double fields, and
         max( min(s,MAX_FIELDS), 0) String fields
         and a "ready" button */
   public MyJLiveWindow(int i, int d, int s) {
      super(i, d, s);
   }
}

