/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import edu.rice.cs.plt.tuple.Option;
import java.util.ArrayList;
import java.util.List;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionContainer;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.StatementExpression;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerAllocation
extends PrimaryExpression
implements StatementExpression,
ExpressionContainer {
    private Expression expression;
    private Option<List<TypeName>> typeArgs;
    private String className;
    private Option<List<TypeName>> classTypeArgs;
    private List<Expression> arguments;

    public InnerAllocation(Expression exp, Option<List<TypeName>> targs, String cn, Option<List<TypeName>> ctargs, List<? extends Expression> args) {
        this(exp, targs, cn, ctargs, args, SourceInfo.NONE);
    }

    public InnerAllocation(Expression exp, String cn, Option<List<TypeName>> ctargs, List<? extends Expression> args) {
        this(exp, Option.none(), cn, ctargs, args, SourceInfo.NONE);
    }

    public InnerAllocation(Expression exp, String cn, Option<List<TypeName>> ctargs, List<? extends Expression> args, SourceInfo si) {
        this(exp, Option.none(), cn, ctargs, args, si);
    }

    public InnerAllocation(Expression exp, Option<List<TypeName>> targs, String cn, Option<List<TypeName>> ctargs, List<? extends Expression> args, SourceInfo si) {
        super(si);
        if (targs == null || cn == null || ctargs == null || exp == null) {
            throw new IllegalArgumentException();
        }
        this.expression = exp;
        this.typeArgs = targs;
        this.className = cn;
        this.classTypeArgs = ctargs;
        this.arguments = args == null ? new ArrayList<Expression>(0) : new ArrayList<Expression>(args);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.expression = e;
    }

    public Option<List<TypeName>> getTypeArgs() {
        return this.typeArgs;
    }

    public void setTypeArgs(List<TypeName> targs) {
        this.typeArgs = Option.wrap(targs);
    }

    public void setTypeArgs(Option<List<TypeName>> targs) {
        if (targs == null) {
            throw new IllegalArgumentException();
        }
        this.typeArgs = targs;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String cn) {
        if (cn == null) {
            throw new IllegalArgumentException("cn == null");
        }
        this.className = cn;
    }

    public Option<List<TypeName>> getClassTypeArgs() {
        return this.classTypeArgs;
    }

    public void setClassTypeArgs(List<TypeName> ctargs) {
        this.classTypeArgs = Option.wrap(ctargs);
    }

    public void setClassTypeArgs(Option<List<TypeName>> ctargs) {
        if (ctargs == null) {
            throw new IllegalArgumentException();
        }
        this.classTypeArgs = ctargs;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<? extends Expression> l) {
        this.arguments = l == null ? new ArrayList<Expression>(0) : new ArrayList<Expression>(l);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getTypeArgs() + " " + this.getClassName() + " " + this.getClassTypeArgs() + " " + this.getExpression() + " " + this.getArguments() + ")";
    }
}

