/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.CollapsedIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.MappedIterable;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollapsedIterable<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
OptimizedLastIterable<T>,
Composite,
Serializable {
    private final Iterable<? extends Iterable<? extends T>> _iters;

    public CollapsedIterable(Iterable<? extends Iterable<? extends T>> iters) {
        this._iters = iters;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._iters) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._iters) + 1;
    }

    @Override
    public CollapsedIterator<T> iterator() {
        Iterator i = new MappedIterable(this._iters, GetIterator.make()).iterator();
        return new CollapsedIterator(i);
    }

    @Override
    public boolean isEmpty() {
        return this.size(1) == 0;
    }

    @Override
    public int size() {
        int result = 0;
        for (Iterable<? extends T> iterable : this._iters) {
            if ((result += IterUtil.sizeOf(iterable)) >= 0) continue;
            result = Integer.MAX_VALUE;
            break;
        }
        return result;
    }

    @Override
    public int size(int bound) {
        int result = 0;
        for (Iterable<? extends T> iterable : this._iters) {
            if ((result += IterUtil.sizeOf(iterable)) >= bound) break;
            if (result >= 0) continue;
            result = Integer.MAX_VALUE;
            break;
        }
        return result <= bound ? result : bound;
    }

    @Override
    public boolean isInfinite() {
        if (IterUtil.isInfinite(this._iters)) {
            return true;
        }
        for (Iterable<? extends T> iterable : this._iters) {
            if (!IterUtil.isInfinite(iterable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        if (!IterUtil.hasFixedSize(this._iters)) {
            return false;
        }
        for (Iterable<? extends T> iterable : this._iters) {
            if (IterUtil.hasFixedSize(iterable)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStatic() {
        if (!IterUtil.isStatic(this._iters)) {
            return false;
        }
        for (Iterable<? extends T> iterable : this._iters) {
            if (IterUtil.isStatic(iterable)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T last() {
        Iterable<? extends T> lastNonEmpty = null;
        for (Iterable<? extends T> iterable : this._iters) {
            if (lastNonEmpty != null && IterUtil.isEmpty(iterable)) continue;
            lastNonEmpty = iterable;
        }
        return IterUtil.last(lastNonEmpty);
    }

    public static <T> CollapsedIterable<T> make(Iterable<? extends Iterable<? extends T>> iters) {
        return new CollapsedIterable<T>(iters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetIterator<T>
    implements Lambda<Iterable<? extends T>, Iterator<? extends T>>,
    Serializable {
        public static final GetIterator<Object> INSTANCE = new GetIterator();

        public static <T> GetIterator<T> make() {
            return INSTANCE;
        }

        private GetIterator() {
        }

        @Override
        public Iterator<? extends T> value(Iterable<? extends T> iter2) {
            return iter2.iterator();
        }
    }
}

