/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.IndentedTextLogSink;
import edu.rice.cs.plt.debug.LogSink;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class SystemErrLogSink
extends IndentedTextLogSink {
    private final Charset _charset;
    private volatile BufferedWriter _writer;
    private volatile PrintStream _currentStream;

    public SystemErrLogSink() {
        this._charset = Charset.defaultCharset();
        this._writer = null;
        this._currentStream = null;
    }

    public SystemErrLogSink(String charsetName) throws UnsupportedEncodingException {
        this._charset = Charset.forName(charsetName);
        this._currentStream = null;
    }

    public SystemErrLogSink(int idealLineWidth) {
        super(idealLineWidth);
        this._charset = Charset.defaultCharset();
        this._writer = null;
        this._currentStream = null;
    }

    public SystemErrLogSink(String charsetName, int idealLineWidth) throws UnsupportedEncodingException {
        super(idealLineWidth);
        this._charset = Charset.forName(charsetName);
        this._writer = null;
        this._currentStream = null;
    }

    protected BufferedWriter writer(LogSink.Message m) {
        PrintStream err = System.err;
        if (this._currentStream != err) {
            this._writer = new BufferedWriter(new OutputStreamWriter((OutputStream)err, this._charset));
            this._currentStream = err;
        }
        return this._writer;
    }

    public void close() throws IOException {
        this._writer.close();
    }
}

