/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.symbol.BoundedSymbol;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.StandardTypeSystem;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ArrayType;
import edu.rice.cs.dynamicjava.symbol.type.BottomType;
import edu.rice.cs.dynamicjava.symbol.type.BoundType;
import edu.rice.cs.dynamicjava.symbol.type.ByteType;
import edu.rice.cs.dynamicjava.symbol.type.CharType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.FloatType;
import edu.rice.cs.dynamicjava.symbol.type.FloatingPointType;
import edu.rice.cs.dynamicjava.symbol.type.IntType;
import edu.rice.cs.dynamicjava.symbol.type.IntegerType;
import edu.rice.cs.dynamicjava.symbol.type.IntersectionType;
import edu.rice.cs.dynamicjava.symbol.type.LongType;
import edu.rice.cs.dynamicjava.symbol.type.NullType;
import edu.rice.cs.dynamicjava.symbol.type.ParameterizedClassType;
import edu.rice.cs.dynamicjava.symbol.type.PrimitiveType;
import edu.rice.cs.dynamicjava.symbol.type.RawClassType;
import edu.rice.cs.dynamicjava.symbol.type.ShortType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleArrayType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleClassType;
import edu.rice.cs.dynamicjava.symbol.type.TopType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.TypeAbstractVisitor;
import edu.rice.cs.dynamicjava.symbol.type.TypeAbstractVisitor_void;
import edu.rice.cs.dynamicjava.symbol.type.TypeVisitorLambda;
import edu.rice.cs.dynamicjava.symbol.type.UnionType;
import edu.rice.cs.dynamicjava.symbol.type.ValidType;
import edu.rice.cs.dynamicjava.symbol.type.VarargArrayType;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.dynamicjava.symbol.type.Wildcard;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.IndexedRelation;
import edu.rice.cs.plt.collect.Order;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.FilteredIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.recur.PrecomputedRecursionStack;
import edu.rice.cs.plt.recur.RecursionStack;
import edu.rice.cs.plt.recur.RecursionStack2;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.plt.tuple.Triple;
import edu.rice.cs.plt.tuple.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLSTypeSystem
extends StandardTypeSystem {
    private final boolean _packCaptureVars;
    private final boolean _alwaysUseArgumentConstraints;
    private final boolean _waitToUseDeclaredBounds;

    public JLSTypeSystem(Options opt) {
        this(opt, true, true, true, true, true, true);
    }

    public JLSTypeSystem(Options opt, boolean packCaptureVars, boolean alwaysUseArgumentConstraints, boolean waitToUseDeclaredBounds, boolean boxingInMostSpecific, boolean useExplicitTypeArgs, boolean strictClassEquality) {
        super(opt, boxingInMostSpecific, useExplicitTypeArgs, strictClassEquality);
        this._packCaptureVars = packCaptureVars;
        this._alwaysUseArgumentConstraints = alwaysUseArgumentConstraints;
        this._waitToUseDeclaredBounds = waitToUseDeclaredBounds;
    }

    @Override
    public boolean isWellFormed(Type t) {
        return t.apply(new WellFormedTester());
    }

    @Override
    public boolean isEqual(Type t1, Type t2) {
        return new IsEqualTester().contains(t1, t2);
    }

    @Override
    public boolean isSubtype(Type subT, Type superT) {
        return new Subtyper().contains(subT, superT);
    }

    @Override
    public Type join(Iterable<? extends Type> ts) {
        return this.join(ts, new PrecomputedRecursionStack<Set<Type>, Wildcard>(Wrapper.factory()));
    }

    private Type join(Iterable<? extends Type> ts, final PrecomputedRecursionStack<Set<Type>, Wildcard> joinStack) {
        if (this._packCaptureVars) {
            ts = IterUtil.mapSnapshot(ts, new Lambda<Type, Type>(){

                @Override
                public Type value(Type t) {
                    while (t instanceof VariableType && ((VariableType)t).symbol().generated()) {
                        t = ((VariableType)t).symbol().upperBound();
                    }
                    return t;
                }
            });
        }
        switch (IterUtil.sizeOf(ts, 2)) {
            case 0: {
                return BOTTOM;
            }
            case 1: {
                return IterUtil.first(ts);
            }
        }
        boolean hasNonReference = false;
        boolean hasReference = false;
        for (Type type : ts) {
            if (this.isReference(type)) {
                hasReference = true;
                continue;
            }
            hasNonReference = true;
        }
        if (hasNonReference && hasReference) {
            return TOP;
        }
        final Set<Object> toJoin = CollectUtil.asSet(IterUtil.filter(ts, LambdaUtil.bindFirst(LambdaUtil.NOT_EQUAL, NULL)));
        switch (toJoin.size()) {
            case 0: {
                return NULL;
            }
            case 1: {
                return (Type)IterUtil.first(toJoin);
            }
        }
        Set<Type> set = ((Type)IterUtil.first(toJoin)).apply(new ErasedSuperAccumulator()).result();
        for (Type type : IterUtil.skipFirst(toJoin)) {
            set.retainAll(type.apply(new ErasedSuperAccumulator()).result());
        }
        List<Type> minimalSupers = CollectUtil.minList(set, new Subtyper());
        SnapshotIterable<Type> snapshotIterable = IterUtil.mapSnapshot(minimalSupers, new Lambda<Type, Type>(){

            @Override
            public Type value(Type erasedT) {
                if (erasedT instanceof RawClassType) {
                    TypeArgumentMerger merger = new TypeArgumentMerger((RawClassType)erasedT);
                    IterUtil.run(toJoin, LambdaUtil.asRunnable(merger));
                    return merger.result(joinStack);
                }
                return erasedT;
            }
        });
        return this.meet(snapshotIterable);
    }

    @Override
    public Type meet(Iterable<? extends Type> ts) {
        Set<? extends Type> toMeet = CollectUtil.asSet(ts);
        switch (toMeet.size()) {
            case 0: {
                return TOP;
            }
            case 1: {
                return IterUtil.first(toMeet);
            }
        }
        return new IntersectionType(IterUtil.snapshot(toMeet));
    }

    @Override
    protected Iterable<Type> captureTypeArgs(Iterable<? extends Type> targs, Iterable<? extends VariableType> params) {
        LinkedList<BoundedSymbol> captureVars = new LinkedList<BoundedSymbol>();
        LinkedList<Type> newArgs = new LinkedList<Type>();
        for (Type type : targs) {
            if (type instanceof Wildcard) {
                BoundedSymbol s = new BoundedSymbol(new Object());
                captureVars.add(s);
                newArgs.add(new VariableType(s));
                continue;
            }
            captureVars.add(null);
            newArgs.add(type);
        }
        StandardTypeSystem.SubstitutionMap sigma = new StandardTypeSystem.SubstitutionMap(params, newArgs);
        HashSet hashSet = new HashSet();
        CollectUtil.addAll(hashSet, params);
        while (!hashSet.isEmpty()) {
            boolean changed = false;
            for (Triple triple : IterUtil.zip(captureVars, targs, params)) {
                VariableType param = (VariableType)triple.third();
                if (this.containsAnyVar(param.symbol().lowerBound(), hashSet)) continue;
                Type arg = (Type)triple.second();
                if (arg instanceof Wildcard) {
                    Wildcard argW = (Wildcard)arg;
                    Type wildU = argW.symbol().upperBound();
                    Type paramU = this.substitute(param.symbol().upperBound(), sigma);
                    Type wildL = argW.symbol().lowerBound();
                    Type paramL = this.substitute(param.symbol().lowerBound(), sigma);
                    Type captU = wildU.equals(OBJECT) ? paramU : (paramU.equals(OBJECT) ? wildU : new IntersectionType(IterUtil.make(wildU, paramU)));
                    ((BoundedSymbol)triple.first()).initializeUpperBound(captU);
                    ((BoundedSymbol)triple.first()).initializeLowerBound(this.join(wildL, paramL));
                }
                hashSet.remove(param);
                changed = true;
            }
            if (changed) continue;
            throw new IllegalArgumentException("Params have circular lower-bound dependency: " + params);
        }
        return newArgs;
    }

    @Override
    protected Iterable<Type> inferTypeArguments(Iterable<? extends VariableType> tparams, Iterable<? extends Type> params, Type returned, Iterable<? extends Type> args, Option<Type> expected) {
        Set<Type> upperBounds;
        Set<Type> eqBounds;
        Inferencer inf = new Inferencer(CollectUtil.makeSet(tparams));
        for (Pair pair : IterUtil.zip(args, params)) {
            inf.subtype((Type)pair.first(), (Type)pair.second());
        }
        ConstraintSet constraints = inf.constraints();
        HashMap<VariableType, Type> hashMap = new HashMap<VariableType, Type>();
        FilteredIterable<Object> toInfer = IterUtil.filter(tparams, LambdaUtil.negate(CollectUtil.asPredicateSet(hashMap.keySet())));
        for (VariableType variableType : toInfer) {
            eqBounds = constraints.equalBounds(variableType);
            if (eqBounds.isEmpty()) continue;
            hashMap.put(variableType, IterUtil.first(eqBounds));
        }
        for (VariableType variableType : toInfer) {
            Set<Type> lowerBounds = constraints.lowerBounds(variableType);
            if (lowerBounds.isEmpty()) continue;
            hashMap.put(variableType, this.join(lowerBounds));
        }
        if (!this._alwaysUseArgumentConstraints) {
            inf = new Inferencer(CollectUtil.makeSet(toInfer));
            constraints = inf.constraints();
        }
        if (expected.isSome()) {
            inf.supertype(expected.unwrap(), this.substitute(returned, new StandardTypeSystem.SubstitutionMap(hashMap)));
            for (VariableType variableType : toInfer) {
                eqBounds = constraints.equalBounds(variableType);
                if (eqBounds.isEmpty()) continue;
                hashMap.put(variableType, IterUtil.first(eqBounds));
            }
        }
        if (this._waitToUseDeclaredBounds) {
            for (VariableType variableType : toInfer) {
                upperBounds = constraints.upperBounds(variableType);
                if (upperBounds.isEmpty()) continue;
                hashMap.put(variableType, this.meet(upperBounds));
            }
            for (VariableType variableType : toInfer) {
                hashMap.put(variableType, this.substitute(variableType.symbol().upperBound(), new StandardTypeSystem.SubstitutionMap(hashMap)));
            }
        } else {
            for (VariableType variableType : toInfer) {
                upperBounds = constraints.upperBounds(variableType);
                Type declared = variableType.symbol().upperBound();
                if (!declared.equals(OBJECT)) {
                    upperBounds = CollectUtil.union(upperBounds, this.substitute(declared, new StandardTypeSystem.SubstitutionMap(hashMap)));
                }
                hashMap.put(variableType, this.meet(upperBounds));
            }
        }
        SnapshotIterable<Type> result = IterUtil.mapSnapshot(tparams, CollectUtil.asLambdaMap(hashMap));
        StandardTypeSystem.SubstitutionMap substitutionMap = new StandardTypeSystem.SubstitutionMap(tparams, result);
        boolean valid = this.inBounds(tparams, result);
        for (Pair pair : IterUtil.zip(args, params)) {
            if (!valid) break;
            valid &= this.isSubtype((Type)pair.first(), this.substitute((Type)pair.second(), substitutionMap));
        }
        return valid ? result : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Inferencer {
        private final Set<? extends VariableType> _vars;
        private final ConstraintSet _constraints;
        private final RecursionStack2<Type, Type> _subStack;
        private final RecursionStack2<Type, Type> _supStack;
        private final TypeVisitorLambda<Boolean> _containsVar = new TypeAbstractVisitor<Boolean>(){
            private final RecursionStack<Type> _stack = new RecursionStack(Wrapper.factory());

            @Override
            public Boolean defaultCase(Type t) {
                return false;
            }

            @Override
            public Boolean forArrayType(ArrayType t) {
                return t.ofType().apply(this);
            }

            @Override
            public Boolean forParameterizedClassType(ParameterizedClassType t) {
                return this.checkList(t.typeArguments());
            }

            @Override
            public Boolean forBoundType(BoundType t) {
                return this.checkList(t.ofTypes());
            }

            @Override
            public Boolean forVariableType(VariableType t) {
                return Inferencer.this._vars.contains(t) || this.checkBoundedSymbol(t, t.symbol()) != false;
            }

            @Override
            public Boolean forWildcard(Wildcard w) {
                return this.checkBoundedSymbol(w, w.symbol());
            }

            private Boolean checkList(Iterable<? extends Type> types) {
                for (Type type : types) {
                    if (!type.apply(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            private Boolean checkBoundedSymbol(Type t, final BoundedSymbol s) {
                final 4 visitor = this;
                Thunk<Boolean> handleBounds = new Thunk<Boolean>(){

                    @Override
                    public Boolean value() {
                        return (Boolean)s.lowerBound().apply(visitor) != false || (Boolean)s.upperBound().apply(visitor) != false;
                    }
                };
                return this._stack.apply(handleBounds, Boolean.valueOf(false), t);
            }
        };

        public Inferencer(Set<? extends VariableType> vars) {
            this._vars = vars;
            this._constraints = new ConstraintSet();
            this._subStack = new RecursionStack2(Pair.factory());
            this._supStack = new RecursionStack2(Pair.factory());
        }

        public ConstraintSet constraints() {
            return this._constraints;
        }

        public void subtype(final Type arg, Type param) {
            if (param.apply(this._containsVar).booleanValue() && !(arg instanceof NullType)) {
                param.apply(new TypeAbstractVisitor_void(){

                    public void forVariableType(VariableType param) {
                        if (Inferencer.this._vars.contains(param)) {
                            Inferencer.this._constraints.addLowerBound(param, arg);
                        }
                    }

                    public void forArrayType(final ArrayType param) {
                        arg.apply(new TypeAbstractVisitor_void(){

                            public void forArrayType(ArrayType arg) {
                                Inferencer.this.subtype(arg.ofType(), param.ofType());
                            }

                            public void forVariableType(VariableType arg) {
                                Runnable recurOnSuper = LambdaUtil.bindFirst(this, arg.symbol().upperBound());
                                Runnable recurOnObject = LambdaUtil.bindFirst(this, TypeSystem.OBJECT);
                                Inferencer.this._subStack.run(recurOnSuper, recurOnObject, arg, param);
                            }
                        });
                    }

                    public void forParameterizedClassType(final ParameterizedClassType param) {
                        arg.apply(new TypeAbstractVisitor_void(){

                            public void forArrayType(ArrayType arg) {
                                StandardTypeSystem.CLONEABLE_AND_SERIALIZABLE.apply(this);
                            }

                            public void forClassType(ClassType arg) {
                                Type argSup = JLSTypeSystem.this.immediateSupertype(arg);
                                if (argSup != null) {
                                    argSup.apply(this);
                                }
                            }

                            public void forParameterizedClassType(ParameterizedClassType arg) {
                                if (JLSTypeSystem.this.sameClass(arg, param)) {
                                    for (final Pair pair : IterUtil.zip(arg.typeArguments(), param.typeArguments())) {
                                        ((Type)pair.second()).apply(new TypeAbstractVisitor_void(){

                                            public void forValidType(ValidType param) {
                                                if (pair.first() instanceof ValidType) {
                                                    Inferencer.this.equal((Type)pair.first(), param);
                                                }
                                            }

                                            public void forWildcard(final Wildcard param) {
                                                Runnable recurOnWildcard = new Runnable(){

                                                    public void run() {
                                                        final Type paramUpper = param.symbol().upperBound();
                                                        final Type paramLower = param.symbol().lowerBound();
                                                        if (!paramUpper.equals(TypeSystem.OBJECT)) {
                                                            ((Type)pair.first()).apply(new TypeAbstractVisitor_void(){

                                                                public void forValidType(ValidType arg) {
                                                                    Inferencer.this.subtype(arg, paramUpper);
                                                                }

                                                                public void forWildcard(Wildcard arg) {
                                                                    Type argUpper = arg.symbol().upperBound();
                                                                    if (!argUpper.equals(TypeSystem.OBJECT)) {
                                                                        Inferencer.this.subtype(argUpper, paramUpper);
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        if (!paramLower.equals(TypeSystem.NULL)) {
                                                            ((Type)pair.first()).apply(new TypeAbstractVisitor_void(){

                                                                public void forValidType(ValidType arg) {
                                                                    Inferencer.this.supertype(arg, paramLower);
                                                                }

                                                                public void forWildcard(Wildcard arg) {
                                                                    Type argLower = arg.symbol().lowerBound();
                                                                    if (!argLower.equals(TypeSystem.NULL)) {
                                                                        Inferencer.this.supertype(argLower, paramLower);
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }
                                                };
                                                Inferencer.this._subStack.run(recurOnWildcard, pair.first(), param);
                                            }
                                        });
                                    }
                                } else {
                                    this.forClassType(arg);
                                }
                            }

                            public void forIntersectionType(IntersectionType arg) {
                                for (Type type : arg.ofTypes()) {
                                    type.apply(this);
                                }
                            }

                            public void forVariableType(VariableType arg) {
                                Runnable recurOnSuper = LambdaUtil.bindFirst(this, arg.symbol().upperBound());
                                Runnable recurOnObject = LambdaUtil.bindFirst(this, TypeSystem.OBJECT);
                                Inferencer.this._subStack.run(recurOnSuper, recurOnObject, arg, param);
                            }
                        });
                    }
                });
            }
        }

        public void supertype(final Type arg, Type param) {
            if (param.apply(this._containsVar).booleanValue() && !(arg instanceof NullType)) {
                param.apply(new TypeAbstractVisitor_void(){

                    public void forVariableType(VariableType param) {
                        if (Inferencer.this._vars.contains(param)) {
                            Inferencer.this._constraints.addUpperBound(param, arg);
                        }
                    }

                    public void forArrayType(ArrayType param) {
                        if (arg instanceof ArrayType) {
                            Inferencer.this.supertype(((ArrayType)arg).ofType(), param.ofType());
                        }
                    }

                    public void forParameterizedClassType(final ParameterizedClassType param) {
                        TypeAbstractVisitor_void argVisitor = new TypeAbstractVisitor_void(){

                            public void forParameterizedClassType(ParameterizedClassType arg) {
                                if (JLSTypeSystem.this.sameClass(arg, param)) {
                                    for (final Pair pair : IterUtil.zip(arg.typeArguments(), param.typeArguments())) {
                                        ((Type)pair.first()).apply(new TypeAbstractVisitor_void(){

                                            public void forValidType(ValidType arg) {
                                                if (pair.second() instanceof ValidType) {
                                                    Inferencer.this.equal(arg, (Type)pair.second());
                                                }
                                            }

                                            public void forWildcard(Wildcard arg) {
                                                final Type argUpper = arg.symbol().upperBound();
                                                final Type argLower = arg.symbol().lowerBound();
                                                if (!argUpper.equals(TypeSystem.OBJECT)) {
                                                    ((Type)pair.second()).apply(new TypeAbstractVisitor_void(){

                                                        public void forValidType(ValidType param) {
                                                            Inferencer.this.supertype(argUpper, param);
                                                        }

                                                        public void forWildcard(Wildcard param) {
                                                            Type paramUpper = param.symbol().upperBound();
                                                            if (!paramUpper.equals(TypeSystem.OBJECT)) {
                                                                Inferencer.this.supertype(argUpper, paramUpper);
                                                            }
                                                        }
                                                    });
                                                }
                                                if (!argLower.equals(TypeSystem.NULL)) {
                                                    ((Type)pair.second()).apply(new TypeAbstractVisitor_void(){

                                                        public void forValidType(ValidType param) {
                                                            Inferencer.this.subtype(argLower, param);
                                                        }

                                                        public void forWildcard(Wildcard param) {
                                                            Type paramLower = param.symbol().lowerBound();
                                                            if (!paramLower.equals(TypeSystem.NULL)) {
                                                                Inferencer.this.subtype(argLower, paramLower);
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    Type paramSup = JLSTypeSystem.this.immediateSupertype(param);
                                    if (paramSup != null) {
                                        Inferencer.this.supertype(arg, paramSup);
                                    }
                                }
                            }
                        };
                        Inferencer.this._supStack.run(LambdaUtil.bindFirst(argVisitor, arg), arg, param);
                    }

                    public void forIntersectionType(IntersectionType param) {
                        for (Type type : param.ofTypes()) {
                            Inferencer.this.supertype(arg, type);
                        }
                    }
                });
            }
        }

        public void equal(final Type arg, Type param) {
            if (param.apply(this._containsVar).booleanValue() && !(arg instanceof NullType)) {
                param.apply(new TypeAbstractVisitor_void(){

                    public void forVariableType(VariableType param) {
                        if (Inferencer.this._vars.contains(param)) {
                            Inferencer.this._constraints.addEqualBound(param, arg);
                        }
                    }

                    public void forArrayType(ArrayType param) {
                        if (arg instanceof ArrayType) {
                            Inferencer.this.equal(((ArrayType)arg).ofType(), param.ofType());
                        }
                    }

                    public void forParameterizedClassType(ParameterizedClassType param) {
                        if (arg instanceof ParameterizedClassType) {
                            for (Pair pair : IterUtil.zip(((ParameterizedClassType)arg).typeArguments(), param.typeArguments())) {
                                if (pair.first() instanceof ValidType && pair.second() instanceof ValidType) {
                                    Inferencer.this.equal((Type)pair.first(), (Type)pair.second());
                                    continue;
                                }
                                if (!(pair.first() instanceof Wildcard) || !(pair.second() instanceof Wildcard)) continue;
                                BoundedSymbol argBounds = ((Wildcard)pair.first()).symbol();
                                BoundedSymbol paramBounds = ((Wildcard)pair.second()).symbol();
                                if (!argBounds.upperBound().equals(TypeSystem.OBJECT) && !paramBounds.upperBound().equals(TypeSystem.OBJECT)) {
                                    Inferencer.this.equal(argBounds.upperBound(), paramBounds.upperBound());
                                }
                                if (argBounds.lowerBound().equals(TypeSystem.NULL) || paramBounds.lowerBound().equals(TypeSystem.NULL)) continue;
                                Inferencer.this.equal(argBounds.lowerBound(), paramBounds.lowerBound());
                            }
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstraintSet {
        private final Relation<VariableType, Type> _equalBounds;
        private final Relation<VariableType, Type> _upperBounds;
        private final Relation<VariableType, Type> _lowerBounds;

        public ConstraintSet() {
            Thunk mapFactory = CollectUtil.hashMapFactory();
            Thunk setFactory = CollectUtil.linkedHashSetFactory();
            this._equalBounds = new IndexedRelation<VariableType, Type>(mapFactory, setFactory);
            this._upperBounds = new IndexedRelation<VariableType, Type>(mapFactory, setFactory);
            this._lowerBounds = new IndexedRelation<VariableType, Type>(mapFactory, setFactory);
        }

        public void addEqualBound(VariableType var, Type t) {
            this._equalBounds.add(var, t);
        }

        public void addUpperBound(VariableType var, Type t) {
            this._upperBounds.add(var, t);
        }

        public void addLowerBound(VariableType var, Type t) {
            this._lowerBounds.add(var, t);
        }

        public Set<Type> equalBounds(VariableType var) {
            return this._equalBounds.matchFirst(var);
        }

        public Set<Type> upperBounds(VariableType var) {
            return this._upperBounds.matchFirst(var);
        }

        public Set<Type> lowerBounds(VariableType var) {
            return this._lowerBounds.matchFirst(var);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeArgumentMerger
    extends TypeAbstractVisitor<TypeArgumentMerger> {
        private final DJClass _c;
        private final RecursionStack<Type> _stack;
        private final List<ArgSet> _args;
        private boolean _rawResult;

        public TypeArgumentMerger(RawClassType erased) {
            this._c = erased.ofClass();
            this._stack = new RecursionStack(Wrapper.factory());
            int params = IterUtil.sizeOf(SymbolUtil.allTypeParameters(this._c));
            this._args = new ArrayList<ArgSet>(params);
            for (int i = 0; i < params; ++i) {
                this._args.add(new ArgSet());
            }
            this._rawResult = false;
        }

        public ClassType result(final PrecomputedRecursionStack<Set<Type>, Wildcard> joinStack) {
            if (this._rawResult) {
                return new RawClassType(this._c);
            }
            return new ParameterizedClassType(this._c, IterUtil.mapSnapshot(this._args, new Lambda<ArgSet, Type>(){

                @Override
                public Type value(ArgSet set) {
                    return set.merge(joinStack);
                }
            }));
        }

        @Override
        public TypeArgumentMerger defaultCase(Type t) {
            return this;
        }

        @Override
        public TypeArgumentMerger forArrayType(ArrayType t) {
            return StandardTypeSystem.CLONEABLE_AND_SERIALIZABLE.apply(this);
        }

        @Override
        public TypeArgumentMerger forClassType(ClassType t) {
            Type sup = JLSTypeSystem.this.immediateSupertype(t);
            if (sup != null) {
                sup.apply(this);
            }
            return this;
        }

        @Override
        public TypeArgumentMerger forRawClassType(RawClassType t) {
            if (t.ofClass().equals(this._c)) {
                this._rawResult = true;
            } else {
                this.forClassType(t);
            }
            return this;
        }

        @Override
        public TypeArgumentMerger forParameterizedClassType(ParameterizedClassType t) {
            if (t.ofClass().equals(this._c)) {
                for (Pair pair : IterUtil.zip(this._args, t.typeArguments())) {
                    ((ArgSet)pair.first()).add((Type)pair.second());
                }
            } else {
                this.forClassType(t);
            }
            return this;
        }

        @Override
        public TypeArgumentMerger forIntersectionType(IntersectionType t) {
            for (Type type : t.ofTypes()) {
                type.apply(this);
            }
            return this;
        }

        @Override
        public TypeArgumentMerger forVariableType(VariableType t) {
            Runnable recurOnBound = LambdaUtil.asRunnable(LambdaUtil.bindFirst(this, t.symbol().upperBound()));
            Runnable recurOnObject = LambdaUtil.asRunnable(LambdaUtil.bindFirst(this, TypeSystem.OBJECT));
            this._stack.run(recurOnBound, recurOnObject, t);
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ArgSet {
            private final Set<Type> _types = new LinkedHashSet<Type>();
            private boolean _wildcardUpper = false;
            private boolean _wildcardLower = false;

            public void add(Type t) {
                if (t instanceof Wildcard) {
                    BoundedSymbol s = ((Wildcard)t).symbol();
                    if (s.upperBound().equals(TypeSystem.OBJECT)) {
                        if (s.lowerBound().equals(TypeSystem.NULL)) {
                            this._wildcardUpper = true;
                        } else {
                            this._types.add(s.lowerBound());
                            this._wildcardLower = true;
                        }
                    } else {
                        this._types.add(s.upperBound());
                        this._wildcardUpper = true;
                    }
                } else {
                    this._types.add(t);
                }
            }

            public Type merge(final PrecomputedRecursionStack<Set<Type>, Wildcard> joinStack) {
                if (this._types.isEmpty() || this._wildcardUpper && this._wildcardLower) {
                    return new Wildcard(new BoundedSymbol(new Object(), TypeSystem.OBJECT, TypeSystem.NULL));
                }
                if (this._wildcardLower) {
                    return new Wildcard(new BoundedSymbol(new Object(), TypeSystem.OBJECT, JLSTypeSystem.this.meet(this._types)));
                }
                if (this._wildcardUpper || this._types.size() > 1) {
                    final Wildcard result = new Wildcard(new BoundedSymbol(new Object()));
                    Thunk<Wildcard> recur = new Thunk<Wildcard>(){

                        @Override
                        public Wildcard value() {
                            result.symbol().initializeLowerBound(TypeSystem.NULL);
                            result.symbol().initializeUpperBound(JLSTypeSystem.this.join(ArgSet.this._types, joinStack));
                            return result;
                        }
                    };
                    return joinStack.apply(recur, result, this._types);
                }
                return IterUtil.first(this._types);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ErasedSuperAccumulator
    extends TypeAbstractVisitor<ErasedSuperAccumulator> {
        private final Set<Type> _result = new LinkedHashSet<Type>();
        private final RecursionStack<Type> _stack = new RecursionStack(Wrapper.factory());

        public Set<Type> result() {
            return this._result;
        }

        @Override
        public ErasedSuperAccumulator forPrimitiveType(PrimitiveType t) {
            this._result.add(t);
            return this;
        }

        @Override
        public ErasedSuperAccumulator forCharType(CharType t) {
            this._result.addAll(Arrays.asList(TypeSystem.CHAR, TypeSystem.INT, TypeSystem.LONG, TypeSystem.FLOAT, TypeSystem.DOUBLE));
            return this;
        }

        @Override
        public ErasedSuperAccumulator forByteType(ByteType t) {
            this._result.addAll(Arrays.asList(TypeSystem.BYTE, TypeSystem.SHORT, TypeSystem.INT, TypeSystem.LONG, TypeSystem.FLOAT, TypeSystem.DOUBLE));
            return this;
        }

        @Override
        public ErasedSuperAccumulator forShortType(ShortType t) {
            this._result.addAll(Arrays.asList(TypeSystem.SHORT, TypeSystem.INT, TypeSystem.LONG, TypeSystem.FLOAT, TypeSystem.DOUBLE));
            return this;
        }

        @Override
        public ErasedSuperAccumulator forIntType(IntType t) {
            this._result.addAll(Arrays.asList(TypeSystem.INT, TypeSystem.LONG, TypeSystem.FLOAT, TypeSystem.DOUBLE));
            return this;
        }

        @Override
        public ErasedSuperAccumulator forLongType(LongType t) {
            this._result.addAll(Arrays.asList(TypeSystem.LONG, TypeSystem.FLOAT, TypeSystem.DOUBLE));
            return this;
        }

        @Override
        public ErasedSuperAccumulator forFloatType(FloatType t) {
            this._result.addAll(Arrays.asList(TypeSystem.FLOAT, TypeSystem.DOUBLE));
            return this;
        }

        @Override
        public ErasedSuperAccumulator forNullType(NullType t) {
            this._result.add(t);
            return this;
        }

        @Override
        public ErasedSuperAccumulator forArrayType(ArrayType t) {
            Set<Type> elementTypes = t.ofType().apply(new ErasedSuperAccumulator()).result();
            for (Type elt : elementTypes) {
                this._result.add(new SimpleArrayType(elt));
            }
            StandardTypeSystem.CLONEABLE_AND_SERIALIZABLE.apply(this);
            return this;
        }

        @Override
        public ErasedSuperAccumulator forClassType(ClassType t) {
            this._result.add(JLSTypeSystem.this.erase(t));
            Type sup = JLSTypeSystem.this.immediateSupertype(t);
            if (sup != null) {
                sup.apply(this);
            }
            return this;
        }

        @Override
        public ErasedSuperAccumulator forIntersectionType(IntersectionType t) {
            for (Type type : t.ofTypes()) {
                type.apply(this);
            }
            return this;
        }

        @Override
        public ErasedSuperAccumulator forVariableType(VariableType t) {
            Runnable recurOnBound = LambdaUtil.asRunnable(LambdaUtil.bindFirst(this, t.symbol().upperBound()));
            Runnable recurOnObject = LambdaUtil.asRunnable(LambdaUtil.bindFirst(this, TypeSystem.OBJECT));
            this._stack.run(recurOnBound, recurOnObject, t);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Subtyper
    implements Order<Type>,
    Lambda2<Type, Type, Boolean> {
        RecursionStack2<Type, Type> _stack = new RecursionStack2(Pair.factory());

        private Subtyper() {
        }

        @Override
        public Boolean value(Type subT, Type superT) {
            return this.contains(subT, superT);
        }

        public Predicate<Type> supertypes(Type sub) {
            return LambdaUtil.bindFirst(this, sub);
        }

        public Predicate<Type> subtypes(Type sup) {
            return LambdaUtil.bindSecond(this, sup);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(final Type subT, final Type superT) {
            DebugUtil.debug.logStart(new String[]{"subT", "superT"}, JLSTypeSystem.this.wrap(subT), JLSTypeSystem.this.wrap(superT));
            try {
                if (subT.equals(superT)) {
                    boolean bl = true;
                    return bl;
                }
                Boolean result = superT.apply(new TypeAbstractVisitor<Boolean>(){

                    @Override
                    public Boolean defaultCase(Type superT) {
                        return null;
                    }

                    @Override
                    public Boolean forVariableType(final VariableType superT) {
                        return subT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(final Type subT) {
                                Thunk<Boolean> checkLowerBound = new Thunk<Boolean>(){

                                    @Override
                                    public Boolean value() {
                                        return Subtyper.this.contains(subT, superT.symbol().lowerBound());
                                    }
                                };
                                Thunk<Boolean> checkInfinite = new Thunk<Boolean>(){

                                    @Override
                                    public Boolean value() {
                                        return Subtyper.this.contains(subT, TypeSystem.NULL);
                                    }
                                };
                                return Subtyper.this._stack.apply(checkLowerBound, checkInfinite, subT, (Type)superT);
                            }

                            @Override
                            public Boolean forVariableType(VariableType subT) {
                                return this.defaultCase(subT) != false ? Boolean.valueOf(true) : null;
                            }

                            @Override
                            public Boolean forIntersectionType(IntersectionType subT) {
                                return this.defaultCase(subT) != false ? Boolean.valueOf(true) : null;
                            }

                            @Override
                            public Boolean forBottomType(BottomType subT) {
                                return true;
                            }
                        });
                    }

                    @Override
                    public Boolean forIntersectionType(IntersectionType superT) {
                        if (subT instanceof BottomType) {
                            return true;
                        }
                        return IterUtil.and(superT.ofTypes(), Subtyper.this.supertypes(subT));
                    }

                    @Override
                    public Boolean forTopType(TopType superT) {
                        return true;
                    }
                });
                if (result != null) {
                    boolean bl = result;
                    return bl;
                }
                boolean bl = subT.apply(new TypeAbstractVisitor<Boolean>(){

                    @Override
                    public Boolean defaultCase(Type t) {
                        return false;
                    }

                    @Override
                    public Boolean forCharType(CharType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forCharType(CharType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forIntType(IntType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forLongType(LongType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forFloatingPointType(FloatingPointType superT) {
                                return true;
                            }
                        });
                    }

                    @Override
                    public Boolean forByteType(ByteType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forIntegerType(IntegerType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forFloatingPointType(FloatingPointType superT) {
                                return true;
                            }
                        });
                    }

                    @Override
                    public Boolean forShortType(ShortType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forShortType(ShortType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forIntType(IntType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forLongType(LongType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forFloatingPointType(FloatingPointType superT) {
                                return true;
                            }
                        });
                    }

                    @Override
                    public Boolean forIntType(IntType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forIntType(IntType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forLongType(LongType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forFloatingPointType(FloatingPointType superT) {
                                return true;
                            }
                        });
                    }

                    @Override
                    public Boolean forLongType(LongType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forLongType(LongType superT) {
                                return true;
                            }

                            @Override
                            public Boolean forFloatingPointType(FloatingPointType superT) {
                                return true;
                            }
                        });
                    }

                    @Override
                    public Boolean forFloatType(FloatType subT) {
                        return superT instanceof FloatingPointType;
                    }

                    @Override
                    public Boolean forNullType(NullType subT) {
                        return JLSTypeSystem.this.isReference(superT);
                    }

                    @Override
                    public Boolean forSimpleArrayType(SimpleArrayType subT) {
                        return this.handleArrayType(subT);
                    }

                    @Override
                    public Boolean forVarargArrayType(VarargArrayType subT) {
                        return this.handleArrayType(subT);
                    }

                    private Boolean handleArrayType(final ArrayType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forArrayType(ArrayType superT) {
                                if (JLSTypeSystem.this.isPrimitive(subT.ofType())) {
                                    return subT.ofType().equals(superT.ofType());
                                }
                                return Subtyper.this.contains(subT.ofType(), superT.ofType());
                            }

                            @Override
                            public Boolean forClassType(ClassType superT) {
                                return Subtyper.this.contains(StandardTypeSystem.CLONEABLE_AND_SERIALIZABLE, superT);
                            }
                        });
                    }

                    @Override
                    public Boolean forSimpleClassType(final SimpleClassType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forClassType(ClassType superT) {
                                Type newSub = JLSTypeSystem.this.immediateSupertype(subT);
                                if (newSub == null) {
                                    return false;
                                }
                                return Subtyper.this.contains(newSub, superT);
                            }

                            @Override
                            public Boolean forSimpleClassType(SimpleClassType superT) {
                                return JLSTypeSystem.this.sameClass(subT, superT) || this.forClassType(superT) != false;
                            }
                        });
                    }

                    @Override
                    public Boolean forRawClassType(final RawClassType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forClassType(ClassType superT) {
                                Type newSub = JLSTypeSystem.this.immediateSupertype(subT);
                                if (newSub == null) {
                                    return false;
                                }
                                return Subtyper.this.contains(newSub, superT);
                            }

                            @Override
                            public Boolean forRawClassType(RawClassType superT) {
                                return JLSTypeSystem.this.sameClass(subT, superT) || this.forClassType(superT) != false;
                            }

                            @Override
                            public Boolean forParameterizedClassType(ParameterizedClassType superT) {
                                if (JLSTypeSystem.this.sameClass(subT, superT)) {
                                    return Subtyper.this.contains(JLSTypeSystem.this.parameterize(subT), superT) || this.forClassType(superT) != false;
                                }
                                return this.forClassType(superT);
                            }
                        });
                    }

                    @Override
                    public Boolean forParameterizedClassType(final ParameterizedClassType subT) {
                        return superT.apply(new TypeAbstractVisitor<Boolean>(){

                            @Override
                            public Boolean defaultCase(Type superT) {
                                return false;
                            }

                            @Override
                            public Boolean forClassType(ClassType superT) {
                                Type newSub = JLSTypeSystem.this.immediateSupertype(subT);
                                if (newSub == null) {
                                    return false;
                                }
                                return Subtyper.this.contains(newSub, superT);
                            }

                            @Override
                            public Boolean forParameterizedClassType(ParameterizedClassType superT) {
                                if (JLSTypeSystem.this.sameClass(subT, superT)) {
                                    Triple args;
                                    boolean result = true;
                                    ParameterizedClassType subCapT = JLSTypeSystem.this.capture(subT);
                                    Iterator i$ = IterUtil.zip(subT.typeArguments(), subCapT.typeArguments(), superT.typeArguments()).iterator();
                                    while (i$.hasNext() && (result &= ((Type)(args = (Triple)i$.next()).third()).apply(new TypeAbstractVisitor<Boolean>(){

                                        @Override
                                        public Boolean defaultCase(Type superArg) {
                                            return JLSTypeSystem.this.isEqual((Type)args.second(), superArg);
                                        }

                                        @Override
                                        public Boolean forWildcard(final Wildcard superArg) {
                                            Thunk<Boolean> inBounds = new Thunk<Boolean>(){

                                                @Override
                                                public Boolean value() {
                                                    Type subArg = (Type)args.second();
                                                    return Subtyper.this.contains(superArg.symbol().lowerBound(), subArg) && Subtyper.this.contains(subArg, superArg.symbol().upperBound());
                                                }
                                            };
                                            return Subtyper.this._stack.apply(inBounds, Boolean.valueOf(true), (Type)args.first(), (Type)superArg);
                                        }
                                    }).booleanValue())) {
                                    }
                                    return result || this.forClassType(superT) != false;
                                }
                                return this.forClassType(superT);
                            }

                            @Override
                            public Boolean forRawClassType(RawClassType superT) {
                                if (JLSTypeSystem.this.sameClass(subT, superT)) {
                                    return Subtyper.this.contains(JLSTypeSystem.this.erase(subT), superT);
                                }
                                return this.forClassType(superT);
                            }
                        });
                    }

                    @Override
                    public Boolean forVariableType(final VariableType subT) {
                        Thunk<Boolean> checkUpperBound = new Thunk<Boolean>(){

                            @Override
                            public Boolean value() {
                                return Subtyper.this.contains(subT.symbol().upperBound(), superT);
                            }
                        };
                        Thunk<Boolean> checkInfinite = new Thunk<Boolean>(){

                            @Override
                            public Boolean value() {
                                return Subtyper.this.contains(TypeSystem.OBJECT, superT);
                            }
                        };
                        return Subtyper.this._stack.apply(checkUpperBound, checkInfinite, (Type)subT, superT);
                    }

                    @Override
                    public Boolean forIntersectionType(IntersectionType subT) {
                        return IterUtil.or(subT.ofTypes(), Subtyper.this.subtypes(superT));
                    }

                    @Override
                    public Boolean forBottomType(BottomType subT) {
                        return true;
                    }
                });
                return bl;
            }
            finally {
                DebugUtil.debug.logEnd();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsEqualTester
    implements Order<Type>,
    Lambda2<Type, Type, Boolean> {
        RecursionStack2<Type, Type> _stack = new RecursionStack2(Pair.factory());

        private IsEqualTester() {
        }

        @Override
        public Boolean value(Type subT, Type superT) {
            return this.contains(subT, superT);
        }

        @Override
        public boolean contains(Type t1, final Type t2) {
            return t1.apply(new TypeAbstractVisitor<Boolean>(){

                @Override
                public Boolean defaultCase(Type t1) {
                    return t1.equals(t2);
                }

                @Override
                public Boolean forArrayType(ArrayType t1) {
                    return t2 instanceof ArrayType && IsEqualTester.this.contains(t1.ofType(), ((ArrayType)t2).ofType());
                }

                @Override
                public Boolean forSimpleClassType(SimpleClassType t1) {
                    return t2 instanceof SimpleClassType && JLSTypeSystem.this.sameClass(t1, (ClassType)t2);
                }

                @Override
                public Boolean forRawClassType(RawClassType t1) {
                    return t2 instanceof RawClassType && JLSTypeSystem.this.sameClass(t1, (ClassType)t2);
                }

                @Override
                public Boolean forParameterizedClassType(ParameterizedClassType t1) {
                    ParameterizedClassType t2Cast;
                    if (t2 instanceof ParameterizedClassType && JLSTypeSystem.this.sameClass(t1, t2Cast = (ParameterizedClassType)t2) && IterUtil.sizeOf(t1.typeArguments()) == IterUtil.sizeOf(t2Cast.typeArguments())) {
                        return IterUtil.and(t1.typeArguments(), t2Cast.typeArguments(), IsEqualTester.this);
                    }
                    return false;
                }

                @Override
                public Boolean forIntersectionType(IntersectionType t1) {
                    return t2 instanceof IntersectionType && IterUtil.and(t1.ofTypes(), ((IntersectionType)t2).ofTypes(), IsEqualTester.this);
                }

                @Override
                public Boolean forWildcard(final Wildcard t1) {
                    if (t2 instanceof Wildcard) {
                        Thunk<Boolean> recur = new Thunk<Boolean>(){

                            @Override
                            public Boolean value() {
                                BoundedSymbol s1 = t1.symbol();
                                BoundedSymbol s2 = ((Wildcard)t2).symbol();
                                return IsEqualTester.this.contains(s1.upperBound(), s2.upperBound()) && IsEqualTester.this.contains(s1.lowerBound(), s2.lowerBound());
                            }
                        };
                        return IsEqualTester.this._stack.apply(recur, Boolean.valueOf(true), (Type)t1, t2);
                    }
                    return false;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WellFormedTester
    extends TypeAbstractVisitor<Boolean>
    implements Predicate<Type> {
        final RecursionStack<Type> _stack = new RecursionStack(Wrapper.factory());
        Set<Wildcard> _visibleWildcards = new HashSet<Wildcard>();

        private WellFormedTester() {
        }

        private Set<Wildcard> resetVisibleWildcards() {
            Set<Wildcard> result = this._visibleWildcards;
            this._visibleWildcards = new HashSet<Wildcard>();
            return result;
        }

        @Override
        public boolean contains(Type t) {
            return t.apply(this);
        }

        @Override
        public Boolean defaultCase(Type t) {
            return true;
        }

        @Override
        public Boolean forArrayType(ArrayType t) {
            return t.ofType().apply(this);
        }

        @Override
        public Boolean forSimpleClassType(SimpleClassType t) {
            return IterUtil.isEmpty(SymbolUtil.allTypeParameters(t.ofClass()));
        }

        @Override
        public Boolean forRawClassType(RawClassType t) {
            return !IterUtil.isEmpty(SymbolUtil.allTypeParameters(t.ofClass()));
        }

        @Override
        public Boolean forParameterizedClassType(ParameterizedClassType t) {
            Iterable<? extends Type> args = t.typeArguments();
            boolean validArgs = true;
            for (Type type : args) {
                if (validArgs &= type.apply(new TypeAbstractVisitor<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean defaultCase(Type t) {
                        Set old = WellFormedTester.this.resetVisibleWildcards();
                        try {
                            Boolean bl = t.apply(WellFormedTester.this);
                            return bl;
                        }
                        finally {
                            WellFormedTester.this._visibleWildcards = old;
                        }
                    }

                    @Override
                    public Boolean forWildcard(Wildcard w) {
                        return w.apply(WellFormedTester.this);
                    }
                }).booleanValue()) continue;
                return false;
            }
            Iterable<VariableType> params = SymbolUtil.allTypeParameters(t.ofClass());
            if (IterUtil.sizeOf(params) == IterUtil.sizeOf(args)) {
                Iterable<Type> iterable = JLSTypeSystem.this.captureTypeArgs(args, params);
                for (Pair pair : IterUtil.zip(args, iterable)) {
                    Type upper;
                    VariableType cvar;
                    Type lower;
                    if (pair.first() == pair.second() || JLSTypeSystem.this.isSubtype(lower = (cvar = (VariableType)pair.second()).symbol().lowerBound(), upper = cvar.symbol().upperBound())) continue;
                    return false;
                }
                return JLSTypeSystem.this.inBounds(params, iterable);
            }
            return false;
        }

        @Override
        public Boolean forIntersectionType(IntersectionType t) {
            return IterUtil.and(t.ofTypes(), this);
        }

        @Override
        public Boolean forUnionType(UnionType t) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean forVariableType(final VariableType t) {
            Set<Wildcard> old = this.resetVisibleWildcards();
            try {
                Thunk<Boolean> recur = new Thunk<Boolean>(){

                    @Override
                    public Boolean value() {
                        Type lower = t.symbol().lowerBound();
                        Type upper = t.symbol().upperBound();
                        return lower.apply(WellFormedTester.this) != false && upper.apply(WellFormedTester.this) != false && JLSTypeSystem.this.isSubtype(lower, upper) && !JLSTypeSystem.this.containsVar(lower, t);
                    }
                };
                Boolean bl = this._stack.apply(recur, Boolean.valueOf(true), (Type)t);
                return bl;
            }
            finally {
                this._visibleWildcards = old;
            }
        }

        @Override
        public Boolean forWildcard(final Wildcard w) {
            if (this._visibleWildcards.contains(w)) {
                return true;
            }
            Thunk<Boolean> recur = new Thunk<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean value() {
                    Type lower = w.symbol().lowerBound();
                    Type upper = w.symbol().upperBound();
                    WellFormedTester.this._visibleWildcards.add(w);
                    try {
                        if (upper.apply(WellFormedTester.this).booleanValue()) {
                            Set old = WellFormedTester.this.resetVisibleWildcards();
                            try {
                                Boolean bl = lower.apply(WellFormedTester.this) != false && JLSTypeSystem.this.isSubtype(lower, upper);
                                return bl;
                            }
                            finally {
                                WellFormedTester.this._visibleWildcards = old;
                            }
                        }
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        WellFormedTester.this._visibleWildcards.remove(w);
                    }
                }
            };
            return this._stack.apply(recur, Boolean.valueOf(false), (Type)w);
        }
    }
}

