/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Box;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.WrappedException;
import java.lang.reflect.Array;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AmbiguousName;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.AnonymousInnerAllocation;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.AssignExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodCall;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.SimpleFieldAccess;
import koala.dynamicjava.tree.SimpleMethodCall;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableAccess;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluator
extends AbstractVisitor<Object>
implements Lambda<Node, Object> {
    private final RuntimeBindings _bindings;
    private final Options _options;
    public static final Lambda<Object, Object> NOT = new PrimitiveUnaryOperation(){

        public Object value(boolean val) {
            return !val;
        }
    };
    public static final Lambda<Object, Object> COMPLEMENT = new PrimitiveUnaryOperation(){

        public Object value(int val) {
            return ~val;
        }

        public Object value(long val) {
            return val ^ 0xFFFFFFFFFFFFFFFFL;
        }
    };
    public static final Lambda<Object, Object> PLUS = new PrimitiveUnaryOperation(){

        public Object value(int val) {
            return val;
        }

        public Object value(long val) {
            return val;
        }

        public Object value(float val) {
            return Float.valueOf(val);
        }

        public Object value(double val) {
            return val;
        }
    };
    public static final Lambda<Object, Object> MINUS = new PrimitiveUnaryOperation(){

        public Object value(int val) {
            return -val;
        }

        public Object value(long val) {
            return -val;
        }

        public Object value(float val) {
            return Float.valueOf(-val);
        }

        public Object value(double val) {
            return -val;
        }
    };
    public static final Lambda<Object, Object> INCREMENT = new PrimitiveUnaryOperation(){

        public Object value(char val) {
            val = (char)(val + '\u0001');
            return Character.valueOf(val);
        }

        public Object value(byte val) {
            val = (byte)(val + 1);
            return val;
        }

        public Object value(short val) {
            val = (short)(val + 1);
            return val;
        }

        public Object value(int val) {
            return ++val;
        }

        public Object value(long val) {
            return ++val;
        }

        public Object value(float val) {
            return Float.valueOf(val += 1.0f);
        }

        public Object value(double val) {
            return val += 1.0;
        }
    };
    public static final Lambda<Object, Object> DECREMENT = new PrimitiveUnaryOperation(){

        public Object value(char val) {
            val = (char)(val - '\u0001');
            return Character.valueOf(val);
        }

        public Object value(byte val) {
            val = (byte)(val - 1);
            return val;
        }

        public Object value(short val) {
            val = (short)(val - 1);
            return val;
        }

        public Object value(int val) {
            return --val;
        }

        public Object value(long val) {
            return --val;
        }

        public Object value(float val) {
            return Float.valueOf(val -= 1.0f);
        }

        public Object value(double val) {
            return val -= 1.0;
        }
    };
    public static final Lambda2<Object, Object, Object> OBJECT_EQUAL = new Lambda2<Object, Object, Object>(){

        @Override
        public Object value(Object left, Object right) {
            return left == right;
        }
    };
    public static final Lambda2<Object, Object, Object> PRIMITIVE_EQUAL = new Lambda2<Object, Object, Object>(){

        @Override
        public Object value(Object left, Object right) {
            if (left instanceof Float && right instanceof Float) {
                float r;
                float l = ((Float)left).floatValue();
                return l == (r = ((Float)right).floatValue());
            }
            if (left instanceof Double && right instanceof Double) {
                double r;
                double l = (Double)left;
                return l == (r = ((Double)right).doubleValue());
            }
            return left.equals(right);
        }
    };
    public static final Lambda2<Object, Object, Object> OBJECT_NOT_EQUAL = new Lambda2<Object, Object, Object>(){

        @Override
        public Object value(Object left, Object right) {
            return left != right;
        }
    };
    public static final Lambda2<Object, Object, Object> PRIMITIVE_NOT_EQUAL = new Lambda2<Object, Object, Object>(){

        @Override
        public Object value(Object left, Object right) {
            return (Boolean)PRIMITIVE_EQUAL.value(left, right) == false;
        }
    };
    public static final Lambda2<Object, Object, Object> CONCATENATE = new Lambda2<Object, Object, Object>(){

        @Override
        public Object value(Object left, Object right) {
            return (left == null ? "null" : left.toString()) + (right == null ? "null" : right.toString());
        }
    };
    public static final Lambda2<Object, Object, Object> ADD = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l + r;
        }

        public Object value(long l, long r) {
            return l + r;
        }

        public Object value(float l, float r) {
            return Float.valueOf(l + r);
        }

        public Object value(double l, double r) {
            return l + r;
        }
    };
    public static final Lambda2<Object, Object, Object> SUBTRACT = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l - r;
        }

        public Object value(long l, long r) {
            return l - r;
        }

        public Object value(float l, float r) {
            return Float.valueOf(l - r);
        }

        public Object value(double l, double r) {
            return l - r;
        }
    };
    public static final Lambda2<Object, Object, Object> MULTIPLY = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l * r;
        }

        public Object value(long l, long r) {
            return l * r;
        }

        public Object value(float l, float r) {
            return Float.valueOf(l * r);
        }

        public Object value(double l, double r) {
            return l * r;
        }
    };
    public static final Lambda2<Object, Object, Object> DIVIDE = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l / r;
        }

        public Object value(long l, long r) {
            return l / r;
        }

        public Object value(float l, float r) {
            return Float.valueOf(l / r);
        }

        public Object value(double l, double r) {
            return l / r;
        }
    };
    public static final Lambda2<Object, Object, Object> REMAINDER = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l % r;
        }

        public Object value(long l, long r) {
            return l % r;
        }

        public Object value(float l, float r) {
            return Float.valueOf(l % r);
        }

        public Object value(double l, double r) {
            return l % r;
        }
    };
    public static final Lambda2<Object, Object, Object> LESS = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l < r;
        }

        public Object value(long l, long r) {
            return l < r;
        }

        public Object value(float l, float r) {
            return l < r;
        }

        public Object value(double l, double r) {
            return l < r;
        }
    };
    public static final Lambda2<Object, Object, Object> LESS_OR_EQUAL = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l <= r;
        }

        public Object value(long l, long r) {
            return l <= r;
        }

        public Object value(float l, float r) {
            return l <= r;
        }

        public Object value(double l, double r) {
            return l <= r;
        }
    };
    public static final Lambda2<Object, Object, Object> GREATER = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l > r;
        }

        public Object value(long l, long r) {
            return l > r;
        }

        public Object value(float l, float r) {
            return l > r;
        }

        public Object value(double l, double r) {
            return l > r;
        }
    };
    public static final Lambda2<Object, Object, Object> GREATER_OR_EQUAL = new MatchingPrimitiveBinaryOperation(){

        public Object value(int l, int r) {
            return l >= r;
        }

        public Object value(long l, long r) {
            return l >= r;
        }

        public Object value(float l, float r) {
            return l >= r;
        }

        public Object value(double l, double r) {
            return l >= r;
        }
    };
    public static final Lambda2<Object, Object, Object> BIT_AND = new MatchingPrimitiveBinaryOperation(){

        public Object value(boolean l, boolean r) {
            return l & r;
        }

        public Object value(int l, int r) {
            return l & r;
        }

        public Object value(long l, long r) {
            return l & r;
        }
    };
    public static final Lambda2<Object, Object, Object> BIT_OR = new MatchingPrimitiveBinaryOperation(){

        public Object value(boolean l, boolean r) {
            return l | r;
        }

        public Object value(int l, int r) {
            return l | r;
        }

        public Object value(long l, long r) {
            return l | r;
        }
    };
    public static final Lambda2<Object, Object, Object> EXCLUSIVE_OR = new MatchingPrimitiveBinaryOperation(){

        public Object value(boolean l, boolean r) {
            return l ^ r;
        }

        public Object value(int l, int r) {
            return l ^ r;
        }

        public Object value(long l, long r) {
            return l ^ r;
        }
    };
    public static final Lambda2<Object, Object, Object> SHIFT_LEFT = new ShiftOperation(){

        public Object value(int l, int r) {
            return l << r;
        }

        public Object value(int l, long r) {
            return l << (int)r;
        }

        public Object value(long l, int r) {
            return l << r;
        }

        public Object value(long l, long r) {
            return l << (int)r;
        }
    };
    public static final Lambda2<Object, Object, Object> SHIFT_RIGHT = new ShiftOperation(){

        public Object value(int l, int r) {
            return l >> r;
        }

        public Object value(int l, long r) {
            return l >> (int)r;
        }

        public Object value(long l, int r) {
            return l >> r;
        }

        public Object value(long l, long r) {
            return l >> (int)r;
        }
    };
    public static final Lambda2<Object, Object, Object> UNSIGNED_SHIFT_RIGHT = new ShiftOperation(){

        public Object value(int l, int r) {
            return l >>> r;
        }

        public Object value(int l, long r) {
            return l >>> (int)r;
        }

        public Object value(long l, int r) {
            return l >>> r;
        }

        public Object value(long l, long r) {
            return l >>> (int)r;
        }
    };

    public ExpressionEvaluator(RuntimeBindings bindings, Options options) {
        this._bindings = bindings;
        this._options = options;
    }

    @Override
    public Object value(Node n) {
        Object result = NodeProperties.hasValue(n) ? NodeProperties.getValue(n) : (NodeProperties.hasTranslation(n) ? this.value(NodeProperties.getTranslation(n)) : n.acceptVisitor(this));
        if (NodeProperties.hasConvertedType(n)) {
            result = ExpressionEvaluator.convert(result, NodeProperties.getConvertedType(n).value());
        }
        if (NodeProperties.hasCheckedType(n)) {
            Class<?> expected = NodeProperties.getCheckedType(n).value();
            if (result != null && !expected.isInstance(result)) {
                throw new WrappedException(new EvaluatorException(new ClassCastException("From " + result.getClass().getName() + " to " + expected.getName())));
            }
        }
        return result;
    }

    @Override
    public Object visit(Literal node) {
        return node.getValue();
    }

    @Override
    public Object visit(VariableAccess node) {
        return new LValueVisitor().visit(node).value();
    }

    @Override
    public Object visit(SimpleFieldAccess node) {
        return new LValueVisitor().visit(node).value();
    }

    @Override
    public Object visit(ObjectFieldAccess node) {
        return new LValueVisitor().visit(node).value();
    }

    @Override
    public Object visit(SuperFieldAccess node) {
        return new LValueVisitor().visit(node).value();
    }

    @Override
    public Object visit(StaticFieldAccess node) {
        return new LValueVisitor().visit(node).value();
    }

    @Override
    public Object visit(ThisExpression node) {
        return this._bindings.getThis(NodeProperties.getDJClass(node));
    }

    @Override
    public Object visit(SimpleMethodCall node) {
        if (NodeProperties.hasDJClass(node)) {
            return this.handleMethodCall(node, this._bindings.getThis(NodeProperties.getDJClass(node)));
        }
        return this.handleMethodCall(node, null);
    }

    @Override
    public Object visit(ObjectMethodCall node) {
        return this.handleMethodCall(node, this.value(node.getExpression()));
    }

    @Override
    public Object visit(SuperMethodCall node) {
        return this.handleMethodCall(node, this._bindings.getThis(NodeProperties.getDJClass(node)));
    }

    @Override
    public Object visit(StaticMethodCall node) {
        return this.handleMethodCall(node, null);
    }

    private Object handleMethodCall(MethodCall node, Object receiver) {
        AbstractIterable args = node.getArguments() == null ? IterUtil.empty() : IterUtil.mapSnapshot(node.getArguments(), this);
        try {
            return NodeProperties.getMethod(node).evaluate(receiver, args, this._bindings, this._options);
        }
        catch (EvaluatorException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public Object visit(SimpleAllocation node) {
        return this.handleConstructor(node, null, node.getArguments());
    }

    @Override
    public Object visit(AnonymousAllocation node) {
        return this.handleConstructor(node, null, null);
    }

    @Override
    public Object visit(InnerAllocation node) {
        return this.handleConstructor(node, node.getExpression(), node.getArguments());
    }

    @Override
    public Object visit(AnonymousInnerAllocation node) {
        return this.handleConstructor(node, null, null);
    }

    private Object handleConstructor(Expression node, Expression outer, Iterable<Expression> args) {
        Object outerVal = outer == null ? (NodeProperties.hasEnclosingThis(node) ? this._bindings.getThis(NodeProperties.getEnclosingThis(node)) : null) : this.value(outer);
        AbstractIterable argVals = args == null ? IterUtil.empty() : IterUtil.mapSnapshot(args, this);
        try {
            return NodeProperties.getConstructor(node).evaluate(outerVal, argVals, this._bindings, this._options);
        }
        catch (EvaluatorException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public Object visit(SimpleAssignExpression node) {
        Box<Object> left = node.getLeftExpression().acceptVisitor(new LValueVisitor());
        Object val = this.value(node.getRightExpression());
        left.set(val);
        return val;
    }

    @Override
    public Object visit(TypeExpression node) {
        return NodeProperties.getErasedType(node.getType()).value();
    }

    @Override
    public Object visit(ArrayAllocation node) {
        if (node.getInitialization() != null) {
            return node.getInitialization().acceptVisitor(this);
        }
        Class<?> component = NodeProperties.getErasedType(node).value();
        int[] dims = new int[node.getSizes().size()];
        int i = 0;
        for (Object t : IterUtil.map(node.getSizes(), this)) {
            dims[i] = (Integer)t;
            component = component.getComponentType();
            ++i;
        }
        return Array.newInstance(component, dims);
    }

    @Override
    public Object visit(ArrayInitializer node) {
        Object result = Array.newInstance(NodeProperties.getErasedType(node).value().getComponentType(), node.getCells().size());
        int i = 0;
        for (Object t : IterUtil.map(node.getCells(), this)) {
            Array.set(result, i, t);
            ++i;
        }
        return result;
    }

    @Override
    public Object visit(ArrayAccess node) {
        return new LValueVisitor().visit(node).value();
    }

    @Override
    public Object visit(NotExpression node) {
        return NOT.value(this.value(node.getExpression()));
    }

    @Override
    public Object visit(ComplementExpression node) {
        return COMPLEMENT.value(this.value(node.getExpression()));
    }

    @Override
    public Object visit(PlusExpression node) {
        return PLUS.value(this.value(node.getExpression()));
    }

    @Override
    public Object visit(MinusExpression node) {
        return MINUS.value(this.value(node.getExpression()));
    }

    @Override
    public Object visit(AddExpression node) {
        return NodeProperties.getOperation(node).value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(AddAssignExpression node) {
        return this.handleOpAssignExpression(node, NodeProperties.getOperation(node));
    }

    @Override
    public Object visit(SubtractExpression node) {
        return SUBTRACT.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(SubtractAssignExpression node) {
        return this.handleOpAssignExpression(node, SUBTRACT);
    }

    @Override
    public Object visit(MultiplyExpression node) {
        return MULTIPLY.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(MultiplyAssignExpression node) {
        return this.handleOpAssignExpression(node, MULTIPLY);
    }

    @Override
    public Object visit(DivideExpression node) {
        try {
            return DIVIDE.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
        }
        catch (ArithmeticException e) {
            throw new WrappedException(new EvaluatorException((Throwable)e, "edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator$MatchingPrimitiveBinaryOperation.value", "edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator$15.value"));
        }
    }

    @Override
    public Object visit(DivideAssignExpression node) {
        return this.handleOpAssignExpression(node, DIVIDE);
    }

    @Override
    public Object visit(RemainderExpression node) {
        try {
            return REMAINDER.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
        }
        catch (ArithmeticException e) {
            throw new WrappedException(new EvaluatorException((Throwable)e, "edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator$MatchingPrimitiveBinaryOperation.value", "edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator$16.value"));
        }
    }

    @Override
    public Object visit(RemainderAssignExpression node) {
        return this.handleOpAssignExpression(node, REMAINDER);
    }

    @Override
    public Object visit(EqualExpression node) {
        return NodeProperties.getOperation(node).value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(NotEqualExpression node) {
        return NodeProperties.getOperation(node).value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(LessExpression node) {
        return LESS.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(LessOrEqualExpression node) {
        return LESS_OR_EQUAL.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(GreaterExpression node) {
        return GREATER.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(GreaterOrEqualExpression node) {
        return GREATER_OR_EQUAL.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(BitAndExpression node) {
        return BIT_AND.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(BitAndAssignExpression node) {
        return this.handleOpAssignExpression(node, BIT_AND);
    }

    @Override
    public Object visit(ExclusiveOrExpression node) {
        return EXCLUSIVE_OR.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(ExclusiveOrAssignExpression node) {
        return this.handleOpAssignExpression(node, EXCLUSIVE_OR);
    }

    @Override
    public Object visit(BitOrExpression node) {
        return BIT_OR.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(BitOrAssignExpression node) {
        return this.handleOpAssignExpression(node, BIT_OR);
    }

    @Override
    public Object visit(ShiftLeftExpression node) {
        return SHIFT_LEFT.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(ShiftLeftAssignExpression node) {
        return this.handleOpAssignExpression(node, SHIFT_LEFT);
    }

    @Override
    public Object visit(ShiftRightExpression node) {
        return SHIFT_RIGHT.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(ShiftRightAssignExpression node) {
        return this.handleOpAssignExpression(node, SHIFT_RIGHT);
    }

    @Override
    public Object visit(UnsignedShiftRightExpression node) {
        return UNSIGNED_SHIFT_RIGHT.value(this.value(node.getLeftExpression()), this.value(node.getRightExpression()));
    }

    @Override
    public Object visit(UnsignedShiftRightAssignExpression node) {
        return this.handleOpAssignExpression(node, UNSIGNED_SHIFT_RIGHT);
    }

    private Object handleOpAssignExpression(AssignExpression node, Lambda2<Object, Object, Object> op) {
        Box<Object> setter = node.getLeftExpression().acceptVisitor(new LValueVisitor());
        Object left = this.value(NodeProperties.getLeftExpression(node));
        Object right = this.value(node.getRightExpression());
        try {
            Object result = op.value(left, right);
            setter.set(result);
            return result;
        }
        catch (ArithmeticException e) {
            String[] divStack = new String[]{"edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator$MatchingPrimitiveBinaryOperation.value", "edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator$15.value"};
            String[] modStack = new String[]{"edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator$MatchingPrimitiveBinaryOperation.value", "edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator$16.value"};
            throw new WrappedException(new EvaluatorException((Throwable)e, new String[][]{divStack, modStack}));
        }
    }

    @Override
    public Object visit(AndExpression node) {
        return (Boolean)this.value(node.getLeftExpression()) != false && (Boolean)this.value(node.getRightExpression()) != false;
    }

    @Override
    public Object visit(OrExpression node) {
        return (Boolean)this.value(node.getLeftExpression()) != false || (Boolean)this.value(node.getRightExpression()) != false;
    }

    @Override
    public Object visit(InstanceOfExpression node) {
        Object v = this.value(node.getExpression());
        return NodeProperties.getErasedType(node.getReferenceType()).value().isInstance(v);
    }

    @Override
    public Object visit(CastExpression node) {
        return this.value(node.getExpression());
    }

    @Override
    public Object visit(ConditionalExpression node) {
        if (((Boolean)this.value(node.getConditionExpression())).booleanValue()) {
            return this.value(node.getIfTrueExpression());
        }
        return this.value(node.getIfFalseExpression());
    }

    @Override
    public Object visit(PostIncrement node) {
        Box<Object> setter = node.getExpression().acceptVisitor(new LValueVisitor());
        Object result = this.value(NodeProperties.getLeftExpression(node));
        setter.set(INCREMENT.value(result));
        return result;
    }

    @Override
    public Object visit(PreIncrement node) {
        Box<Object> setter = node.getExpression().acceptVisitor(new LValueVisitor());
        Object val = this.value(NodeProperties.getLeftExpression(node));
        Object result = INCREMENT.value(val);
        setter.set(result);
        return result;
    }

    @Override
    public Object visit(PostDecrement node) {
        Box<Object> setter = node.getExpression().acceptVisitor(new LValueVisitor());
        Object result = this.value(NodeProperties.getLeftExpression(node));
        setter.set(DECREMENT.value(result));
        return result;
    }

    @Override
    public Object visit(PreDecrement node) {
        Box<Object> setter = node.getExpression().acceptVisitor(new LValueVisitor());
        Object val = this.value(NodeProperties.getLeftExpression(node));
        Object result = DECREMENT.value(val);
        setter.set(result);
        return result;
    }

    public static Object convert(Object obj, Class<?> target) {
        if (target.equals(Boolean.TYPE)) {
            if (obj instanceof Boolean) {
                return obj;
            }
            throw new IllegalArgumentException();
        }
        if (target.equals(Character.TYPE)) {
            if (obj instanceof Character) {
                return obj;
            }
            if (obj instanceof Number) {
                return Character.valueOf((char)((Number)obj).intValue());
            }
            throw new IllegalArgumentException();
        }
        if (target.equals(Byte.TYPE)) {
            if (obj instanceof Byte) {
                return obj;
            }
            if (obj instanceof Character) {
                return (byte)((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).byteValue();
            }
            throw new IllegalArgumentException();
        }
        if (target.equals(Short.TYPE)) {
            if (obj instanceof Short) {
                return obj;
            }
            if (obj instanceof Character) {
                return (short)((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            throw new IllegalArgumentException();
        }
        if (target.equals(Integer.TYPE)) {
            if (obj instanceof Integer) {
                return obj;
            }
            if (obj instanceof Character) {
                return (int)((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            throw new IllegalArgumentException();
        }
        if (target.equals(Long.TYPE)) {
            if (obj instanceof Long) {
                return obj;
            }
            if (obj instanceof Character) {
                return (long)((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            throw new IllegalArgumentException();
        }
        if (target.equals(Float.TYPE)) {
            if (obj instanceof Float) {
                return obj;
            }
            if (obj instanceof Character) {
                return Float.valueOf(((Character)obj).charValue());
            }
            if (obj instanceof Number) {
                return Float.valueOf(((Number)obj).floatValue());
            }
            throw new IllegalArgumentException();
        }
        if (target.equals(Double.TYPE)) {
            if (obj instanceof Double) {
                return obj;
            }
            if (obj instanceof Character) {
                return (double)((Character)obj).charValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ShiftOperation
    implements Lambda2<Object, Object, Object> {
        private ShiftOperation() {
        }

        @Override
        public Object value(Object left, Object right) {
            if (left instanceof Integer) {
                if (right instanceof Integer) {
                    return this.value((int)((Integer)left), (int)((Integer)right));
                }
                if (right instanceof Long) {
                    return this.value((int)((Integer)left), (long)((Long)right));
                }
                throw new IllegalArgumentException();
            }
            if (left instanceof Long) {
                if (right instanceof Integer) {
                    return this.value((long)((Long)left), (int)((Integer)right));
                }
                if (right instanceof Long) {
                    return this.value((long)((Long)left), (long)((Long)right));
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(int left, int right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(int left, long right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(long left, int right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(long left, long right) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MatchingPrimitiveBinaryOperation
    implements Lambda2<Object, Object, Object> {
        private MatchingPrimitiveBinaryOperation() {
        }

        @Override
        public Object value(Object left, Object right) {
            if (left instanceof Boolean) {
                return this.value((Boolean)left, (Boolean)right);
            }
            if (left instanceof Character) {
                return this.value(((Character)left).charValue(), ((Character)right).charValue());
            }
            if (left instanceof Byte) {
                return this.value((Byte)left, (Byte)right);
            }
            if (left instanceof Short) {
                return this.value((Short)left, (Short)right);
            }
            if (left instanceof Integer) {
                return this.value((Integer)left, (Integer)right);
            }
            if (left instanceof Long) {
                return this.value((Long)left, (Long)right);
            }
            if (left instanceof Float) {
                return this.value(((Float)left).floatValue(), ((Float)right).floatValue());
            }
            if (left instanceof Double) {
                return this.value((Double)left, (Double)right);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(boolean left, boolean right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(char left, char right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(byte left, byte right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(short left, short right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(int left, int right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(long left, long right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(float left, float right) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(double left, double right) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class PrimitiveUnaryOperation
    implements Lambda<Object, Object> {
        private PrimitiveUnaryOperation() {
        }

        @Override
        public Object value(Object val) {
            if (val instanceof Boolean) {
                return this.value((Boolean)val);
            }
            if (val instanceof Character) {
                return this.value(((Character)val).charValue());
            }
            if (val instanceof Byte) {
                return this.value((Byte)val);
            }
            if (val instanceof Short) {
                return this.value((Short)val);
            }
            if (val instanceof Integer) {
                return this.value((Integer)val);
            }
            if (val instanceof Long) {
                return this.value((Long)val);
            }
            if (val instanceof Float) {
                return this.value(((Float)val).floatValue());
            }
            if (val instanceof Double) {
                return this.value((Double)val);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(boolean val) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(char val) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(byte val) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(short val) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(int val) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(long val) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(float val) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object value(double val) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LValueVisitor
    extends AbstractVisitor<Box<Object>> {
        private LValueVisitor() {
        }

        @Override
        public Box<Object> visit(AmbiguousName node) {
            return NodeProperties.getTranslation(node).acceptVisitor(this);
        }

        @Override
        public Box<Object> visit(VariableAccess node) {
            final LocalVariable var = NodeProperties.getVariable(node);
            return new Box<Object>(){

                @Override
                public Object value() {
                    return ExpressionEvaluator.this._bindings.get(var);
                }

                @Override
                public void set(Object val) {
                    ExpressionEvaluator.this._bindings.set(var, val);
                }
            };
        }

        @Override
        public Box<Object> visit(SimpleFieldAccess node) {
            Object receiver = NodeProperties.hasDJClass(node) ? ExpressionEvaluator.this._bindings.getThis(NodeProperties.getDJClass(node)) : null;
            return NodeProperties.getField(node).boxForReceiver(receiver);
        }

        @Override
        public Box<Object> visit(ObjectFieldAccess node) {
            if (NodeProperties.hasTranslation(node)) {
                return NodeProperties.getTranslation(node).acceptVisitor(this);
            }
            return NodeProperties.getField(node).boxForReceiver(ExpressionEvaluator.this.value(node.getExpression()));
        }

        @Override
        public Box<Object> visit(SuperFieldAccess node) {
            return NodeProperties.getField(node).boxForReceiver(ExpressionEvaluator.this._bindings.getThis(NodeProperties.getDJClass(node)));
        }

        @Override
        public Box<Object> visit(StaticFieldAccess node) {
            return NodeProperties.getField(node).boxForReceiver(null);
        }

        @Override
        public Box<Object> visit(ArrayAccess node) {
            final Object array = ExpressionEvaluator.this.value(node.getExpression());
            final Integer index = (Integer)ExpressionEvaluator.this.value(node.getCellNumber());
            return new Box<Object>(){

                @Override
                public Object value() {
                    try {
                        return Array.get(array, index);
                    }
                    catch (NullPointerException e) {
                        throw new WrappedException(new EvaluatorException((Throwable)e, "java.lang.reflect.Array.get"));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new WrappedException(new EvaluatorException((Throwable)e, "java.lang.reflect.Array.get"));
                    }
                }

                @Override
                public void set(Object val) {
                    try {
                        Array.set(array, index, val);
                    }
                    catch (NullPointerException e) {
                        throw new WrappedException(new EvaluatorException((Throwable)e, "java.lang.reflect.Array.set"));
                    }
                    catch (IllegalArgumentException e) {
                        ArrayStoreException newE = new ArrayStoreException();
                        newE.setStackTrace(e.getStackTrace());
                        throw new WrappedException(new EvaluatorException((Throwable)newE, "java.lang.reflect.Array.set"));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new WrappedException(new EvaluatorException((Throwable)e, "java.lang.reflect.Array.set"));
                    }
                }
            };
        }
    }
}

