/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class LanguageLevelStackTraceMapper {
    public static final Log LOG = new Log("llstm.txt", false);
    private volatile HashMap<String, TreeMap<Integer, Integer>> cache;
    private volatile GlobalModel aGModel;

    public LanguageLevelStackTraceMapper(GlobalModel aGM) {
        this.aGModel = aGM;
        this.cache = new HashMap();
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, File d, TreeMap<Integer, Integer> m) {
        int jl = s.getLineNumber();
        int lll = m.containsKey(jl) ? m.get(jl) : -1;
        return new StackTraceElement(s.getClassName(), s.getMethodName(), d.getName(), lll);
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, File d) {
        if (!this.matches(d, s)) {
            return s;
        }
        String fileName = d.getAbsolutePath();
        if (this.cache.containsKey(fileName)) {
            return this.replaceStackTraceElement(s, d, this.cache.get(fileName));
        }
        String dn = d.getName();
        dn = dn.substring(0, dn.lastIndexOf(46)) + ".java";
        File javaFile = new File(d.getParentFile(), dn);
        TreeMap<Integer, Integer> djToJavaMap = this.readLLLineBlock(javaFile);
        this.cache.put(fileName, djToJavaMap);
        return this.replaceStackTraceElement(s, d, djToJavaMap);
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, List<File> ds) {
        for (int i = 0; i < ds.size(); ++i) {
            s = this.replaceStackTraceElement(s, ds.get(i));
        }
        return s;
    }

    public StackTraceElement[] replaceStackTrace(StackTraceElement[] ss, List<File> ds) {
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.replaceStackTraceElement(ss[i], ds);
        }
        return ss;
    }

    public void clearCache() {
        this.cache = new HashMap();
    }

    private boolean matches(File f, StackTraceElement s) {
        LOG.log("matches(" + f + ", " + s + ")");
        if (s.getFileName() == null) {
            return false;
        }
        String fn = f.getPath();
        if (!DrJavaFileUtils.isLLFile(fn)) {
            return false;
        }
        String javaFn = DrJavaFileUtils.getJavaForLLFile(fn);
        return javaFn.endsWith(s.getFileName());
    }

    private TreeMap<Integer, Integer> createOneToOneMap(BufferedReader bufReader) {
        TreeMap<Integer, Integer> oneToOne = new TreeMap<Integer, Integer>();
        int lineNo = 1;
        oneToOne.put(lineNo, lineNo);
        try {
            String rdLine;
            while ((rdLine = bufReader.readLine()) != null) {
                oneToOne.put(++lineNo, lineNo);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return oneToOne;
    }

    public TreeMap<Integer, Integer> readLLLineBlock(File LLFile) {
        BufferedReader bufReader = null;
        String rdLine = "";
        try {
            bufReader = new BufferedReader(new FileReader(LLFile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            rdLine = bufReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!rdLine.startsWith("// Language Level Converter line number map: dj*->java. Entries:")) {
            return this.createOneToOneMap(bufReader);
        }
        LOG.log("rdLine = '" + rdLine + "'");
        LOG.log("\tlastIndex = " + rdLine.lastIndexOf(" "));
        Integer mapSize = new Integer(rdLine.substring(rdLine.lastIndexOf(" ") + 1));
        try {
            rdLine = bufReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (rdLine.indexOf("//") != 0) {
            mapSize = 0;
        }
        TreeMap<Integer, Integer> javaDJMap = new TreeMap<Integer, Integer>();
        String text = rdLine.substring(2).trim() + " ";
        for (int i = 0; i < mapSize; ++i) {
            if (text.length() < 2) {
                text = this.readNextLLBlockLine(bufReader);
            }
            if (text == null) break;
            int firstBlankPos = text.indexOf(" ");
            String numRnum = text.substring(0, firstBlankPos);
            text = text.substring(firstBlankPos).trim() + " ";
            Integer djNum = new Integer(numRnum.substring(0, numRnum.indexOf("->")));
            Integer javaNum = new Integer(numRnum.substring(numRnum.indexOf("->") + 2));
            javaDJMap.put(javaNum, djNum);
        }
        return javaDJMap;
    }

    public TreeMap<Integer, Integer> readLLBlock(File LLFile) {
        BufferedReader bufReader = null;
        String rdLine = "";
        try {
            bufReader = new BufferedReader(new FileReader(LLFile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            rdLine = bufReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!rdLine.startsWith("// Language Level Converter line number map: dj*->java. Entries:")) {
            return this.createOneToOneMap(bufReader);
        }
        LOG.log("rdLine = '" + rdLine + "'");
        LOG.log("\tlastIndex = " + rdLine.lastIndexOf(" "));
        Integer mapSize = new Integer(rdLine.substring(rdLine.lastIndexOf(" ") + 1));
        try {
            rdLine = bufReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (rdLine.indexOf("//") != 0) {
            mapSize = 0;
        }
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        String text = rdLine.substring(2).trim() + " ";
        String numRnum = "";
        for (int i = 0; i < mapSize; ++i) {
            if (text.length() < 2) {
                text = this.readNextLLBlockLine(bufReader);
            }
            if (text == null) break;
            numRnum = text.substring(0, text.indexOf(" "));
            int djNum = Integer.parseInt(numRnum.substring(0, numRnum.indexOf("->")), 10);
            int javaNum = Integer.parseInt(numRnum.substring(numRnum.indexOf("->") + 2), 10);
            map.put(djNum, javaNum);
            text = text.substring(text.indexOf(" ")).trim() + " ";
        }
        return map;
    }

    private String readNextLLBlockLine(BufferedReader br) {
        String line = "";
        try {
            line = br.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (line.indexOf("//") != 0) {
            return null;
        }
        line = line.substring(2).trim() + " ";
        return line;
    }
}

