/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.ui.SmartSourceFilter;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.swing.SwingUtil;
import edu.rice.cs.util.ArgumentTokenizer;
import java.applet.Applet;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public abstract class JavacCompiler
implements CompilerInterface {
    protected final JavaVersion.FullVersion _version;
    protected final String _location;
    protected List<? extends File> _defaultBootClassPath;
    protected static final Set<String> ACM_PROGRAM_CLASSES;
    public static final HashSet<String> JAVA_KEYWORDS;

    protected JavacCompiler(JavaVersion.FullVersion version, String location, List<? extends File> defaultBootClassPath) {
        this._version = version;
        this._location = location;
        this._defaultBootClassPath = defaultBootClassPath;
    }

    @Override
    public abstract boolean isAvailable();

    @Override
    public abstract List<? extends DJError> compile(List<? extends File> var1, List<? extends File> var2, List<? extends File> var3, File var4, List<? extends File> var5, String var6, boolean var7);

    @Override
    public JavaVersion version() {
        return this._version.majorVersion();
    }

    @Override
    public String getName() {
        return "JDK " + this._version.versionString();
    }

    @Override
    public String getDescription() {
        return this.getName() + " from " + this._location;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public List<File> additionalBootClassPathForInteractions() {
        return Arrays.asList(new File[0]);
    }

    @Override
    public String transformCommands(String interactionsString) {
        if (interactionsString.startsWith("java ")) {
            interactionsString = JavacCompiler.transformJavaCommand(interactionsString);
        } else if (interactionsString.startsWith("applet ")) {
            interactionsString = JavacCompiler.transformAppletCommand(interactionsString);
        } else if (interactionsString.startsWith("run ")) {
            interactionsString = JavacCompiler.transformRunCommand(interactionsString);
        }
        return interactionsString;
    }

    public static String transformJavaCommand(String s) {
        String command = "try '{'\n  java.lang.reflect.Method m = {0}.class.getMethod(\"main\", java.lang.String[].class);\n  if (!m.getReturnType().equals(void.class)) throw new java.lang.NoSuchMethodException();\n'}'\ncatch (java.lang.NoSuchMethodException e) '{'\n  throw new java.lang.NoSuchMethodError(\"main\");\n'}'\n{0}.main(new String[]'{'{1}'}');";
        return JavacCompiler._transformCommand(s, command);
    }

    public static String transformAppletCommand(String s) {
        return JavacCompiler._transformCommand(s, "edu.rice.cs.plt.swing.SwingUtil.showApplet(new {0}({1}), 400, 300);");
    }

    public static void runCommand(String s, Class<?> c) throws Throwable {
        if (s.endsWith(";")) {
            s = JavacCompiler._deleteSemiColon(s);
        }
        List<String> tokens = ArgumentTokenizer.tokenize(s, true);
        String classNameWithQuotes = tokens.get(1);
        String className = classNameWithQuotes.substring(1, classNameWithQuotes.length() - 1);
        String[] args = new String[tokens.size() - 2];
        for (int i = 2; i < tokens.size(); ++i) {
            String t = tokens.get(i);
            args[i - 2] = t.substring(1, t.length() - 1);
        }
        boolean isProgram = false;
        boolean isApplet = false;
        Class<?> oldC = c;
        while (c != null) {
            if (ACM_PROGRAM_CLASSES.contains(c.getName())) {
                isProgram = true;
                break;
            }
            c = c.getSuperclass();
        }
        c = oldC;
        if (!isProgram) {
            try {
                c.asSubclass(Applet.class);
                isApplet = true;
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
        Method m = null;
        if (isApplet) {
            try {
                m = c.getMethod("main", String[].class);
                if (!m.getReturnType().equals(Void.TYPE)) {
                    m = null;
                }
            }
            catch (NoSuchMethodException e) {
                m = null;
            }
            if (m == null) {
                Applet instance = null;
                if (args.length == 0) {
                    Constructor<?> ctor;
                    try {
                        ctor = c.getConstructor(new Class[0]);
                        instance = (Applet)Applet.class.cast(ctor.newInstance(new Object[0]));
                    }
                    catch (NoSuchMethodException nsme) {
                        instance = null;
                    }
                    catch (InstantiationException ie) {
                        instance = null;
                    }
                    catch (IllegalAccessException iae) {
                        instance = null;
                    }
                    catch (InvocationTargetException ite) {
                        if (ite.getCause() != null) {
                            throw ite.getCause();
                        }
                        System.err.println("Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.");
                    }
                    if (instance == null) {
                        try {
                            ctor = c.getConstructor(String[].class);
                            instance = (Applet)Applet.class.cast(ctor.newInstance(new Object[]{new String[0]}));
                        }
                        catch (NoSuchMethodException nsme) {
                            instance = null;
                        }
                        catch (InstantiationException ie) {
                            instance = null;
                        }
                        catch (IllegalAccessException iae) {
                            instance = null;
                        }
                        catch (InvocationTargetException ite) {
                            if (ite.getCause() != null) {
                                throw ite.getCause();
                            }
                            System.err.println("Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.");
                            return;
                        }
                    }
                    if (instance == null) {
                        System.err.println("Static Error: This applet does not have a default constructor or a constructor accepting String[].");
                        return;
                    }
                } else {
                    try {
                        Constructor<?> ctor = c.getConstructor(String[].class);
                        instance = (Applet)Applet.class.cast(ctor.newInstance(new Object[]{args}));
                    }
                    catch (NoSuchMethodException nsme) {
                        instance = null;
                    }
                    catch (InstantiationException ie) {
                        instance = null;
                    }
                    catch (IllegalAccessException iae) {
                        instance = null;
                    }
                    catch (InvocationTargetException ite) {
                        if (ite.getCause() != null) {
                            throw ite.getCause();
                        }
                        System.err.println("Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.");
                        return;
                    }
                    if (instance == null) {
                        System.err.println("Static Error: This applet does not have a constructor accepting String[].");
                        return;
                    }
                }
                SwingUtil.showApplet(instance, 400, 300);
            }
        } else {
            try {
                m = c.getMethod("main", String[].class);
                if (!m.getReturnType().equals(Void.TYPE)) {
                    System.err.println("Static Error: This class does not have a static void main method accepting String[].");
                    m = null;
                }
            }
            catch (NoSuchMethodException e) {
                System.err.println("Static Error: This class does not have a static void main method accepting String[].");
                m = null;
            }
        }
        if (m != null) {
            if (isProgram) {
                String[] newArgs = new String[args.length + 1];
                newArgs[0] = "code=" + c.getName();
                System.arraycopy(args, 0, newArgs, 1, args.length);
                args = newArgs;
            }
            try {
                m.setAccessible(true);
                m.invoke(null, new Object[]{args});
            }
            catch (SecurityException se) {
                System.err.println("Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.");
            }
            catch (IllegalAccessException iae) {
                System.err.println("Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.");
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() != null) {
                    throw ite.getCause();
                }
                System.err.println("Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.");
            }
        }
    }

    public static String transformRunCommand(String s) {
        if (s.endsWith(";")) {
            s = JavacCompiler._deleteSemiColon(s);
        }
        List<String> args = ArgumentTokenizer.tokenize(s, true);
        String classNameWithQuotes = args.get(1);
        String className = classNameWithQuotes.substring(1, classNameWithQuotes.length() - 1);
        String ret = JavacCompiler.class.getName() + ".runCommand(\"" + s.toString() + "\", " + className + ".class)";
        return ret;
    }

    protected static String _transformCommand(String s, String command) {
        if (s.endsWith(";")) {
            s = JavacCompiler._deleteSemiColon(s);
        }
        List<String> args = ArgumentTokenizer.tokenize(s, true);
        String classNameWithQuotes = args.get(1);
        String className = classNameWithQuotes.substring(1, classNameWithQuotes.length() - 1);
        StringBuilder argsString = new StringBuilder();
        boolean seenArg = false;
        for (int i = 2; i < args.size(); ++i) {
            if (seenArg) {
                argsString.append(",");
            } else {
                seenArg = true;
            }
            argsString.append(args.get(i));
        }
        return MessageFormat.format(command, className, argsString.toString());
    }

    protected static String _deleteSemiColon(String s) {
        return s.substring(0, s.length() - 1);
    }

    @Override
    public boolean isSourceFileForThisCompiler(File f) {
        return DrJavaFileUtils.isSourceFile(f);
    }

    @Override
    public Set<String> getSourceFileExtensions() {
        return DrJavaFileUtils.getSourceFileExtensions();
    }

    @Override
    public String getSuggestedFileExtension() {
        return DrJavaFileUtils.getSuggestedFileExtension();
    }

    @Override
    public FileFilter getFileFilter() {
        return new SmartSourceFilter();
    }

    @Override
    public String getOpenAllFilesInFolderExtension() {
        return OptionConstants.LANGUAGE_LEVEL_EXTENSIONS[DrJava.getConfig().getSetting(OptionConstants.LANGUAGE_LEVEL)];
    }

    @Override
    public boolean supportsLanguageLevels() {
        return true;
    }

    @Override
    public Set<String> getKeywordsForFile(File f) {
        return new HashSet<String>(JAVA_KEYWORDS);
    }

    static {
        String[] words;
        ACM_PROGRAM_CLASSES = new HashSet<String>();
        Collections.addAll(ACM_PROGRAM_CLASSES, "acm.program.Program", "acm.graphics.GTurtle");
        JAVA_KEYWORDS = new HashSet();
        for (String s : words = new String[]{"import", "native", "package", "goto", "const", "if", "else", "switch", "while", "for", "do", "true", "false", "null", "this", "super", "new", "instanceof", "return", "static", "synchronized", "transient", "volatile", "final", "strictfp", "throw", "try", "catch", "finally", "throws", "extends", "implements", "interface", "class", "break", "continue", "public", "protected", "private", "abstract", "case", "default", "assert", "enum"}) {
            JAVA_KEYWORDS.add(s);
        }
    }
}

