/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableTableAttributeInfo
extends AAttributeInfo {
    public LocalVariableTableAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public int getLocalVariableCount() {
        int res = Types.ushortFromBytes(this._data, 0);
        assert (res <= 65535);
        return res;
    }

    public LocalVariableRecord[] getLocalVariables() throws ClassFormatError {
        int count = this.getLocalVariableCount();
        LocalVariableRecord[] lvr = new LocalVariableRecord[count];
        for (int i = 0; i < count; ++i) {
            lvr[i] = new LocalVariableRecord(Types.ushortFromBytes(this._data, 2 + 10 * i), Types.ushortFromBytes(this._data, 4 + 10 * i), ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 6 + 10 * i))).execute(CheckUTFVisitor.singleton(), null), ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 8 + 10 * i))).execute(CheckUTFVisitor.singleton(), null), Types.ushortFromBytes(this._data, 10 + 10 * i));
        }
        return lvr;
    }

    public void setLocalVariables(LocalVariableRecord[] lnr) {
        byte[] newData = new byte[2 + 10 * lnr.length];
        Types.bytesFromShort((short)lnr.length, newData, 0);
        for (int i = 0; i < lnr.length; ++i) {
            Types.bytesFromShort((short)(0xFFFF & lnr[i].startPC), newData, 2 + 10 * i);
            Types.bytesFromShort((short)(0xFFFF & lnr[i].length), newData, 4 + 10 * i);
            Types.bytesFromShort(this._constantPool.indexOf(lnr[i].name), newData, 6 + 10 * i);
            Types.bytesFromShort(this._constantPool.indexOf(lnr[i].descriptor), newData, 8 + 10 * i);
            Types.bytesFromShort((short)(0xFFFF & lnr[i].index), newData, 10 + 10 * i);
        }
        this.setData(newData);
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.localVariableTableCase(this, param);
    }

    @Override
    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(this._name + " <" + this.getLocalVariableCount() + " local variables{ ");
        boolean first = true;
        for (LocalVariableRecord lvrs : this.getLocalVariables()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            x.append("(PC=" + lvrs.startPC + ".." + (lvrs.startPC + lvrs.length) + ", " + ClassFileTools.getTypeString(lvrs.descriptor.toString(), lvrs.name.toString()) + ", index " + lvrs.index + ")");
        }
        x.append(" } >");
        return x.toString();
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
        LocalVariableRecord[] lvrs;
        for (LocalVariableRecord l : lvrs = this.getLocalVariables()) {
            if (l.startPC >= startPC) {
                l.startPC += deltaPC;
            }
            if (l.startPC > startPC || l.startPC + l.length < startPC) continue;
            l.length += deltaPC;
        }
        this.setLocalVariables(lvrs);
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
        LocalVariableRecord[] lvrs;
        for (LocalVariableRecord l : lvrs = this.getLocalVariables()) {
            int oldEndLineNo;
            int oldLineNo = oldLnt.getLineNumber(l.startPC);
            l.startPC = newLnt.getPC(oldLineNo += oldLineNo > index ? deltaIndex : 0);
            l.length = newLnt.getPC(oldEndLineNo += (oldEndLineNo = oldLnt.getLineNumber(l.startPC + l.length)) > index ? deltaIndex : 0) - l.startPC;
        }
        this.setLocalVariables(lvrs);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getAttributeName() {
        return "LocalVariableTable";
    }

    public static class LocalVariableRecord {
        public int startPC;
        public int length;
        public AUTFPoolInfo name;
        public AUTFPoolInfo descriptor;
        public int index;

        public LocalVariableRecord(int startPC, int length, AUTFPoolInfo name, AUTFPoolInfo descriptor, int index) {
            this.startPC = startPC;
            this.length = length;
            this.name = name;
            this.descriptor = descriptor;
            this.index = index;
        }
    }
}

